; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -indvars -scalar-evolution-use-expensive-range-sharpening -S | FileCheck %s

target triple = "x86_64--linux-gnu"

; Provide legal integer types.
target datalayout = "n8:16:32:64"

declare void @foo(i64 %v)
declare void @bar(i32 %v)

define void @test1() {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[INDVARS2:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    call void @bar(i32 [[INDVARS2]])
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val1 = phi i32 [ %val1.inc, %loop ], [ 0, %entry ]
  %val1.inc = add i32 %val1, 1
  %iv.next = add i32 %iv, 1
  call void @bar(i32 %val1.inc)
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test2() {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[VAL1:%.*]] = phi i64 [ [[VAL1_INC:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[VAL1_INC]] = add nuw nsw i64 [[VAL1]], 1
; CHECK-NEXT:    call void @foo(i64 [[VAL1_INC]])
; CHECK-NEXT:    call void @foo(i64 [[VAL1]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[VAL1]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val1 = phi i64 [ %val1.inc, %loop ], [ 0, %entry ]
  %val1.inc = add i64 %val1, 1
  %iv.next = add i32 %iv, 1
  call void @foo(i64 %val1.inc)
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test3() {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val1 = phi i32 [ %val1.inc, %loop ], [ 0, %entry ]
  %val1.inc = add i32 %val1, 1
  %iv.next = add i32 %iv, 1
  %val1.wide = zext i32 %val1 to i64
  call void @foo(i64 %val1.wide)
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test4(i32* %ptr) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 0, i32* [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[INDVARS:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    store i32 [[INDVARS]], i32* [[PTR]], align 4
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  store i32 0, i32* %ptr, align 4
  br label %loop

loop:                                             ; preds = %loop, %entry
  %val = phi i32 [ %val.inc, %loop ], [ 0, %entry ]
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val.inc = add i32 %val, 1
  store i32 %val.inc, i32* %ptr, align 4
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %iv.next = add i32 %iv, 1
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}
