; RUN: opt -passes=sroa -S %s -o - | FileCheck %s

;; $ cat test.cpp
;; class a {
;; public:
;;   float b[4];
;;   void c();
;; };
;; class B {
;; public:
;;   B(a d) : e(d) {}
;;   a &f() { return e; }
;;   B operator*(const B &)const;
;;   int g;
;;   a e;
;; };
;; B B::operator*(const B &)const { return e; }
;; class h {
;; public:
;;   B i();
;; };
;; void j() {
;;   h convexbody, k;
;;   B l = k.i(), m = convexbody.i(), n = l * m;
;;   a o = n.f(); // Looking at this store, o[0, 128] <- n[32, 160].
;;   o.c();
;; }
;; Generated by grabbing IR before sroa in:
;; $ clang++ -O2 -g -c test.cpp -Xclang -fexperimental-assignment-tracking

;; Check that the store 4xfloat split into 2x store 2xfloat has correct debug
;; info when the source (n, 160 bits of int+5*float) is split beforehand (see
;; comment in test.cpp above). Ensure that only the value-expression gets
;; fragment info; that the address-expression remains untouched.

;; Check nearby instructions to make sure we're looking in the right place.
; CHECK: define dso_local void @_Z1jv()
; CHECK: call void @_ZN1h1iEv(ptr nonnull sret(%class.B) align 4 %m,

; CHECK: store <2 x float> %agg.tmp.sroa.0.0.copyload.i, ptr %4, align 4,{{.+}}!DIAssignID ![[id1:[0-9]+]]
; CHECK: store <2 x float> %agg.tmp.sroa.2.0.copyload.i, ptr %n.sroa.4.4..sroa_idx, align 4,{{.+}}!DIAssignID ![[id2:[0-9]+]]
; CHECK-NEXT: call void @llvm.dbg.assign(metadata <2 x float> %agg.tmp.sroa.0.0.copyload.i, metadata ![[var:[0-9]+]], metadata !DIExpression(DW_OP_LLVM_fragment, 0, 64), metadata ![[id1]], metadata ptr %4, metadata !DIExpression()), !dbg
; CHECK-NEXT: call void @llvm.dbg.assign(metadata <2 x float> %agg.tmp.sroa.2.0.copyload.i, metadata ![[var]], metadata !DIExpression(DW_OP_LLVM_fragment, 64, 64), metadata ![[id2]], metadata ptr %n.sroa.4.4..sroa_idx, metadata !DIExpression()), !dbg

; CHECK: ret

%class.B = type { i32, %class.a }
%class.a = type { [4 x float] }
%class.h = type { i8 }

$_ZN1BC2E1a = comdat any

$_ZN1B1fEv = comdat any

; Function Attrs: nofree norecurse nounwind uwtable
define dso_local void @_ZNK1BmlERKS_(ptr noalias nocapture sret(%class.B) align 4 %agg.result, ptr nocapture readonly %this, ptr nocapture nonnull readnone align 4 dereferenceable(20) %0) local_unnamed_addr #0 align 2 !dbg !7 {
entry:
  %agg.tmp.sroa.0.0..sroa_idx = getelementptr inbounds %class.B, ptr %this, i64 0, i32 1, !dbg !42
  %agg.tmp.sroa.0.0..sroa_cast = bitcast ptr %agg.tmp.sroa.0.0..sroa_idx to ptr, !dbg !42
  %agg.tmp.sroa.0.0.copyload = load <2 x float>, ptr %agg.tmp.sroa.0.0..sroa_cast, align 4, !dbg !42
  %agg.tmp.sroa.2.0..sroa_idx2 = getelementptr inbounds %class.B, ptr %this, i64 0, i32 1, i32 0, i64 2, !dbg !42
  %agg.tmp.sroa.2.0..sroa_cast = bitcast ptr %agg.tmp.sroa.2.0..sroa_idx2 to ptr, !dbg !42
  %agg.tmp.sroa.2.0.copyload = load <2 x float>, ptr %agg.tmp.sroa.2.0..sroa_cast, align 4, !dbg !42
  %d.sroa.0.0..sroa_idx.i = getelementptr inbounds %class.B, ptr %agg.result, i64 0, i32 1, !dbg !47
  %d.sroa.0.0..sroa_cast.i = bitcast ptr %d.sroa.0.0..sroa_idx.i to ptr, !dbg !47
  store <2 x float> %agg.tmp.sroa.0.0.copyload, ptr %d.sroa.0.0..sroa_cast.i, align 4, !dbg !47
  %d.sroa.2.0..sroa_idx2.i = getelementptr inbounds %class.B, ptr %agg.result, i64 0, i32 1, i32 0, i64 2, !dbg !47
  %d.sroa.2.0..sroa_cast.i = bitcast ptr %d.sroa.2.0..sroa_idx2.i to ptr, !dbg !47
  store <2 x float> %agg.tmp.sroa.2.0.copyload, ptr %d.sroa.2.0..sroa_cast.i, align 4, !dbg !47
  ret void, !dbg !54
}

; Function Attrs: argmemonly nofree nosync nounwind willreturn
declare void @llvm.memcpy.p0i8.p0i8.i64(ptr noalias nocapture writeonly, ptr noalias nocapture readonly, i64, i1 immarg) #1

; Function Attrs: nounwind uwtable
define linkonce_odr dso_local void @_ZN1BC2E1a(ptr %this, <2 x float> %d.coerce0, <2 x float> %d.coerce1) unnamed_addr #2 comdat align 2 !dbg !48 {
entry:
  %d.sroa.0.0..sroa_idx = getelementptr inbounds %class.B, ptr %this, i64 0, i32 1, !dbg !55
  %d.sroa.0.0..sroa_cast = bitcast ptr %d.sroa.0.0..sroa_idx to ptr, !dbg !55
  store <2 x float> %d.coerce0, ptr %d.sroa.0.0..sroa_cast, align 4, !dbg !55
  %d.sroa.2.0..sroa_idx2 = getelementptr inbounds %class.B, ptr %this, i64 0, i32 1, i32 0, i64 2, !dbg !55
  %d.sroa.2.0..sroa_cast = bitcast ptr %d.sroa.2.0..sroa_idx2 to ptr, !dbg !55
  store <2 x float> %d.coerce1, ptr %d.sroa.2.0..sroa_cast, align 4, !dbg !55
  ret void, !dbg !56
}

; Function Attrs: nofree nosync nounwind readnone speculatable willreturn
declare void @llvm.dbg.assign(metadata, metadata, metadata, metadata, metadata, metadata) #3

; Function Attrs: uwtable
define dso_local void @_Z1jv() local_unnamed_addr #4 !dbg !57 {
entry:
  %convexbody = alloca %class.h, align 1, !DIAssignID !73
  call void @llvm.dbg.assign(metadata i1 undef, metadata !61, metadata !DIExpression(), metadata !73, metadata ptr %convexbody, metadata !DIExpression()), !dbg !74
  %k = alloca %class.h, align 1, !DIAssignID !75
  call void @llvm.dbg.assign(metadata i1 undef, metadata !68, metadata !DIExpression(), metadata !75, metadata ptr %k, metadata !DIExpression()), !dbg !74
  %l = alloca %class.B, align 4, !DIAssignID !76
  call void @llvm.dbg.assign(metadata i1 undef, metadata !69, metadata !DIExpression(), metadata !76, metadata ptr %l, metadata !DIExpression()), !dbg !74
  %m = alloca %class.B, align 4, !DIAssignID !77
  call void @llvm.dbg.assign(metadata i1 undef, metadata !70, metadata !DIExpression(), metadata !77, metadata ptr %m, metadata !DIExpression()), !dbg !74
  %n = alloca %class.B, align 4, !DIAssignID !78
  call void @llvm.dbg.assign(metadata i1 undef, metadata !71, metadata !DIExpression(), metadata !78, metadata ptr %n, metadata !DIExpression()), !dbg !74
  %o = alloca %class.a, align 4, !DIAssignID !79
  call void @llvm.dbg.assign(metadata i1 undef, metadata !72, metadata !DIExpression(), metadata !79, metadata ptr %o, metadata !DIExpression()), !dbg !74
  %0 = getelementptr inbounds %class.h, ptr %convexbody, i64 0, i32 0, !dbg !80
  call void @llvm.lifetime.start.p0i8(i64 1, ptr nonnull %0) #7, !dbg !80
  %1 = getelementptr inbounds %class.h, ptr %k, i64 0, i32 0, !dbg !80
  call void @llvm.lifetime.start.p0i8(i64 1, ptr nonnull %1) #7, !dbg !80
  %2 = bitcast ptr %l to ptr, !dbg !81
  call void @llvm.lifetime.start.p0i8(i64 20, ptr nonnull %2) #7, !dbg !81
  call void @_ZN1h1iEv(ptr nonnull sret(%class.B) align 4 %l, ptr nonnull %k), !dbg !82
  %3 = bitcast ptr %m to ptr, !dbg !81
  call void @llvm.lifetime.start.p0i8(i64 20, ptr nonnull %3) #7, !dbg !81
  call void @_ZN1h1iEv(ptr nonnull sret(%class.B) align 4 %m, ptr nonnull %convexbody), !dbg !83
  %4 = bitcast ptr %n to ptr, !dbg !81
  call void @llvm.lifetime.start.p0i8(i64 20, ptr nonnull %4) #7, !dbg !81
  %agg.tmp.sroa.0.0..sroa_idx.i = getelementptr inbounds %class.B, ptr %l, i64 0, i32 1, !dbg !84
  %agg.tmp.sroa.0.0..sroa_cast.i = bitcast ptr %agg.tmp.sroa.0.0..sroa_idx.i to ptr, !dbg !84
  %agg.tmp.sroa.0.0.copyload.i = load <2 x float>, ptr %agg.tmp.sroa.0.0..sroa_cast.i, align 4, !dbg !84
  %agg.tmp.sroa.2.0..sroa_idx2.i = getelementptr inbounds %class.B, ptr %l, i64 0, i32 1, i32 0, i64 2, !dbg !84
  %agg.tmp.sroa.2.0..sroa_cast.i = bitcast ptr %agg.tmp.sroa.2.0..sroa_idx2.i to ptr, !dbg !84
  %agg.tmp.sroa.2.0.copyload.i = load <2 x float>, ptr %agg.tmp.sroa.2.0..sroa_cast.i, align 4, !dbg !84
  %d.sroa.0.0..sroa_idx.i.i = getelementptr inbounds %class.B, ptr %n, i64 0, i32 1, !dbg !89
  %d.sroa.0.0..sroa_cast.i.i = bitcast ptr %d.sroa.0.0..sroa_idx.i.i to ptr, !dbg !89
  store <2 x float> %agg.tmp.sroa.0.0.copyload.i, ptr %d.sroa.0.0..sroa_cast.i.i, align 4, !dbg !89
  %d.sroa.2.0..sroa_idx2.i.i = getelementptr inbounds %class.B, ptr %n, i64 0, i32 1, i32 0, i64 2, !dbg !89
  %d.sroa.2.0..sroa_cast.i.i = bitcast ptr %d.sroa.2.0..sroa_idx2.i.i to ptr, !dbg !89
  store <2 x float> %agg.tmp.sroa.2.0.copyload.i, ptr %d.sroa.2.0..sroa_cast.i.i, align 4, !dbg !89
  %5 = bitcast ptr %o to ptr, !dbg !91
  call void @llvm.lifetime.start.p0i8(i64 16, ptr nonnull %5) #7, !dbg !91
  %e.i = getelementptr inbounds %class.B, ptr %n, i64 0, i32 1, !dbg !92
  %6 = bitcast ptr %e.i to ptr, !dbg !97
  call void @llvm.memcpy.p0i8.p0i8.i64(ptr nonnull align 4 dereferenceable(16) %5, ptr nonnull align 4 dereferenceable(16) %6, i64 16, i1 false), !dbg !97, !DIAssignID !98
  call void @llvm.dbg.assign(metadata i1 undef, metadata !72, metadata !DIExpression(), metadata !98, metadata ptr %5, metadata !DIExpression()), !dbg !74
  call void @_ZN1a1cEv(ptr nonnull %o), !dbg !99
  call void @llvm.lifetime.end.p0i8(i64 16, ptr nonnull %5) #7, !dbg !100
  call void @llvm.lifetime.end.p0i8(i64 20, ptr nonnull %4) #7, !dbg !100
  call void @llvm.lifetime.end.p0i8(i64 20, ptr nonnull %3) #7, !dbg !100
  call void @llvm.lifetime.end.p0i8(i64 20, ptr nonnull %2) #7, !dbg !100
  call void @llvm.lifetime.end.p0i8(i64 1, ptr nonnull %1) #7, !dbg !100
  call void @llvm.lifetime.end.p0i8(i64 1, ptr nonnull %0) #7, !dbg !100
  ret void, !dbg !100
}

declare void @llvm.lifetime.start.p0i8(i64 immarg, ptr nocapture) #1
declare dso_local void @_ZN1h1iEv(ptr sret(%class.B) align 4, ptr) local_unnamed_addr #5

; Function Attrs: nounwind uwtable
define linkonce_odr dso_local nonnull align 4 dereferenceable(16) ptr @_ZN1B1fEv(ptr %this) local_unnamed_addr #6 comdat align 2 !dbg !93 {
entry:
  %e = getelementptr inbounds %class.B, ptr %this, i64 0, i32 1, !dbg !101
  ret ptr %e, !dbg !102
}

declare dso_local void @_ZN1a1cEv(ptr) local_unnamed_addr #5

; Function Attrs: argmemonly nofree nosync nounwind willreturn
declare void @llvm.lifetime.end.p0i8(i64 immarg, ptr nocapture) #1

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!3, !4, !5, !1000}
!llvm.ident = !{!6}

!0 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !1, producer: "clang version 12.0.0", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !2, splitDebugInlining: false, nameTableKind: None)
!1 = !DIFile(filename: "reduce.cpp", directory: "/")
!2 = !{}
!3 = !{i32 7, !"Dwarf Version", i32 4}
!4 = !{i32 2, !"Debug Info Version", i32 3}
!5 = !{i32 1, !"wchar_size", i32 4}
!6 = !{!"clang version 12.0.0"}
!7 = distinct !DISubprogram(name: "operator*", linkageName: "_ZNK1BmlERKS_", scope: !8, file: !1, line: 14, type: !33, scopeLine: 14, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0, declaration: !32, retainedNodes: !38)
!8 = distinct !DICompositeType(tag: DW_TAG_class_type, name: "B", file: !1, line: 6, size: 160, flags: DIFlagTypePassByValue | DIFlagNonTrivial, elements: !9, identifier: "_ZTS1B")
!9 = !{!10, !12, !24, !28, !32}
!10 = !DIDerivedType(tag: DW_TAG_member, name: "g", scope: !8, file: !1, line: 11, baseType: !11, size: 32, flags: DIFlagPublic)
!11 = !DIBasicType(name: "int", size: 32, encoding: DW_ATE_signed)
!12 = !DIDerivedType(tag: DW_TAG_member, name: "e", scope: !8, file: !1, line: 12, baseType: !13, size: 128, offset: 32, flags: DIFlagPublic)
!13 = distinct !DICompositeType(tag: DW_TAG_class_type, name: "a", file: !1, line: 1, size: 128, flags: DIFlagTypePassByValue, elements: !14, identifier: "_ZTS1a")
!14 = !{!15, !20}
!15 = !DIDerivedType(tag: DW_TAG_member, name: "b", scope: !13, file: !1, line: 3, baseType: !16, size: 128, flags: DIFlagPublic)
!16 = !DICompositeType(tag: DW_TAG_array_type, baseType: !17, size: 128, elements: !18)
!17 = !DIBasicType(name: "float", size: 32, encoding: DW_ATE_float)
!18 = !{!19}
!19 = !DISubrange(count: 4)
!20 = !DISubprogram(name: "c", linkageName: "_ZN1a1cEv", scope: !13, file: !1, line: 4, type: !21, scopeLine: 4, flags: DIFlagPublic | DIFlagPrototyped, spFlags: DISPFlagOptimized)
!21 = !DISubroutineType(types: !22)
!22 = !{null, !23}
!23 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !13, size: 64, flags: DIFlagArtificial | DIFlagObjectPointer)
!24 = !DISubprogram(name: "B", scope: !8, file: !1, line: 8, type: !25, scopeLine: 8, flags: DIFlagPublic | DIFlagPrototyped, spFlags: DISPFlagOptimized)
!25 = !DISubroutineType(types: !26)
!26 = !{null, !27, !13}
!27 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !8, size: 64, flags: DIFlagArtificial | DIFlagObjectPointer)
!28 = !DISubprogram(name: "f", linkageName: "_ZN1B1fEv", scope: !8, file: !1, line: 9, type: !29, scopeLine: 9, flags: DIFlagPublic | DIFlagPrototyped, spFlags: DISPFlagOptimized)
!29 = !DISubroutineType(types: !30)
!30 = !{!31, !27}
!31 = !DIDerivedType(tag: DW_TAG_reference_type, baseType: !13, size: 64)
!32 = !DISubprogram(name: "operator*", linkageName: "_ZNK1BmlERKS_", scope: !8, file: !1, line: 10, type: !33, scopeLine: 10, flags: DIFlagPublic | DIFlagPrototyped, spFlags: DISPFlagOptimized)
!33 = !DISubroutineType(types: !34)
!34 = !{!8, !35, !37}
!35 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !36, size: 64, flags: DIFlagArtificial | DIFlagObjectPointer)
!36 = !DIDerivedType(tag: DW_TAG_const_type, baseType: !8)
!37 = !DIDerivedType(tag: DW_TAG_reference_type, baseType: !36, size: 64)
!38 = !{!39, !41}
!39 = !DILocalVariable(name: "this", arg: 1, scope: !7, type: !40, flags: DIFlagArtificial | DIFlagObjectPointer)
!40 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !36, size: 64)
!41 = !DILocalVariable(arg: 2, scope: !7, file: !1, line: 14, type: !37)
!42 = !DILocation(line: 14, column: 41, scope: !7)
!47 = !DILocation(line: 8, column: 12, scope: !48, inlinedAt: !53)
!48 = distinct !DISubprogram(name: "B", linkageName: "_ZN1BC2E1a", scope: !8, file: !1, line: 8, type: !25, scopeLine: 8, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0, declaration: !24, retainedNodes: !49)
!49 = !{!50, !52}
!50 = !DILocalVariable(name: "this", arg: 1, scope: !48, type: !51, flags: DIFlagArtificial | DIFlagObjectPointer)
!51 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !8, size: 64)
!52 = !DILocalVariable(name: "d", arg: 2, scope: !48, file: !1, line: 8, type: !13)
!53 = distinct !DILocation(line: 14, column: 41, scope: !7)
!54 = !DILocation(line: 14, column: 34, scope: !7)
!55 = !DILocation(line: 8, column: 12, scope: !48)
!56 = !DILocation(line: 8, column: 18, scope: !48)
!57 = distinct !DISubprogram(name: "j", linkageName: "_Z1jv", scope: !1, file: !1, line: 19, type: !58, scopeLine: 19, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0, retainedNodes: !60)
!58 = !DISubroutineType(types: !59)
!59 = !{null}
!60 = !{!61, !68, !69, !70, !71, !72}
!61 = !DILocalVariable(name: "convexbody", scope: !57, file: !1, line: 20, type: !62)
!62 = distinct !DICompositeType(tag: DW_TAG_class_type, name: "h", file: !1, line: 15, size: 8, flags: DIFlagTypePassByValue, elements: !63, identifier: "_ZTS1h")
!63 = !{!64}
!64 = !DISubprogram(name: "i", linkageName: "_ZN1h1iEv", scope: !62, file: !1, line: 17, type: !65, scopeLine: 17, flags: DIFlagPublic | DIFlagPrototyped, spFlags: DISPFlagOptimized)
!65 = !DISubroutineType(types: !66)
!66 = !{!8, !67}
!67 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !62, size: 64, flags: DIFlagArtificial | DIFlagObjectPointer)
!68 = !DILocalVariable(name: "k", scope: !57, file: !1, line: 20, type: !62)
!69 = !DILocalVariable(name: "l", scope: !57, file: !1, line: 21, type: !8)
!70 = !DILocalVariable(name: "m", scope: !57, file: !1, line: 21, type: !8)
!71 = !DILocalVariable(name: "n", scope: !57, file: !1, line: 21, type: !8)
!72 = !DILocalVariable(name: "o", scope: !57, file: !1, line: 22, type: !13)
!73 = distinct !DIAssignID()
!74 = !DILocation(line: 0, scope: !57)
!75 = distinct !DIAssignID()
!76 = distinct !DIAssignID()
!77 = distinct !DIAssignID()
!78 = distinct !DIAssignID()
!79 = distinct !DIAssignID()
!80 = !DILocation(line: 20, column: 3, scope: !57)
!81 = !DILocation(line: 21, column: 3, scope: !57)
!82 = !DILocation(line: 21, column: 11, scope: !57)
!83 = !DILocation(line: 21, column: 31, scope: !57)
!84 = !DILocation(line: 14, column: 41, scope: !7, inlinedAt: !85)
!85 = distinct !DILocation(line: 21, column: 42, scope: !57)
!89 = !DILocation(line: 8, column: 12, scope: !48, inlinedAt: !90)
!90 = distinct !DILocation(line: 14, column: 41, scope: !7, inlinedAt: !85)
!91 = !DILocation(line: 22, column: 3, scope: !57)
!92 = !DILocation(line: 9, column: 19, scope: !93, inlinedAt: !96)
!93 = distinct !DISubprogram(name: "f", linkageName: "_ZN1B1fEv", scope: !8, file: !1, line: 9, type: !29, scopeLine: 9, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0, declaration: !28, retainedNodes: !94)
!94 = !{!95}
!95 = !DILocalVariable(name: "this", arg: 1, scope: !93, type: !51, flags: DIFlagArtificial | DIFlagObjectPointer)
!96 = distinct !DILocation(line: 22, column: 11, scope: !57)
!97 = !DILocation(line: 22, column: 9, scope: !57)
!98 = distinct !DIAssignID()
!99 = !DILocation(line: 23, column: 5, scope: !57)
!100 = !DILocation(line: 24, column: 1, scope: !57)
!101 = !DILocation(line: 9, column: 19, scope: !93)
!102 = !DILocation(line: 9, column: 12, scope: !93)
!1000 = !{i32 7, !"debug-info-assignment-tracking", i1 true}
