/*
 * Decompiled with CFR 0.152.
 */
package rules.jvm.external;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Hasher {
    public static void main(String[] args) throws NoSuchAlgorithmException, IOException {
        Stream<String> fileStream;
        if (args.length == 2 && args[0].equals("--argsfile")) {
            String argfile = args[1];
            fileStream = Files.lines(Paths.get(argfile, new String[0]));
        } else {
            fileStream = Stream.of(args);
        }
        System.out.print(Hasher.hashFiles(fileStream));
    }

    static String hashFiles(Stream<String> files) {
        return ((Stream)files.parallel()).map(arg -> {
            File file = new File((String)arg);
            if (!file.exists() || !file.isFile()) {
                throw new IllegalArgumentException("File does not exist or is not a file: " + file.getAbsolutePath());
            }
            try {
                return Hasher.sha256(file) + " " + file + "\n";
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.joining());
    }

    static String sha256(File file) throws NoSuchAlgorithmException, IOException {
        byte[] buffer = new byte[8192];
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            int count;
            while ((count = bufferedInputStream.read(buffer)) > 0) {
                digest.update(buffer, 0, count);
            }
        }
        StringBuilder hexString = new StringBuilder(64);
        for (byte b : digest.digest()) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

