/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Objects;
import java.util.Set;
import jdk.jfr.BooleanFlag;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.settings.BooleanValue;

@MetadataDefinition
@Label(value="Stack Trace")
@Name(value="jdk.settings.StackTrace")
@Description(value="Record stack traces")
@BooleanFlag
public final class StackTraceSetting
extends Control {
    private static final long typeId = Type.getTypeId(StackTraceSetting.class);
    private final BooleanValue booleanValue;
    private final PlatformEventType eventType;

    public StackTraceSetting(PlatformEventType platformEventType, String string) {
        super(string);
        this.booleanValue = BooleanValue.valueOf(string);
        this.eventType = Objects.requireNonNull(platformEventType);
    }

    @Override
    public String combine(Set<String> set) {
        return this.booleanValue.union(set);
    }

    @Override
    public void setValue(String string) {
        this.booleanValue.setValue(string);
        this.eventType.setStackTraceEnabled(this.booleanValue.getBoolean());
    }

    @Override
    public String getValue() {
        return this.booleanValue.getValue();
    }

    public static boolean isType(long l) {
        return typeId == l;
    }
}

