/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathHelperImpl;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import sun.security.util.AnchorCertificates;
import sun.security.x509.NameConstraintsExtension;

public class TrustAnchor {
    private final PublicKey pubKey;
    private final String caName;
    private final X500Principal caPrincipal;
    private final X509Certificate trustedCert;
    private byte[] ncBytes;
    private NameConstraintsExtension nc;
    private boolean jdkCA;
    private boolean hasJdkCABeenChecked;

    public TrustAnchor(X509Certificate x509Certificate, byte[] byArray) {
        if (x509Certificate == null) {
            throw new NullPointerException("the trustedCert parameter must be non-null");
        }
        this.trustedCert = x509Certificate;
        this.pubKey = null;
        this.caName = null;
        this.caPrincipal = null;
        this.setNameConstraints(byArray);
    }

    public TrustAnchor(X500Principal x500Principal, PublicKey publicKey, byte[] byArray) {
        if (x500Principal == null || publicKey == null) {
            throw new NullPointerException();
        }
        this.trustedCert = null;
        this.caPrincipal = x500Principal;
        this.caName = x500Principal.getName();
        this.pubKey = publicKey;
        this.setNameConstraints(byArray);
    }

    public TrustAnchor(String string, PublicKey publicKey, byte[] byArray) {
        if (publicKey == null) {
            throw new NullPointerException("the pubKey parameter must be non-null");
        }
        if (string == null) {
            throw new NullPointerException("the caName parameter must be non-null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("the caName parameter must be a non-empty String");
        }
        this.caPrincipal = new X500Principal(string);
        this.pubKey = publicKey;
        this.caName = string;
        this.trustedCert = null;
        this.setNameConstraints(byArray);
    }

    public final X509Certificate getTrustedCert() {
        return this.trustedCert;
    }

    public final X500Principal getCA() {
        return this.caPrincipal;
    }

    public final String getCAName() {
        return this.caName;
    }

    public final PublicKey getCAPublicKey() {
        return this.pubKey;
    }

    private void setNameConstraints(byte[] byArray) {
        if (byArray == null) {
            this.ncBytes = null;
            this.nc = null;
        } else {
            this.ncBytes = (byte[])byArray.clone();
            try {
                this.nc = new NameConstraintsExtension(Boolean.FALSE, byArray);
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
                illegalArgumentException.initCause(iOException);
                throw illegalArgumentException;
            }
        }
    }

    public final byte[] getNameConstraints() {
        return this.ncBytes == null ? null : (byte[])this.ncBytes.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        if (this.pubKey != null) {
            stringBuffer.append("  Trusted CA Public Key: " + this.pubKey.toString() + "\n");
            stringBuffer.append("  Trusted CA Issuer Name: " + String.valueOf(this.caName) + "\n");
        } else {
            stringBuffer.append("  Trusted CA cert: " + this.trustedCert.toString() + "\n");
        }
        if (this.nc != null) {
            stringBuffer.append("  Name Constraints: " + this.nc.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    synchronized boolean isJdkCA() {
        if (!this.hasJdkCABeenChecked) {
            if (this.trustedCert != null) {
                this.jdkCA = AnchorCertificates.contains(this.trustedCert);
            }
            this.hasJdkCABeenChecked = true;
        }
        return this.jdkCA;
    }

    static {
        CertPathHelperImpl.initialize();
    }
}

