﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ec2/model/ListSnapshotsInRecycleBinRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::EC2::Model;
using namespace Aws::Utils;

ListSnapshotsInRecycleBinRequest::ListSnapshotsInRecycleBinRequest() : 
    m_maxResults(0),
    m_maxResultsHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_snapshotIdsHasBeenSet(false),
    m_dryRun(false),
    m_dryRunHasBeenSet(false)
{
}

Aws::String ListSnapshotsInRecycleBinRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=ListSnapshotsInRecycleBin&";
  if(m_maxResultsHasBeenSet)
  {
    ss << "MaxResults=" << m_maxResults << "&";
  }

  if(m_nextTokenHasBeenSet)
  {
    ss << "NextToken=" << StringUtils::URLEncode(m_nextToken.c_str()) << "&";
  }

  if(m_snapshotIdsHasBeenSet)
  {
    unsigned snapshotIdsCount = 1;
    for(auto& item : m_snapshotIds)
    {
      ss << "SnapshotId." << snapshotIdsCount << "="
          << StringUtils::URLEncode(item.c_str()) << "&";
      snapshotIdsCount++;
    }
  }

  if(m_dryRunHasBeenSet)
  {
    ss << "DryRun=" << std::boolalpha << m_dryRun << "&";
  }

  ss << "Version=2016-11-15";
  return ss.str();
}


void  ListSnapshotsInRecycleBinRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
