﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/email/model/TestRenderTemplateRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::SES::Model;
using namespace Aws::Utils;

TestRenderTemplateRequest::TestRenderTemplateRequest() : 
    m_templateNameHasBeenSet(false),
    m_templateDataHasBeenSet(false)
{
}

Aws::String TestRenderTemplateRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=TestRenderTemplate&";
  if(m_templateNameHasBeenSet)
  {
    ss << "TemplateName=" << StringUtils::URLEncode(m_templateName.c_str()) << "&";
  }

  if(m_templateDataHasBeenSet)
  {
    ss << "TemplateData=" << StringUtils::URLEncode(m_templateData.c_str()) << "&";
  }

  ss << "Version=2010-12-01";
  return ss.str();
}


void  TestRenderTemplateRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
