//  BEGIN COPYRIGHT BLOCK
//  This Program is free software; you can redistribute it and/or modify it under
//  the terms of the GNU General Public License as published by the Free Software
//  Foundation; version 2 of the License.
//
//  This Program is distributed in the hope that it will be useful, but WITHOUT
//  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
//  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with
//  this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
//  Place, Suite 330, Boston, MA 02111-1307 USA.
//
//  Copyright (C) 2005 Red Hat, Inc.
//  All rights reserved.
//  END COPYRIGHT BLOCK

#include "coolkey-token.h"
#include "coolkey-api.h"
#include <stdio.h>

#include <dbus/dbus.h>
#include <stdbool.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

enum
{
    PROP_0,
    PROP_KEYTYPE,
    PROP_CUID,
    PROP_ATR,
    PROP_ISSUERINFO,
    PROP_ISSUER,
    PROP_ISSUEDTO,
    PROP_STATUS,
    N_PROPERTIES
};

static GParamSpec *obj_properties[N_PROPERTIES] = { NULL, };

#define COOLKEY_TOKEN_GET_PRIVATE(o)      \
    (G_TYPE_INSTANCE_GET_PRIVATE ((o), COOLKEY_TYPE_TOKEN, CoolkeyTokenPrivate))

struct _CoolkeyTokenPrivate {
    gchar* key_type;
    gchar* cuid;
    gchar* atr;
    gchar* issuer_info;
    gchar* issuer;
    gchar* issued_to;
    int    status;
};


// private members go in this structure
struct _CoolkeyToken
{
  GObject parent_instance;
};

// implement CoolkeyToken as a child of GObject
G_DEFINE_TYPE (CoolkeyToken, coolkey_token, G_TYPE_OBJECT)

// instance cleanup
void
coolkey_token_cleanup(CoolkeyToken *self)
{
    CoolkeyTokenPrivate *priv = COOLKEY_TOKEN_GET_PRIVATE (self);
}
// instance initialization
static void
coolkey_token_init (CoolkeyToken *self)
{
  /* initialize all public and private members to reasonable default values.
   * They are all automatically initialized to 0 to begin with. */

  CoolkeyTokenPrivate *priv = COOLKEY_TOKEN_GET_PRIVATE (self);
   priv->cuid = NULL;
   priv->atr = NULL;
   priv->issuer_info = NULL;
   priv->issuer = NULL;
   priv->issued_to = NULL;
}

static void
coolkey_token_set_property (GObject      *object,
                          guint         property_id,
                          const GValue *value,
                          GParamSpec   *pspec)
{
    CoolkeyTokenPrivate *priv = COOLKEY_TOKEN_GET_PRIVATE (object);

    switch (property_id) {

    case PROP_KEYTYPE:
        g_free(priv->key_type);
        priv->key_type = g_value_dup_string(value);
        break;
        
    case PROP_CUID:
        g_free (priv->cuid);
        priv->cuid = g_value_dup_string (value);
        break;

    case PROP_ATR:
        g_free (priv->atr);
        priv->atr = g_value_dup_string (value);
        break;

    case PROP_ISSUERINFO:
        g_free (priv->issuer_info);
        priv->issuer_info = g_value_dup_string (value);
        break;

    case PROP_ISSUER:
        g_free(priv->issuer);
        priv->issuer = g_value_dup_string(value);
        break;

    case PROP_ISSUEDTO:
        g_free(priv->issued_to);
        priv->issued_to = g_value_dup_string(value);
        break;

    case PROP_STATUS:
        priv->status = g_value_get_int(value);
        break;

 
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
        break;
    }
}

static void
coolkey_token_get_property (GObject    *object,
                          guint       property_id,
                          GValue     *value,
                          GParamSpec *pspec)
{
    CoolkeyTokenPrivate *priv = COOLKEY_TOKEN_GET_PRIVATE (object);

    switch (property_id) {
    case PROP_KEYTYPE:
        g_value_set_string(value, priv->key_type);
        break;
    case PROP_CUID:
        g_value_set_string (value, priv->cuid);
        break;

    case PROP_ATR:
        g_value_set_string (value, priv->atr);
        break;

    case PROP_ISSUERINFO:
        g_value_set_string (value, priv->issuer_info);
        break;

    case PROP_ISSUER:
        g_value_set_string (value, priv->issuer);
        break;

    case PROP_ISSUEDTO:
        g_value_set_string(value, priv->issued_to);
        break;

    case PROP_STATUS:
        g_value_set_int(value, priv->status);
        break;
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
        break;
    }
}


static void
coolkey_token_finalize (GObject *object)
{
    CoolkeyTokenPrivate *priv = COOLKEY_TOKEN_GET_PRIVATE (object);

    if(priv) {
        g_free (priv->cuid);
        g_free (priv->atr);
        g_free (priv->issuer_info);
        g_free (priv->issuer);
        g_free (priv->issued_to);
        g_free (priv->key_type);
    }

    G_OBJECT_CLASS (coolkey_token_parent_class)->finalize (object);
}

static void
coolkey_token_constructed (GObject *object)
{
}

// class initialization
static void
coolkey_token_class_init (CoolkeyTokenClass *klass)
{
    GObjectClass *object_class = G_OBJECT_CLASS (klass);

    object_class->set_property = coolkey_token_set_property;
    object_class->get_property = coolkey_token_get_property;

    object_class->finalize = coolkey_token_finalize;
    object_class->constructed = coolkey_token_constructed;

    obj_properties[PROP_KEYTYPE] =
        g_param_spec_string ("key_type",
                             "Key_type",
                             "The token type",
                             "NULL",
                             G_PARAM_READWRITE |
                             G_PARAM_CONSTRUCT);

    
    obj_properties[PROP_CUID] =
        g_param_spec_string ("cuid",
                             "Cuid",
                             "The token id",
                             NULL,
                             G_PARAM_READWRITE |
                             G_PARAM_CONSTRUCT);

    obj_properties[PROP_ATR] =
        g_param_spec_string ("atr",
                             "Atr",
                             "The token atr value",
                             NULL,
                             G_PARAM_READWRITE |
                             G_PARAM_CONSTRUCT);

    obj_properties[PROP_ISSUERINFO] =
        g_param_spec_string ("issuer_info",
                             "Issuer_info",
                             "The token issuer info",
                             NULL,
                             G_PARAM_READWRITE |
                             G_PARAM_CONSTRUCT);

    obj_properties[PROP_ISSUER] =
        g_param_spec_string ("issuer",
                             "Issuer",
                             "The token issuer",
                             NULL,
                             G_PARAM_READWRITE |
                             G_PARAM_CONSTRUCT);

    obj_properties[PROP_ISSUEDTO] =
        g_param_spec_string ("issued_to",
                             "Issued_to",
                             "The token owner",
                             NULL,
                             G_PARAM_READWRITE |
                             G_PARAM_CONSTRUCT);

    obj_properties[PROP_STATUS] =
        g_param_spec_int ("status",
                             "Status",
                             "The token status",
                             0, INT_MAX,0,
                             G_PARAM_READWRITE); 


    g_object_class_install_properties (object_class,
                                       N_PROPERTIES,
                                       obj_properties);

    g_type_class_add_private (object_class, sizeof (CoolkeyTokenPrivate));

}

/**
 * coolkey_token_new:
 *
 * Allocates a new #CoolkeyToken
 *
 * Returns: A new #CoolkeyToken
 *
 */
CoolkeyToken *
coolkey_token_new (void)
{
  CoolkeyToken *token;

  token = g_object_new(COOLKEY_TYPE_TOKEN, NULL);
  return token;
}
