/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;

public final class AlgIdDSA
extends AlgorithmId
implements DSAParams {
    private static final long serialVersionUID = 5978220691806461631L;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    @Override
    public BigInteger getP() {
        return this.p;
    }

    @Override
    public BigInteger getQ() {
        return this.q;
    }

    @Override
    public BigInteger getG() {
        return this.g;
    }

    AlgIdDSA(DerValue val) throws IOException {
        super(val.getOID());
    }

    public AlgIdDSA(byte[] encodedAlg) throws IOException {
        super(new DerValue(encodedAlg).getOID());
    }

    public AlgIdDSA(byte[] p, byte[] q, byte[] g) throws IOException {
        this(new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
    }

    public AlgIdDSA(BigInteger p, BigInteger q, BigInteger g) {
        super(DSA_oid);
        try {
            this.p = p;
            this.q = q;
            this.g = g;
            this.initializeParams();
        }
        catch (IOException e) {
            throw new ProviderException("Construct DSS/DSA Algorithm ID");
        }
    }

    @Override
    public String getName() {
        return "DSA";
    }

    private void initializeParams() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            out.putInteger(new BigInt(this.p.toByteArray()));
            out.putInteger(new BigInt(this.q.toByteArray()));
            out.putInteger(new BigInt(this.g.toByteArray()));
            this.params = new DerValue(48, out.toByteArray());
        }
    }

    @Override
    protected void decodeParams() throws IOException {
        if (this.params == null || this.params.tag != 48) {
            throw new IOException("DSA alg parsing error");
        }
        this.params.data.reset();
        this.p = this.params.data.getInteger().toBigInteger();
        this.q = this.params.data.getInteger().toBigInteger();
        this.g = this.params.data.getInteger().toBigInteger();
        if (this.params.data.available() != 0) {
            throw new IOException("AlgIdDSA params, extra=" + this.params.data.available());
        }
    }

    @Override
    public String toString() {
        return this.paramsToString();
    }

    @Override
    protected String paramsToString() {
        return "\n    p:\n" + new BigInt(this.p).toString() + "\n    q:\n" + new BigInt(this.q).toString() + "\n    g:\n" + new BigInt(this.g).toString() + "\n";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.g == null ? 0 : this.g.hashCode());
        result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
        result = 31 * result + (this.q == null ? 0 : this.q.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlgIdDSA other = (AlgIdDSA)obj;
        if (this.g == null ? other.g != null : !this.g.equals(other.g)) {
            return false;
        }
        if (this.p == null ? other.p != null : !this.p.equals(other.p)) {
            return false;
        }
        return !(this.q == null ? other.q != null : !this.q.equals(other.q));
    }
}

