/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.KeyAlreadyImportedException;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PK11Store
implements CryptoStore {
    public static Logger logger = LoggerFactory.getLogger(PK11Store.class);
    protected boolean updated;
    protected TokenProxy storeProxy;

    @Override
    public PrivateKey importPrivateKey(byte[] key, PrivateKey.Type type) throws TokenException, KeyAlreadyImportedException {
        return this.importPrivateKey(key, type, false);
    }

    @Override
    public native PrivateKey importPrivateKey(byte[] var1, PrivateKey.Type var2, boolean var3) throws TokenException, KeyAlreadyImportedException;

    @Override
    public synchronized PrivateKey[] getPrivateKeys() throws TokenException {
        ArrayList<PrivateKey> list = new ArrayList<PrivateKey>();
        this.loadPrivateKeys(list);
        PrivateKey[] array = new PrivateKey[list.size()];
        list.toArray(array);
        return array;
    }

    protected native void loadPrivateKeys(Collection<PrivateKey> var1) throws TokenException;

    @Override
    public synchronized PublicKey[] getPublicKeys() throws TokenException {
        ArrayList<PublicKey> list = new ArrayList<PublicKey>();
        this.loadPublicKeys(list);
        PublicKey[] array = new PublicKey[list.size()];
        list.toArray(array);
        return array;
    }

    protected native void loadPublicKeys(Collection<PublicKey> var1) throws TokenException;

    @Override
    public PublicKey findPublicKey(PrivateKey privateKey) throws TokenException, ObjectNotFoundException {
        if (privateKey instanceof RSAKey) {
            logger.debug("PKCS11Store: searching for RSA public key");
            RSAKey rsaPrivateKey = (RSAKey)((Object)privateKey);
            BigInteger modulus = rsaPrivateKey.getModulus();
            for (PublicKey publicKey : this.getPublicKeys()) {
                RSAPublicKey rsaPublicKey;
                if (!(publicKey instanceof RSAPublicKey) || !modulus.equals((rsaPublicKey = (RSAPublicKey)publicKey).getModulus())) continue;
                logger.debug("PKCS11Store: found RSA public key");
                return publicKey;
            }
        }
        throw new ObjectNotFoundException("Unable to find public key");
    }

    @Override
    public synchronized SymmetricKey[] getSymmetricKeys() throws TokenException {
        Vector<SymmetricKey> keys = new Vector<SymmetricKey>();
        this.putSymKeysInVector(keys);
        Object[] array = new SymmetricKey[keys.size()];
        keys.copyInto(array);
        return array;
    }

    protected native void putSymKeysInVector(Vector<SymmetricKey> var1) throws TokenException;

    @Override
    public native void deletePrivateKey(PrivateKey var1) throws NoSuchItemOnTokenException, TokenException;

    @Override
    public native void deletePublicKey(PublicKey var1) throws NoSuchItemOnTokenException, TokenException;

    @Override
    public byte[] getEncryptedPrivateKeyInfo(X509Certificate cert, PBEAlgorithm pbeAlg, Password pw, int iteration) throws NotInitializedException, ObjectNotFoundException, TokenException {
        return this.getEncryptedPrivateKeyInfo(null, pw, pbeAlg, iteration, CryptoManager.getInstance().findPrivKeyByCert(cert));
    }

    @Override
    public native byte[] getEncryptedPrivateKeyInfo(KeyGenerator.CharToByteConverter var1, Password var2, Algorithm var3, int var4, PrivateKey var5);

    @Override
    public native void importEncryptedPrivateKeyInfo(KeyGenerator.CharToByteConverter var1, Password var2, String var3, PublicKey var4, byte[] var5);

    @Override
    public X509Certificate[] getCertificates() throws TokenException {
        Vector<X509Certificate> certs = new Vector<X509Certificate>();
        this.putCertsInVector(certs);
        Object[] array = new X509Certificate[certs.size()];
        certs.copyInto(array);
        return array;
    }

    protected native void putCertsInVector(Vector<X509Certificate> var1) throws TokenException;

    @Override
    public native X509Certificate importCert(byte[] var1, String var2) throws TokenException;

    @Override
    public native void deleteCert(X509Certificate var1) throws NoSuchItemOnTokenException, TokenException;

    @Override
    public native void deleteCertOnly(X509Certificate var1) throws NoSuchItemOnTokenException, TokenException;

    public PK11Store(TokenProxy proxy) {
        assert (proxy != null);
        this.storeProxy = proxy;
    }

    protected PK11Store() {
    }
}

