/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

public class JSSKeyPairGeneratorSpi
extends KeyPairGeneratorSpi {
    private KeyPairGenerator kpg;

    protected JSSKeyPairGeneratorSpi(KeyPairAlgorithm alg) {
        CryptoToken token = TokenSupplierManager.getTokenSupplier().getThreadToken();
        try {
            try {
                this.kpg = token.getKeyPairGenerator(alg);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException("Token '" + token.getName() + "' does not support algorithm " + alg.toString());
            }
        }
        catch (TokenException e) {
            throw new TokenRuntimeException(e.getMessage());
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.kpg.initialize(params, random);
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        this.kpg.initialize(keysize, random);
    }

    @Override
    public KeyPair generateKeyPair() {
        try {
            return this.kpg.genKeyPair();
        }
        catch (TokenException e) {
            throw new TokenRuntimeException(e.getMessage());
        }
    }

    public static class EC
    extends JSSKeyPairGeneratorSpi {
        public EC() {
            super(KeyPairAlgorithm.EC);
        }
    }

    public static class DSA
    extends JSSKeyPairGeneratorSpi {
        public DSA() {
            super(KeyPairAlgorithm.DSA);
        }
    }

    public static class RSA
    extends JSSKeyPairGeneratorSpi {
        public RSA() {
            super(KeyPairAlgorithm.RSA);
        }
    }
}

