/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.ssl.SSLSocket;

public class SSLTest {
    private Hashtable<String, String> params = new Hashtable();
    private String[] defaults = new String[]{"port", "443", "host", "www.amazon.com", "remotehost", "www.amazon.com"};

    public static void main(String[] args) {
        new SSLTest(args);
    }

    private void initParams() {
        this.processArgs(this.defaults);
    }

    private void processArgs(String[] args) {
        for (int i = 0; i < args.length; i += 2) {
            System.out.flush();
            this.params.put(args[i], args[i + 1]);
        }
    }

    private void dumpParams() {
        Enumeration<String> _enum = this.params.keys();
        System.out.println("Parameters:");
        while (_enum.hasMoreElements()) {
            String key = _enum.nextElement();
            System.out.println(key + "=" + this.params.get(key));
        }
    }

    public SSLTest(String[] args) {
        try {
            this.initParams();
            this.processArgs(args);
            this.dumpParams();
            CryptoManager.initialize(".");
            int port = Integer.valueOf(this.params.get("port"));
            try (Socket s = new Socket(this.params.get("host"), port);
                 SSLSocket ss = new SSLSocket(s, this.params.get("remotehost"), null, null);){
                ss.setSoTimeout(5000);
                OutputStream os = ss.getOutputStream();
                String writeString = "GET / HTTP/1.0\n\n";
                byte[] writeBytes = writeString.getBytes("8859_1");
                os.write(writeBytes);
                InputStream is = ss.getInputStream();
                int numRead = 0;
                byte[] inbuf = new byte[256];
                while ((numRead = is.read(inbuf)) != -1) {
                    System.out.print(new String(inbuf, 0, numRead, "UTF-8"));
                }
                ss.setKeepAlive(true);
                ss.setReceiveBufferSize(32000);
                ss.setSendBufferSize(8000);
                ss.setSoLinger(true, 10);
                ss.setTcpNoDelay(true);
                System.out.println("remote addr is " + ss.getInetAddress().toString());
                System.out.println("remote port is " + ss.getPort());
                System.out.println("local addr is " + ss.getLocalAddress().toString());
                System.out.println("local port is " + ss.getLocalPort());
                System.out.println("keepalive is " + ss.getKeepAlive());
                System.out.println("receive buffer size is " + ss.getReceiveBufferSize());
                System.out.println("send buffer size is " + ss.getSendBufferSize());
                System.out.println("solinger is " + ss.getSoLinger());
                System.out.println("sotimeout is " + ss.getSoTimeout());
                System.out.println("tcpNoDelay is " + ss.getTcpNoDelay());
                ss.shutdownInput();
                ss.shutdownOutput();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Runtime.getRuntime().gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

