/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.util.ArrayList;
import org.mozilla.jss.ssl.SSLVersion;

public class SSLVersionRange {
    private SSLVersion minVersion;
    private SSLVersion maxVersion;
    @Deprecated
    public static final int ssl3 = 29;
    @Deprecated
    public static final int tls1_0 = 30;
    @Deprecated
    public static final int tls1_1 = 31;
    @Deprecated
    public static final int tls1_2 = 32;
    @Deprecated
    public static final int tls1_3 = 35;

    public SSLVersionRange(SSLVersion minVersion, SSLVersion maxVersion) throws IllegalArgumentException {
        if (minVersion.value() > maxVersion.value()) {
            throw new IllegalArgumentException("Arguments out of range");
        }
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    @Deprecated
    public SSLVersionRange(int min_enum, int max_enum) throws IllegalArgumentException {
        this(SSLVersion.valueOf(min_enum), SSLVersion.valueOf(max_enum));
    }

    public SSLVersion getMinVersion() {
        return this.minVersion;
    }

    public SSLVersion getMaxVersion() {
        return this.maxVersion;
    }

    public int getMinEnum() {
        return this.minVersion.value();
    }

    public int getMaxEnum() {
        return this.maxVersion.value();
    }

    public SSLVersion[] getAllInRange() {
        ArrayList<SSLVersion> result = new ArrayList<SSLVersion>();
        for (SSLVersion v : SSLVersion.values()) {
            if (v.compareTo(this.minVersion) < 0 || v.compareTo(this.maxVersion) > 0) continue;
            result.add(v);
        }
        return result.toArray(new SSLVersion[result.size()]);
    }

    public SSLVersionRange boundBy(SSLVersionRange bound) {
        SSLVersion minimum = this.minVersion;
        SSLVersion maximum = this.maxVersion;
        if (minimum.compareTo(bound.getMinVersion()) < 0) {
            minimum = bound.getMinVersion();
        }
        if (maximum.compareTo(bound.getMaxVersion()) > 0) {
            maximum = bound.getMaxVersion();
        }
        return new SSLVersionRange(minimum, maximum);
    }
}

