/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.KBKDFCounterParams;
import org.mozilla.jss.crypto.KBKDFFeedbackParams;
import org.mozilla.jss.crypto.KBKDFPipelineParams;
import org.mozilla.jss.crypto.PBEKeyGenParams;

public class KeyGenAlgorithm
extends Algorithm {
    private static final OBJECT_IDENTIFIER PKCS5 = OBJECT_IDENTIFIER.PKCS5;
    private static final OBJECT_IDENTIFIER PKCS12_PBE = OBJECT_IDENTIFIER.PKCS12.subBranch(1L);
    private static Hashtable<OBJECT_IDENTIFIER, KeyGenAlgorithm> oidMap = new Hashtable();
    private KeyStrengthValidator keyStrengthValidator;
    public static final KeyGenAlgorithm GENERIC_SECRET = new KeyGenAlgorithm(71, "GenericSecret", new AnyKeyStrengthValidator(), null, null);
    public static final KeyGenAlgorithm DES = new KeyGenAlgorithm(15, "DES", new FixedKeyStrengthValidator(56), null, null);
    public static final KeyGenAlgorithm DES3;
    public static final KeyGenAlgorithm DESede;
    public static final KeyGenAlgorithm RC4;
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final KeyGenAlgorithm PBA_SHA1_HMAC;
    public static final KeyGenAlgorithm PBE_SHA256_HMAC;
    public static final KeyGenAlgorithm PBE_SHA384_HMAC;
    public static final KeyGenAlgorithm PBE_SHA512_HMAC;
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final KeyGenAlgorithm SHA1_HMAC;
    public static final KeyGenAlgorithm SHA256_HMAC;
    public static final KeyGenAlgorithm SHA384_HMAC;
    public static final KeyGenAlgorithm SHA512_HMAC;
    public static final KeyGenAlgorithm AES;
    public static final KeyGenAlgorithm RC2;
    public static final KeyGenAlgorithm SP800_108_COUNTER_KDF;
    public static final KeyGenAlgorithm SP800_108_FEEDBACK_KDF;
    public static final KeyGenAlgorithm SP800_108_DOUBLE_PIPELINE_KDF;
    public static final KeyGenAlgorithm NSS_SP800_108_COUNTER_KDF_DERIVE_DATA;
    public static final KeyGenAlgorithm NSS_SP800_108_FEEDBACK_KDF_DERIVE_DATA;
    public static final KeyGenAlgorithm NSS_SP800_108_DOUBLE_PIPELINE_KDF_DERIVE_DATA;

    protected KeyGenAlgorithm(int oidTag, String name, KeyStrengthValidator keyStrengthValidator, OBJECT_IDENTIFIER oid, Class<?> paramClass) {
        super(oidTag, name, oid, paramClass);
        this.keyStrengthValidator = keyStrengthValidator;
        if (oid != null) {
            oidMap.put(oid, this);
        }
    }

    public static KeyGenAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        KeyGenAlgorithm alg = oidMap.get(oid);
        if (alg == null) {
            throw new NoSuchAlgorithmException(oid.toString());
        }
        return alg;
    }

    public boolean isValidStrength(int strength) {
        return this.keyStrengthValidator.isValidKeyStrength(strength);
    }

    static {
        DESede = DES3 = new KeyGenAlgorithm(16, "DESede", new FixedKeyStrengthValidator(168), null, null);
        RC4 = new KeyGenAlgorithm(17, "RC4", new AnyKeyStrengthValidator(), null, null);
        PBA_SHA1_HMAC = new KeyGenAlgorithm(31, "PBA/SHA1/HMAC", new FixedKeyStrengthValidator(160), null, PBEKeyGenParams.class);
        PBE_SHA256_HMAC = new KeyGenAlgorithm(38, "PBE/SHA256/HMAC", new AnyKeyStrengthValidator(), null, PBEKeyGenParams.class);
        PBE_SHA384_HMAC = new KeyGenAlgorithm(39, "PBE/SHA384/HMAC", new AnyKeyStrengthValidator(), null, PBEKeyGenParams.class);
        PBE_SHA512_HMAC = new KeyGenAlgorithm(40, "PBE/SHA512/HMAC", new AnyKeyStrengthValidator(), null, PBEKeyGenParams.class);
        SHA1_HMAC = new KeyGenAlgorithm(27, "SHA1/HMAC", new FixedKeyStrengthValidator(160), null, null);
        SHA256_HMAC = new KeyGenAlgorithm(67, "SHA256/HMAC", new FixedKeyStrengthValidator(256), null, null);
        SHA384_HMAC = new KeyGenAlgorithm(68, "SHA384/HMAC", new FixedKeyStrengthValidator(384), null, null);
        SHA512_HMAC = new KeyGenAlgorithm(69, "SHA512/HMAC", new FixedKeyStrengthValidator(512), null, null);
        AES = new KeyGenAlgorithm(32, "AES", new KeyStrengthValidator(){

            @Override
            public boolean isValidKeyStrength(int strength) {
                return strength == 128 || strength == 192 || strength == 256;
            }
        }, null, null);
        RC2 = new KeyGenAlgorithm(37, "RC2", new KeyStrengthValidator(){

            @Override
            public boolean isValidKeyStrength(int strength) {
                return strength >= 8 && strength <= 1024;
            }
        }, null, null);
        SP800_108_COUNTER_KDF = new KeyGenAlgorithm(72, "SP800_108_COUNTER_KDF", new AnyKeyStrengthValidator(), null, KBKDFCounterParams.class);
        SP800_108_FEEDBACK_KDF = new KeyGenAlgorithm(73, "SP800_108_FEEDBACK_KDF", new AnyKeyStrengthValidator(), null, KBKDFFeedbackParams.class);
        SP800_108_DOUBLE_PIPELINE_KDF = new KeyGenAlgorithm(74, "SP800_108_DOUBLE_PIPELINE_KDF", new AnyKeyStrengthValidator(), null, KBKDFPipelineParams.class);
        NSS_SP800_108_COUNTER_KDF_DERIVE_DATA = new KeyGenAlgorithm(75, "NSS_SP800_108_COUNTER_KDF_DERIVE_DATA", new AnyKeyStrengthValidator(), null, KBKDFCounterParams.class);
        NSS_SP800_108_FEEDBACK_KDF_DERIVE_DATA = new KeyGenAlgorithm(76, "NSS_SP800_108_FEEDBACK_KDF_DERIVE_DATA", new AnyKeyStrengthValidator(), null, KBKDFFeedbackParams.class);
        NSS_SP800_108_DOUBLE_PIPELINE_KDF_DERIVE_DATA = new KeyGenAlgorithm(77, "NSS_SP800_108_DOUBLE_PIPELINE_KDF_DERIVE_DATA", new AnyKeyStrengthValidator(), null, KBKDFPipelineParams.class);
    }

    protected static interface KeyStrengthValidator {
        public boolean isValidKeyStrength(int var1);
    }

    protected static class AnyKeyStrengthValidator
    implements KeyStrengthValidator {
        protected AnyKeyStrengthValidator() {
        }

        @Override
        public boolean isValidKeyStrength(int strength) {
            return true;
        }
    }

    protected static class FixedKeyStrengthValidator
    implements KeyStrengthValidator {
        private int strength;

        public FixedKeyStrengthValidator(int strength) {
            this.strength = strength;
        }

        @Override
        public boolean isValidKeyStrength(int strength) {
            return this.strength == strength;
        }
    }
}

