/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyId;

public class CertificatePolicySet {
    private Vector<CertificatePolicyId> ids;

    public CertificatePolicySet(Vector<CertificatePolicyId> ids) {
        this.ids = ids;
    }

    public CertificatePolicySet(DerInputStream in) throws IOException {
        this.ids = new Vector(1, 1);
        DerValue[] seq = in.getSequence(5);
        for (int i = 0; i < seq.length; ++i) {
            CertificatePolicyId id = new CertificatePolicyId(seq[i]);
            this.ids.addElement(id);
        }
    }

    public String toString() {
        String s = "CertificatePolicySet:[\n" + this.ids.toString() + "]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.ids.size(); ++i) {
            this.ids.elementAt(i).encode(tmp);
        }
        out.write((byte)48, tmp);
    }
}

