/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;

public class KeyIdentifier
implements Serializable {
    private static final long serialVersionUID = 2412286879441154979L;
    private byte[] octetString;

    public KeyIdentifier(byte[] octetString) {
        this.octetString = octetString;
    }

    public KeyIdentifier(DerValue val) throws IOException {
        this.octetString = val.getOctetString();
    }

    public byte[] getIdentifier() {
        return (byte[])this.octetString.clone();
    }

    public String toString() {
        PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
        String octetbits = pp.toHexString(this.octetString);
        Object s = "KeyIdentifier [\n";
        s = (String)s + octetbits;
        s = (String)s + "]\n";
        return s;
    }

    void encode(DerOutputStream out) throws IOException {
        out.putOctetString(this.octetString);
    }
}

