/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerUniqueIdentity;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectUniqueIdentity;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.X509AttributeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertInfo
implements CertAttrSet,
Serializable {
    private static final long serialVersionUID = -5094073467876311577L;
    private static final Logger logger = LoggerFactory.getLogger(X509CertInfo.class);
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String VALIDITY = "validity";
    public static final String SUBJECT = "subject";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version = new CertificateVersion();
    protected CertificateSerialNumber serialNum = null;
    protected CertificateAlgorithmId algId = null;
    protected CertificateIssuerName issuer = null;
    protected CertificateValidity interval = null;
    protected CertificateSubjectName subject = null;
    protected CertificateX509Key pubKey = null;
    protected CertificateIssuerUniqueIdentity issuerUniqueId = null;
    protected CertificateSubjectUniqueIdentity subjectUniqueId = null;
    protected CertificateExtensions extensions = null;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo = null;
    private static final Hashtable<String, Integer> map = new Hashtable();

    public X509CertInfo() {
    }

    public X509CertInfo(byte[] cert) throws CertificateParsingException {
        try {
            DerValue in = new DerValue(cert);
            this.parse(in);
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    public X509CertInfo(DerValue derVal) throws CertificateParsingException {
        try {
            this.parse(derVal);
        }
        catch (IOException e) {
            throw new CertificateParsingException(e);
        }
    }

    @Override
    public void decode(InputStream in) throws CertificateParsingException, IOException {
        DerValue val = new DerValue(in);
        this.parse(val);
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        this.encode(out, false);
    }

    public void encode(OutputStream out, boolean ignoreCache) throws IOException, CertificateException {
        if (ignoreCache || this.rawCertInfo == null) {
            DerOutputStream tmp = new DerOutputStream();
            this.emit(tmp);
            this.rawCertInfo = tmp.toByteArray();
        }
        out.write(this.rawCertInfo);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(VERSION);
        elements.addElement(SERIAL_NUMBER);
        elements.addElement(ALGORITHM_ID);
        elements.addElement(ISSUER);
        elements.addElement(VALIDITY);
        elements.addElement(SUBJECT);
        elements.addElement(KEY);
        elements.addElement(ISSUER_ID);
        elements.addElement(SUBJECT_ID);
        elements.addElement(EXTENSIONS);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        return this.getEncodedInfo(false);
    }

    public byte[] getEncodedInfo(boolean ignoreCache) throws CertificateEncodingException {
        try {
            if (ignoreCache || this.rawCertInfo == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.emit(tmp);
                this.rawCertInfo = tmp.toByteArray();
            }
            byte[] dup = new byte[this.rawCertInfo.length];
            System.arraycopy(this.rawCertInfo, 0, dup, 0, dup.length);
            return dup;
        }
        catch (IOException | CertificateException e) {
            throw new CertificateEncodingException(e);
        }
    }

    public boolean equals(Object other) {
        X509CertInfo certInfo;
        return other instanceof X509CertInfo && this.equals(certInfo = (X509CertInfo)other);
    }

    public boolean equals(X509CertInfo other) {
        if (this == other) {
            return true;
        }
        if (this.rawCertInfo == null || other.rawCertInfo == null) {
            return false;
        }
        if (this.rawCertInfo.length != other.rawCertInfo.length) {
            return false;
        }
        for (int i = 0; i < this.rawCertInfo.length; ++i) {
            if (this.rawCertInfo[i] == other.rawCertInfo[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 1; i < this.rawCertInfo.length; ++i) {
            retval += this.rawCertInfo[i] * i;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        if (this.subject == null || this.pubKey == null || this.interval == null || this.issuer == null || this.algId == null || this.serialNum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        StringBuffer sb = new StringBuffer("[\n  " + this.version.toString() + "\n  Subject: " + this.subject.toString() + "\n  Signature Algorithm: " + this.algId.toString() + "\n  Key:  " + this.pubKey.toString() + "\n");
        sb.append("  " + this.interval.toString() + "\n  Issuer: " + this.issuer.toString() + "\n  " + this.serialNum.toString() + "\n");
        if (this.issuerUniqueId != null) {
            sb.append("  Issuer Id:\n" + this.issuerUniqueId.toString() + "\n");
        }
        if (this.subjectUniqueId != null) {
            sb.append("  Subject Id:\n" + this.subjectUniqueId.toString() + "\n");
        }
        if (this.extensions != null) {
            PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
            for (int i = 0; i < this.extensions.size(); ++i) {
                sb.append("  Extension[" + i + "] = ");
                Extension ext = (Extension)this.extensions.elementAt(i);
                ByteArrayOutputStream out = null;
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb.append(ext.toString());
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        out = new DerOutputStream();
                        ((DerOutputStream)out).putOctetString(extValue);
                        extValue = out.toByteArray();
                        String extValuebits = pp.toHexString(extValue);
                        sb.append("Extension unknown: DER encoded OCTET string =\n" + extValuebits);
                        continue;
                    }
                    sb.append(ext.toString());
                    continue;
                }
                catch (IOException | CertificateException e) {
                    sb.append(", Error parsing this extension");
                    continue;
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            logger.debug("Error closing stream", (Throwable)e);
                        }
                    }
                }
            }
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public void set(String name, Object val) throws CertificateException, IOException {
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            throw new CertificateException("Attribute name not recognized: " + name);
        }
        this.rawCertInfo = null;
        switch (attr) {
            case 1: {
                if (attrName.getSuffix() == null) {
                    this.setVersion(val);
                    break;
                }
                this.version.set(attrName.getSuffix(), val);
                break;
            }
            case 2: {
                if (attrName.getSuffix() == null) {
                    this.setSerialNumber(val);
                    break;
                }
                this.serialNum.set(attrName.getSuffix(), val);
                break;
            }
            case 3: {
                if (attrName.getSuffix() == null) {
                    this.setAlgorithmId(val);
                    break;
                }
                this.algId.set(attrName.getSuffix(), val);
                break;
            }
            case 4: {
                if (attrName.getSuffix() == null) {
                    this.setIssuer(val);
                    break;
                }
                this.issuer.set(attrName.getSuffix(), val);
                break;
            }
            case 5: {
                if (attrName.getSuffix() == null) {
                    this.setValidity(val);
                    break;
                }
                this.interval.set(attrName.getSuffix(), val);
                break;
            }
            case 6: {
                if (attrName.getSuffix() == null) {
                    this.setSubject(val);
                    break;
                }
                this.subject.set(attrName.getSuffix(), val);
                break;
            }
            case 7: {
                if (attrName.getSuffix() == null) {
                    this.setKey(val);
                    break;
                }
                this.pubKey.set(attrName.getSuffix(), val);
                break;
            }
            case 8: {
                if (attrName.getSuffix() == null) {
                    this.setIssuerUniqueId(val);
                    break;
                }
                this.issuerUniqueId.set(attrName.getSuffix(), val);
                break;
            }
            case 9: {
                if (attrName.getSuffix() == null) {
                    this.setSubjectUniqueId(val);
                    break;
                }
                this.subjectUniqueId.set(attrName.getSuffix(), val);
                break;
            }
            case 10: {
                if (attrName.getSuffix() == null) {
                    this.setExtensions(val);
                    break;
                }
                this.extensions.set(attrName.getSuffix(), val);
            }
        }
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            throw new CertificateException("Attribute name not recognized: " + name);
        }
        this.rawCertInfo = null;
        switch (attr) {
            case 1: {
                if (attrName.getSuffix() == null) {
                    this.version = null;
                    break;
                }
                this.version.delete(attrName.getSuffix());
                break;
            }
            case 2: {
                if (attrName.getSuffix() == null) {
                    this.serialNum = null;
                    break;
                }
                this.serialNum.delete(attrName.getSuffix());
                break;
            }
            case 3: {
                if (attrName.getSuffix() == null) {
                    this.algId = null;
                    break;
                }
                this.algId.delete(attrName.getSuffix());
                break;
            }
            case 4: {
                if (attrName.getSuffix() == null) {
                    this.issuer = null;
                    break;
                }
                this.issuer.delete(attrName.getSuffix());
                break;
            }
            case 5: {
                if (attrName.getSuffix() == null) {
                    this.interval = null;
                    break;
                }
                this.interval.delete(attrName.getSuffix());
                break;
            }
            case 6: {
                if (attrName.getSuffix() == null) {
                    this.subject = null;
                    break;
                }
                this.subject.delete(attrName.getSuffix());
                break;
            }
            case 7: {
                if (attrName.getSuffix() == null) {
                    this.pubKey = null;
                    break;
                }
                this.pubKey.delete(attrName.getSuffix());
                break;
            }
            case 8: {
                if (attrName.getSuffix() == null) {
                    this.issuerUniqueId = null;
                    break;
                }
                this.issuerUniqueId.delete(attrName.getSuffix());
                break;
            }
            case 9: {
                if (attrName.getSuffix() == null) {
                    this.subjectUniqueId = null;
                    break;
                }
                this.subjectUniqueId.delete(attrName.getSuffix());
                break;
            }
            case 10: {
                if (attrName.getSuffix() == null) {
                    this.extensions = null;
                    break;
                }
                this.extensions.delete(attrName.getSuffix());
            }
        }
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            throw new CertificateParsingException("Attribute name not recognized: " + name);
        }
        String suffix = attrName.getSuffix();
        boolean suffixIsNull = suffix == null;
        return switch (attr) {
            case 1 -> {
                if (suffixIsNull) {
                    yield this.version;
                }
                yield this.version.get(suffix);
            }
            case 2 -> {
                if (suffixIsNull) {
                    yield this.serialNum;
                }
                yield this.serialNum.get(suffix);
            }
            case 3 -> {
                if (suffixIsNull) {
                    yield this.algId;
                }
                yield this.algId.get(suffix);
            }
            case 4 -> {
                if (suffixIsNull) {
                    yield this.issuer;
                }
                yield this.issuer.get(suffix);
            }
            case 5 -> {
                if (suffixIsNull) {
                    yield this.interval;
                }
                yield this.interval.get(suffix);
            }
            case 6 -> {
                if (suffixIsNull) {
                    yield this.subject;
                }
                yield this.subject.get(suffix);
            }
            case 7 -> {
                if (suffixIsNull) {
                    yield this.pubKey;
                }
                yield this.pubKey.get(suffix);
            }
            case 8 -> {
                if (suffixIsNull) {
                    yield this.issuerUniqueId;
                }
                if (this.issuerUniqueId == null) {
                    yield null;
                }
                yield this.issuerUniqueId.get(suffix);
            }
            case 9 -> {
                if (suffixIsNull) {
                    yield this.subjectUniqueId;
                }
                if (this.subjectUniqueId == null) {
                    yield null;
                }
                yield this.subjectUniqueId.get(suffix);
            }
            case 10 -> {
                if (suffixIsNull) {
                    yield this.extensions;
                }
                if (this.extensions == null) {
                    yield null;
                }
                yield this.extensions.get(suffix);
            }
            default -> null;
        };
    }

    private void parse(DerValue val) throws CertificateParsingException, IOException {
        if (val.tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.rawCertInfo = val.toByteArray();
        DerInputStream in = val.data;
        DerValue tmp = in.getDerValue();
        if (tmp.isContextSpecific((byte)0)) {
            this.version = new CertificateVersion(tmp);
            tmp = in.getDerValue();
        }
        this.serialNum = new CertificateSerialNumber(tmp);
        this.algId = new CertificateAlgorithmId(in);
        this.issuer = new CertificateIssuerName(in);
        this.interval = new CertificateValidity(in);
        this.subject = new CertificateSubjectName(in);
        this.pubKey = new CertificateX509Key(in);
        if (in.available() != 0) {
            if (this.version.compare(0) == 0) {
                throw new CertificateParsingException("excess cert data");
            }
        } else {
            return;
        }
        tmp = in.getDerValue();
        if (tmp.isContextSpecific((byte)1)) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity(tmp);
            if (in.available() == 0) {
                return;
            }
            tmp = in.getDerValue();
        }
        if (tmp.isContextSpecific((byte)2)) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity(tmp);
            if (in.available() == 0) {
                return;
            }
            tmp = in.getDerValue();
        }
        if (this.version.compare(2) != 0) {
            throw new CertificateParsingException("excess cert data");
        }
        if (tmp.isConstructed() && tmp.isContextSpecific((byte)3)) {
            this.extensions = new CertificateExtensions(tmp.data);
        }
    }

    private void emit(DerOutputStream out) throws CertificateException, IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.version.encode(tmp);
        this.serialNum.encode(tmp);
        this.algId.encode(tmp);
        this.issuer.encode(tmp);
        this.interval.encode(tmp);
        this.subject.encode(tmp);
        this.pubKey.encode(tmp);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.encode(tmp);
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.encode(tmp);
        }
        if (this.extensions != null) {
            this.extensions.encode(tmp);
        }
        out.write((byte)48, tmp);
    }

    private void writeObject(ObjectOutputStream stream) throws CertificateException, IOException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws CertificateException, IOException {
        this.decode(stream);
    }

    private int attributeMap(String name) {
        Integer num = map.get(name);
        if (num == null) {
            return 0;
        }
        return num;
    }

    private void setVersion(Object val) throws CertificateException {
        if (!(val instanceof CertificateVersion)) {
            throw new CertificateException("Version class type invalid.");
        }
        this.version = (CertificateVersion)val;
    }

    private void setSerialNumber(Object val) throws CertificateException {
        if (!(val instanceof CertificateSerialNumber)) {
            throw new CertificateException("SerialNumber class type invalid.");
        }
        this.serialNum = (CertificateSerialNumber)val;
    }

    private void setAlgorithmId(Object val) throws CertificateException {
        if (!(val instanceof CertificateAlgorithmId)) {
            throw new CertificateException("AlgorithmId class type invalid.");
        }
        this.algId = (CertificateAlgorithmId)val;
    }

    private void setIssuer(Object val) throws CertificateException {
        if (!(val instanceof CertificateIssuerName)) {
            throw new CertificateException("Issuer class type invalid.");
        }
        this.issuer = (CertificateIssuerName)val;
    }

    public CertificateIssuerName getIssuerObj() {
        return this.issuer;
    }

    private void setValidity(Object val) throws CertificateException {
        if (!(val instanceof CertificateValidity)) {
            throw new CertificateException("CertificateValidity class type invalid.");
        }
        this.interval = (CertificateValidity)val;
    }

    private void setSubject(Object val) throws CertificateException {
        if (!(val instanceof CertificateSubjectName)) {
            throw new CertificateException("Subject class type invalid.");
        }
        this.subject = (CertificateSubjectName)val;
    }

    public CertificateSubjectName getSubjectObj() {
        return this.subject;
    }

    private void setKey(Object val) throws CertificateException {
        if (!(val instanceof CertificateX509Key)) {
            throw new CertificateException("Key class type invalid.");
        }
        this.pubKey = (CertificateX509Key)val;
    }

    private void setIssuerUniqueId(Object val) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(val instanceof CertificateIssuerUniqueIdentity)) {
            throw new CertificateException("IssuerUniqueId class type invalid.");
        }
        this.issuerUniqueId = (CertificateIssuerUniqueIdentity)val;
    }

    private void setSubjectUniqueId(Object val) throws CertificateException {
        if (this.version.compare(1) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(val instanceof CertificateSubjectUniqueIdentity)) {
            throw new CertificateException("SubjectUniqueId class type invalid.");
        }
        this.subjectUniqueId = (CertificateSubjectUniqueIdentity)val;
    }

    private void setExtensions(Object val) throws CertificateException {
        if (this.version.compare(2) < 0) {
            throw new CertificateException("Invalid version");
        }
        if (!(val instanceof CertificateExtensions)) {
            throw new CertificateException("Extensions class type invalid.");
        }
        this.extensions = (CertificateExtensions)val;
    }

    static {
        map.put(VERSION, 1);
        map.put(SERIAL_NUMBER, 2);
        map.put(ALGORITHM_ID, 3);
        map.put(ISSUER, 4);
        map.put(VALIDITY, 5);
        map.put(SUBJECT, 6);
        map.put(KEY, 7);
        map.put(ISSUER_ID, 8);
        map.put(SUBJECT_ID, 9);
        map.put(EXTENSIONS, 10);
    }
}

