/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.util.EC;

public final class PK11ECPublicKey
extends PK11PubKey
implements ECPublicKey {
    private static final long serialVersionUID = 1L;

    public PK11ECPublicKey(byte[] pointer) {
        super(pointer);
    }

    @Override
    public ECParameterSpec getParams() {
        byte[] curveData = this.getCurveByteArray();
        return EC.decodeNSSOID(curveData);
    }

    public byte[] getCurveBA() {
        return this.getCurveByteArray();
    }

    @Override
    public ECPoint getW() {
        byte[] pointData = this.getWByteArray();
        return EC.decodeNSSPoint(pointData);
    }

    private native byte[] getCurveByteArray();

    public native byte[] getWByteArray();
}

