/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;

public class ResponseBody
implements ASN1Value {
    private SEQUENCE sequence = new SEQUENCE();
    private SEQUENCE controlSequence;
    private SEQUENCE cmsSequence;
    private SEQUENCE otherMsgSequence;
    static Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public ResponseBody(SEQUENCE controlSequence, SEQUENCE cmsSequence, SEQUENCE otherMsgSequence) {
        this.controlSequence = controlSequence;
        this.sequence.addElement(controlSequence);
        this.cmsSequence = cmsSequence;
        this.sequence.addElement(cmsSequence);
        this.otherMsgSequence = otherMsgSequence;
        this.sequence.addElement(otherMsgSequence);
    }

    public SEQUENCE getControlSequence() {
        return this.controlSequence;
    }

    public SEQUENCE getCmsSequence() {
        return this.cmsSequence;
    }

    public SEQUENCE getOtherMsgSequence() {
        return this.otherMsgSequence;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new SEQUENCE.OF_Template(TaggedAttribute.getTemplate()));
            this.seqt.addElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            assert (seq.size() == 3);
            return new ResponseBody((SEQUENCE)seq.elementAt(0), (SEQUENCE)seq.elementAt(1), (SEQUENCE)seq.elementAt(2));
        }
    }
}

