/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.IOException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.provider.javax.crypto.JSSNativeTrustManager;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLSocketException;
import org.mozilla.jss.ssl.javax.JSSSocket;
import org.mozilla.jss.ssl.javax.JSSSocketFactory;

public class BadSSL {
    private static SSLContext ctx;
    private static JSSSocketFactory jsf;

    public static KeyManager[] getKMs() throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("NssX509");
        return kmf.getKeyManagers();
    }

    public static void main(String[] args) throws Exception {
        boolean ocsp = false;
        if (args.length < 1) {
            System.out.println("Usage: BadSSL nssdb [LEAF_AND_CHAIN]");
            return;
        }
        if (args.length >= 2 && args[1].equals("LEAF_AND_CHAIN")) {
            System.out.println("Enabling leaf and chain policy...");
            ocsp = true;
        }
        CryptoManager cm = CryptoManager.getInstance();
        if (ocsp) {
            CryptoManager.setOCSPPolicy((CryptoManager.OCSPPolicy)CryptoManager.OCSPPolicy.LEAF_AND_CHAIN);
        }
        ctx = SSLContext.getInstance("TLS", "Mozilla-JSS");
        ctx.init(BadSSL.getKMs(), new TrustManager[]{new JSSNativeTrustManager()}, null);
        jsf = (JSSSocketFactory)ctx.getSocketFactory();
        BadSSL.testExpired();
        BadSSL.testWrongHost();
        BadSSL.testSelfSigned();
        BadSSL.testUntrustedRoot();
        BadSSL.testSHA1();
        BadSSL.testRC4MD5();
        BadSSL.testRC4();
        BadSSL.test3DES();
        BadSSL.testNULL();
        if (ocsp) {
            BadSSL.testRevoked();
        }
        BadSSL.testSHA256();
        BadSSL.testSHA384();
        BadSSL.testSHA512();
        BadSSL.testECC256();
        BadSSL.testECC384();
        BadSSL.testRSA2048();
        BadSSL.testRSA4096();
        BadSSL.testRSA8192();
        BadSSL.testExtendedValidation();
    }

    public static void testExpired() throws Exception {
        BadSSL.testHelper("expired.badssl.com", 443, new String[]{"(-8181)", "has expired"});
    }

    public static void testWrongHost() throws Exception {
        BadSSL.testHelper("wrong.host.badssl.com", 443, new String[]{"(-12276)", "domain name does not match"});
    }

    public static void testSelfSigned() throws Exception {
        BadSSL.testHelper("self-signed.badssl.com", 443, new String[]{"(-8101)", "(-8156)", "type not approved", "issuer certificate is invalid"});
    }

    public static void testUntrustedRoot() throws Exception {
        BadSSL.testHelper("untrusted-root.badssl.com", 443, new String[]{"(-8172)", "certificate issuer has been marked as not trusted"});
    }

    public static void testRevoked() throws Exception {
        BadSSL.testHelper("revoked.badssl.com", 443, new String[]{"(-8180)", "has been revoked"});
    }

    public static void testSHA1() throws Exception {
        try {
            BadSSL.testHelper("sha1-intermediate.badssl.com", 443, new String[]{"(-12286)", "Cannot communicate securely"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testRC4MD5() throws Exception {
        try {
            BadSSL.testHelper("rc4-md5.badssl.com", 443, new String[]{"(-12286)", "Cannot communicate securely"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testRC4() throws Exception {
        try {
            BadSSL.testHelper("rc4.badssl.com", 443, new String[]{"(-12286)", "Cannot communicate securely"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void test3DES() throws Exception {
        try {
            BadSSL.testHelper("3des.badssl.com", 443, new String[]{"(-12286)", "Cannot communicate securely"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testNULL() throws Exception {
        try {
            BadSSL.testHelper("null.badssl.com", 443, new String[]{"(-12286)", "Cannot communicate securely"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testSHA256() throws Exception {
        BadSSL.testHelper("sha256.badssl.com", 443);
    }

    public static void testSHA384() throws Exception {
        BadSSL.testHelper("sha384.badssl.com", 443);
    }

    public static void testSHA512() throws Exception {
        BadSSL.testHelper("sha512.badssl.com", 443);
    }

    public static void testECC256() throws Exception {
        BadSSL.testHelper("ecc256.badssl.com", 443);
    }

    public static void testECC384() throws Exception {
        BadSSL.testHelper("ecc384.badssl.com", 443);
    }

    public static void testRSA2048() throws Exception {
        BadSSL.testHelper("rsa2048.badssl.com", 443);
    }

    public static void testRSA4096() throws Exception {
        BadSSL.testHelper("rsa4096.badssl.com", 443);
    }

    public static void testRSA8192() throws Exception {
        BadSSL.testHelper("rsa8192.badssl.com", 443);
    }

    public static void testExtendedValidation() throws Exception {
        BadSSL.testHelper("extended-validation.badssl.com", 443);
    }

    public static void testHelper(String host, int port) throws Exception {
        BadSSL.testSiteOldSSLSocket(host, port);
        BadSSL.testSiteJavaxSSLSocket(host, port);
        System.out.println("\t...ok");
    }

    public static void testHelper(String host, int port, String[] substrs) throws Exception {
        BadSSL.testHelperOld(host, port, substrs);
        BadSSL.testHelperJavax(host, port, substrs);
    }

    public static void testHelperOld(String host, int port, String[] substrs) throws Exception {
        try {
            BadSSL.testSiteOldSSLSocket(host, port);
        }
        catch (SSLSocketException sse) {
            String actual = sse.getMessage().toLowerCase();
            for (String expected : substrs) {
                if (!actual.contains(expected.toLowerCase())) continue;
                System.out.println("\t...got expected error message.");
                return;
            }
            if (actual.contains("(-8016) unknown error")) {
                System.out.println("\t...got unknown error; continuing anyways.");
                return;
            }
            System.err.println("\tUnexpected error message: " + actual);
            throw sse;
        }
        throw new RuntimeException("Expected to get an exception, but didn't!");
    }

    public static void testHelperJavax(String host, int port, String[] substrs) throws Exception {
        try {
            BadSSL.testSiteJavaxSSLSocket(host, port);
        }
        catch (IOException sse) {
            String actual = sse.getMessage().toLowerCase();
            for (String expected : substrs) {
                if (!actual.contains(expected.toLowerCase())) continue;
                System.out.println("\t...got expected error message.");
                return;
            }
            if (actual.contains("(-8016) unknown error")) {
                System.out.println("\t...got unknown error; continuing anyways.");
                return;
            }
            System.err.println("\tUnexpected error message: " + actual);
            throw sse;
        }
        throw new RuntimeException("Expected to get an exception, but didn't!");
    }

    public static void testSiteOldSSLSocket(String host, int port) throws Exception {
        System.out.println("Testing connection to " + host + ":" + port);
        try (SSLSocket sock = new SSLSocket(host, 443);){
            sock.forceHandshake();
            sock.shutdownOutput();
            sock.shutdownInput();
        }
    }

    public static void testSiteJavaxSSLSocket(String host, int port) throws Exception {
        System.out.println("Testing connection to " + host + ":" + port);
        try (JSSSocket sock = jsf.createSocket(host, port);){
            sock.setUseClientMode(true);
            sock.setWantClientAuth(false);
            sock.setNeedClientAuth(false);
            sock.setHostname(host);
            sock.startHandshake();
            sock.shutdownOutput();
            sock.shutdownInput();
        }
    }
}

