/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;
import org.mozilla.jss.netscape.security.x509.PrintableConverter;
import org.mozilla.jss.tests.ConverterTestUtil;
import org.mozilla.jss.tests.JSSUtil;
import org.mozilla.jss.tests.StringTestUtil;

public class PrintableConverterTest {
    @Test
    public void testEmptyString() throws Exception {
        String string = "";
        System.out.println("Converting: [" + string + "]");
        byte[] expected = JSSUtil.encode((byte)19, string);
        System.out.println(" - expected: " + StringTestUtil.toString(expected));
        byte[] actual = ConverterTestUtil.convert((AVAValueConverter)new PrintableConverter(), string);
        System.out.println(" - actual  : " + StringTestUtil.toString(actual));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testNullCharacters() throws Exception {
        String string = "\u0000";
        System.out.println("Converting: [" + StringTestUtil.toString(string.getBytes()) + "]");
        System.out.println(" - expected: IllegalArgumentException");
        try {
            byte[] actual = ConverterTestUtil.convert((AVAValueConverter)new PrintableConverter(), string);
            System.out.println(" - actual  : " + StringTestUtil.toString(actual));
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testPrintableCharacters() throws Exception {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 '()+,-./:=?";
        System.out.println("Converting: [" + string + "]");
        byte[] expected = JSSUtil.encode((byte)19, string);
        System.out.println(" - expected: " + StringTestUtil.toString(expected));
        byte[] actual = ConverterTestUtil.convert((AVAValueConverter)new PrintableConverter(), string);
        System.out.println(" - actual  : " + StringTestUtil.toString(actual));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testControlCharacters() throws Exception {
        String string = "\b\t\n\f\r";
        System.out.println("Converting: [" + StringTestUtil.toString(string.getBytes()) + "]");
        System.out.println(" - expected: IllegalArgumentException");
        try {
            byte[] actual = ConverterTestUtil.convert((AVAValueConverter)new PrintableConverter(), string);
            System.out.println(" - actual  : " + StringTestUtil.toString(actual));
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testMultibyteCharacters() throws Exception {
        String string = "\u6211\u7231\u4f60";
        System.out.println("Converting: [" + string + "]");
        System.out.println(" - expected: IllegalArgumentException");
        try {
            byte[] actual = ConverterTestUtil.convert((AVAValueConverter)new PrintableConverter(), string);
            System.out.println(" - actual  : " + StringTestUtil.toString(actual));
            Assertions.fail();
        }
        catch (Exception e) {
            System.out.println(" - actual  : " + e.getClass().getSimpleName());
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

