/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.nio.ByteBuffer;
import org.mozilla.jss.netscape.security.x509.InvalidNetmaskException;

public class CIDRNetmask {
    private int n;

    public CIDRNetmask(String s) {
        this(Integer.parseInt(s));
    }

    public CIDRNetmask(int n) {
        if (n < 0) {
            throw new InvalidNetmaskException("cannot be negative");
        }
        this.n = n;
    }

    protected void write(ByteBuffer buf) {
        int remaining = buf.remaining();
        int bits = 0;
        if (remaining == 4) {
            bits = 32;
        } else if (remaining == 16) {
            bits = 128;
        } else {
            throw new InvalidNetmaskException("cannot determine type of address for netmask");
        }
        if (this.n > bits) {
            throw new InvalidNetmaskException("netmask exceed address size");
        }
        int maskSigBits = this.n;
        while (remaining > 0) {
            int maskByteSigBits = Math.min(8, maskSigBits);
            byte maskByte = (byte)(255 - (255 >> maskByteSigBits));
            buf.put(maskByte);
            maskSigBits = Math.max(maskSigBits - 8, 0);
            --remaining;
        }
    }

    public String toString() {
        return "/" + this.n;
    }
}

