/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyMap;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class PolicyMappingsExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -4023336164621135851L;
    public static final String IDENT = "x509.info.extensions.PolicyMappings";
    public static final String NAME = "PolicyMappings";
    public static final String MAP = "map";
    private Vector<CertificatePolicyMap> maps = null;

    private void encodeThis() throws IOException {
        try (DerOutputStream os = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            for (int i = 0; i < this.maps.size(); ++i) {
                this.maps.elementAt(i).encode(tmp);
            }
            os.write((byte)48, tmp);
            this.extensionValue = os.toByteArray();
        }
    }

    public PolicyMappingsExtension(Vector<CertificatePolicyMap> map) throws IOException {
        this.init(false, map);
    }

    public PolicyMappingsExtension(boolean critical, Vector<CertificatePolicyMap> map) throws IOException {
        this.init(critical, map);
    }

    private void init(boolean critical, Vector<CertificatePolicyMap> map) throws IOException {
        this.maps = map;
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public PolicyMappingsExtension() {
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = false;
        this.maps = new Vector(1, 1);
    }

    public PolicyMappingsExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for PolicyMappingsExtension.");
        }
        this.maps = new Vector(1, 1);
        while (val.data.available() != 0) {
            DerValue seq = val.data.getDerValue();
            CertificatePolicyMap map = new CertificatePolicyMap(seq);
            this.maps.addElement(map);
        }
    }

    @Override
    public String toString() {
        if (this.maps == null) {
            return "";
        }
        String s = super.toString() + "PolicyMappings [\n" + this.maps.toString() + "]\n";
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyMappings_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (name.equalsIgnoreCase(MAP)) {
            if (!(obj instanceof Vector)) {
                throw new IOException("Attribute value should be of type Vector.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = (Vector)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(MAP)) {
            return this.maps;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(MAP)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(MAP);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Enumeration<CertificatePolicyMap> getMappings() {
        if (this.maps == null) {
            return null;
        }
        return this.maps.elements();
    }
}

