/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class DigestInfo
implements ASN1Value {
    private AlgorithmIdentifier digestAlgorithm;
    private OCTET_STRING digest;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public DigestInfo(AlgorithmIdentifier digestAlgorithm, OCTET_STRING digest) {
        if (digestAlgorithm == null || digest == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = new SEQUENCE();
        this.digestAlgorithm = digestAlgorithm;
        this.sequence.addElement(digestAlgorithm);
        this.digest = digest;
        this.sequence.addElement(digest);
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public OCTET_STRING getDigest() {
        return this.digest;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DigestInfo)) {
            return false;
        }
        DigestInfo di = (DigestInfo)obj;
        return DigestInfo.byteArraysAreSame(di.digest.toByteArray(), this.digest.toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.digest.toByteArray());
    }

    private static boolean byteArraysAreSame(byte[] left, byte[] right) {
        assert (left != null && right != null);
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream ostream) throws InvalidBERException, IOException {
            return this.decode(TAG, ostream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream ostream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, ostream);
            return new DigestInfo((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1));
        }
    }
}

