; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=i686-- -mcpu pentium4 < %s | FileCheck %s -check-prefix=SSE
; RUN: llc -mtriple=i686-- -mcpu pentium3 < %s | FileCheck %s -check-prefix=NOSSE2
; RUN: llc -mtriple=i686-- -mcpu pentium2 < %s | FileCheck %s -check-prefix=NOSSE1
; RUN: llc -mtriple=i686-- -mcpu pentium < %s | FileCheck %s -check-prefix=NOCMOV
; PR14035

define double @test1(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test1:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    ja .LBB0_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB0_3
; SSE-NEXT:  .LBB0_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB0_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test1:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovnbe %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test1:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovnbe %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test1:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    ja .LBB0_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB0_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ugt i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define double @test2(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test2:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    jae .LBB1_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB1_3
; SSE-NEXT:  .LBB1_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB1_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test2:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovnb %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test2:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovnb %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test2:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jae .LBB1_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB1_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp uge i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define double @test3(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test3:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    jb .LBB2_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB2_3
; SSE-NEXT:  .LBB2_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB2_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test3:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovb %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test3:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovb %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test3:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jb .LBB2_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB2_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ult i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define double @test4(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test4:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    jbe .LBB3_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB3_3
; SSE-NEXT:  .LBB3_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB3_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test4:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovbe %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test4:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovbe %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test4:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jbe .LBB3_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB3_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ule i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define double @test5(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test5:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    jg .LBB4_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB4_3
; SSE-NEXT:  .LBB4_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB4_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test5:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setg %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test5:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setg %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test5:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jg .LBB4_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB4_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sgt i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define double @test6(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test6:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    jge .LBB5_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB5_3
; SSE-NEXT:  .LBB5_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB5_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test6:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setge %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test6:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setge %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test6:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jge .LBB5_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB5_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sge i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define double @test7(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test7:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    jl .LBB6_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB6_3
; SSE-NEXT:  .LBB6_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB6_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test7:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setl %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test7:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setl %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test7:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jl .LBB6_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB6_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp slt i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define double @test8(i32 %a, i32 %b, double %x) nounwind {
; SSE-LABEL: test8:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %ebp
; SSE-NEXT:    movl %esp, %ebp
; SSE-NEXT:    andl $-8, %esp
; SSE-NEXT:    subl $8, %esp
; SSE-NEXT:    movl 8(%ebp), %eax
; SSE-NEXT:    cmpl 12(%ebp), %eax
; SSE-NEXT:    jle .LBB7_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    jmp .LBB7_3
; SSE-NEXT:  .LBB7_1:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  .LBB7_3:
; SSE-NEXT:    movsd %xmm0, (%esp)
; SSE-NEXT:    fldl (%esp)
; SSE-NEXT:    movl %ebp, %esp
; SSE-NEXT:    popl %ebp
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test8:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setle %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test8:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldl {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setle %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test8:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldl {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jle .LBB7_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB7_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sle i32 %a, %b
  %sel = select i1 %cmp, double 99.0, double %x
  ret double %sel
}

define float @test9(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test9:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    ja .LBB8_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB8_3
; SSE-NEXT:  .LBB8_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB8_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test9:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    ja .LBB8_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB8_3
; NOSSE2-NEXT:  .LBB8_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB8_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test9:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovnbe %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test9:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    ja .LBB8_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB8_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ugt i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define float @test10(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test10:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    jae .LBB9_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB9_3
; SSE-NEXT:  .LBB9_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB9_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test10:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    jae .LBB9_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB9_3
; NOSSE2-NEXT:  .LBB9_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB9_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test10:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovnb %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test10:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jae .LBB9_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB9_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp uge i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define float @test11(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test11:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    jb .LBB10_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB10_3
; SSE-NEXT:  .LBB10_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB10_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test11:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    jb .LBB10_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB10_3
; NOSSE2-NEXT:  .LBB10_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB10_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test11:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovb %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test11:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jb .LBB10_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB10_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ult i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define float @test12(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test12:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    jbe .LBB11_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB11_3
; SSE-NEXT:  .LBB11_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB11_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test12:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    jbe .LBB11_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB11_3
; NOSSE2-NEXT:  .LBB11_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB11_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test12:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovbe %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test12:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jbe .LBB11_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB11_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ule i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define float @test13(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test13:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    jg .LBB12_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB12_3
; SSE-NEXT:  .LBB12_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB12_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test13:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    jg .LBB12_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB12_3
; NOSSE2-NEXT:  .LBB12_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB12_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test13:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setg %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test13:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jg .LBB12_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB12_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sgt i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define float @test14(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test14:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    jge .LBB13_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB13_3
; SSE-NEXT:  .LBB13_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB13_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test14:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    jge .LBB13_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB13_3
; NOSSE2-NEXT:  .LBB13_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB13_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test14:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setge %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test14:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jge .LBB13_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB13_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sge i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define float @test15(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test15:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    jl .LBB14_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB14_3
; SSE-NEXT:  .LBB14_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB14_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test15:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    jl .LBB14_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB14_3
; NOSSE2-NEXT:  .LBB14_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB14_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test15:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setl %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test15:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jl .LBB14_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB14_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp slt i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define float @test16(i32 %a, i32 %b, float %x) nounwind {
; SSE-LABEL: test16:
; SSE:       # %bb.0:
; SSE-NEXT:    pushl %eax
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    jle .LBB15_1
; SSE-NEXT:  # %bb.2:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    jmp .LBB15_3
; SSE-NEXT:  .LBB15_1:
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:  .LBB15_3:
; SSE-NEXT:    movss %xmm0, (%esp)
; SSE-NEXT:    flds (%esp)
; SSE-NEXT:    popl %eax
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test16:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    pushl %eax
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    jle .LBB15_1
; NOSSE2-NEXT:  # %bb.2:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:    jmp .LBB15_3
; NOSSE2-NEXT:  .LBB15_1:
; NOSSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; NOSSE2-NEXT:  .LBB15_3:
; NOSSE2-NEXT:    movss %xmm0, (%esp)
; NOSSE2-NEXT:    flds (%esp)
; NOSSE2-NEXT:    popl %eax
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test16:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    flds {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setle %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test16:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    flds {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jle .LBB15_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB15_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sle i32 %a, %b
  %sel = select i1 %cmp, float 99.0, float %x
  ret float %sel
}

define x86_fp80 @test17(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test17:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fcmovnbe %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test17:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovnbe %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test17:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovnbe %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test17:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    ja .LBB16_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB16_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ugt i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}

define x86_fp80 @test18(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test18:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fcmovnb %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test18:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovnb %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test18:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovnb %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test18:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jae .LBB17_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB17_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp uge i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}

define x86_fp80 @test19(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test19:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fcmovb %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test19:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovb %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test19:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovb %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test19:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jb .LBB18_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB18_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ult i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}

define x86_fp80 @test20(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test20:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fcmovbe %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test20:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovbe %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test20:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovbe %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test20:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jbe .LBB19_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB19_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp ule i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}

define x86_fp80 @test21(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test21:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    setg %al
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    fcmovne %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test21:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setg %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test21:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setg %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test21:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jg .LBB20_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB20_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
; We don't emit a branch for fp80, why?
  %cmp = icmp sgt i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}

define x86_fp80 @test22(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test22:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    setge %al
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    fcmovne %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test22:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setge %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test22:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setge %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test22:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jge .LBB21_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB21_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sge i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}

define x86_fp80 @test23(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test23:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    setl %al
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    fcmovne %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test23:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setl %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test23:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setl %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test23:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jl .LBB22_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB22_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp slt i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}

define x86_fp80 @test24(i32 %a, i32 %b, x86_fp80 %x) nounwind {
; SSE-LABEL: test24:
; SSE:       # %bb.0:
; SSE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; SSE-NEXT:    fxch %st(1)
; SSE-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; SSE-NEXT:    setle %al
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    fcmovne %st(1), %st
; SSE-NEXT:    fstp %st(1)
; SSE-NEXT:    retl
;
; NOSSE2-LABEL: test24:
; NOSSE2:       # %bb.0:
; NOSSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE2-NEXT:    setle %al
; NOSSE2-NEXT:    testb %al, %al
; NOSSE2-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE2-NEXT:    fxch %st(1)
; NOSSE2-NEXT:    fcmovne %st(1), %st
; NOSSE2-NEXT:    fstp %st(1)
; NOSSE2-NEXT:    retl
;
; NOSSE1-LABEL: test24:
; NOSSE1:       # %bb.0:
; NOSSE1-NEXT:    fldt {{[0-9]+}}(%esp)
; NOSSE1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOSSE1-NEXT:    setle %al
; NOSSE1-NEXT:    testb %al, %al
; NOSSE1-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOSSE1-NEXT:    fxch %st(1)
; NOSSE1-NEXT:    fcmovne %st(1), %st
; NOSSE1-NEXT:    fstp %st(1)
; NOSSE1-NEXT:    retl
;
; NOCMOV-LABEL: test24:
; NOCMOV:       # %bb.0:
; NOCMOV-NEXT:    fldt {{[0-9]+}}(%esp)
; NOCMOV-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    cmpl {{[0-9]+}}(%esp), %eax
; NOCMOV-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; NOCMOV-NEXT:    jle .LBB23_2
; NOCMOV-NEXT:  # %bb.1:
; NOCMOV-NEXT:    fstp %st(0)
; NOCMOV-NEXT:    fldz
; NOCMOV-NEXT:    fxch %st(1)
; NOCMOV-NEXT:  .LBB23_2:
; NOCMOV-NEXT:    fstp %st(1)
; NOCMOV-NEXT:    retl
  %cmp = icmp sle i32 %a, %b
  %sel = select i1 %cmp, x86_fp80 0xK4005C600000000000000, x86_fp80 %x
  ret x86_fp80 %sel
}
