; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux-gnu < %s  | FileCheck %s

; Ensure vectorized FPOWs are not widened/unrolled such that they get lowered
; into libcalls on undef elements.

define float @test_fpow_v2f32_multiuse(<2 x float> %a0, <2 x float> %a1, ptr%p3) nounwind {
; CHECK-LABEL: test_fpow_v2f32_multiuse:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $48, %rsp
; CHECK-NEXT:    movq %rdi, %rbx
; CHECK-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    callq powf@PLT
; CHECK-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1,1,1]
; CHECK-NEXT:    callq powf@PLT
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; CHECK-NEXT:    movaps %xmm2, %xmm1
; CHECK-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; CHECK-NEXT:    addss %xmm2, %xmm0
; CHECK-NEXT:    movlps %xmm1, (%rbx)
; CHECK-NEXT:    addq $48, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    retq
  %fp = call <2 x float> @llvm.pow.v2f32(<2 x float> %a0, <2 x float> %a1)
  %fp0 = extractelement <2 x float> %fp, i32 0
  %fp1 = extractelement <2 x float> %fp, i32 1
  %res = fadd float %fp0, %fp1
  store <2 x float> %fp, ptr%p3
  ret float %res
}
declare <2 x float> @llvm.pow.v2f32(<2 x float>, <2 x float>)

