/* ====================================================================
 * Copyright (c) 2011 The OpenSSL Project.  All rights reserved.
 * Copyright (c) 2013 Red Hat, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@openssl.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <string.h>
#include <openssl/crypto.h>
#include <openssl/dh.h>
#include <openssl/fips.h>
#include <openssl/err.h>
#include <openssl/evp.h>
#include <openssl/bn.h>
#include "fips_locl.h"

#ifdef OPENSSL_FIPS

static unsigned char dh_test_2048_p[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xF8,
    0x54, 0x58, 0xA2, 0xBB, 0x4A, 0x9A, 0xAF, 0xDC, 0x56, 0x20,
    0x27, 0x3D, 0x3C, 0xF1, 0xD8, 0xB9, 0xC5, 0x83, 0xCE, 0x2D,
    0x36, 0x95, 0xA9, 0xE1, 0x36, 0x41, 0x14, 0x64, 0x33, 0xFB,
    0xCC, 0x93, 0x9D, 0xCE, 0x24, 0x9B, 0x3E, 0xF9, 0x7D, 0x2F,
    0xE3, 0x63, 0x63, 0x0C, 0x75, 0xD8, 0xF6, 0x81, 0xB2, 0x02,
    0xAE, 0xC4, 0x61, 0x7A, 0xD3, 0xDF, 0x1E, 0xD5, 0xD5, 0xFD,
    0x65, 0x61, 0x24, 0x33, 0xF5, 0x1F, 0x5F, 0x06, 0x6E, 0xD0,
    0x85, 0x63, 0x65, 0x55, 0x3D, 0xED, 0x1A, 0xF3, 0xB5, 0x57,
    0x13, 0x5E, 0x7F, 0x57, 0xC9, 0x35, 0x98, 0x4F, 0x0C, 0x70,
    0xE0, 0xE6, 0x8B, 0x77, 0xE2, 0xA6, 0x89, 0xDA, 0xF3, 0xEF,
    0xE8, 0x72, 0x1D, 0xF1, 0x58, 0xA1, 0x36, 0xAD, 0xE7, 0x35,
    0x30, 0xAC, 0xCA, 0x4F, 0x48, 0x3A, 0x79, 0x7A, 0xBC, 0x0A,
    0xB1, 0x82, 0xB3, 0x24, 0xFB, 0x61, 0xD1, 0x08, 0xA9, 0x4B,
    0xB2, 0xC8, 0xE3, 0xFB, 0xB9, 0x6A, 0xDA, 0xB7, 0x60, 0xD7,
    0xF4, 0x68, 0x1D, 0x4F, 0x42, 0xA3, 0xDE, 0x39, 0x4D, 0xF4,
    0xAE, 0x56, 0xED, 0xE7, 0x63, 0x72, 0xBB, 0x19, 0x0B, 0x07,
    0xA7, 0xC8, 0xEE, 0x0A, 0x6D, 0x70, 0x9E, 0x02, 0xFC, 0xE1,
    0xCD, 0xF7, 0xE2, 0xEC, 0xC0, 0x34, 0x04, 0xCD, 0x28, 0x34,
    0x2F, 0x61, 0x91, 0x72, 0xFE, 0x9C, 0xE9, 0x85, 0x83, 0xFF,
    0x8E, 0x4F, 0x12, 0x32, 0xEE, 0xF2, 0x81, 0x83, 0xC3, 0xFE,
    0x3B, 0x1B, 0x4C, 0x6F, 0xAD, 0x73, 0x3B, 0xB5, 0xFC, 0xBC,
    0x2E, 0xC2, 0x20, 0x05, 0xC5, 0x8E, 0xF1, 0x83, 0x7D, 0x16,
    0x83, 0xB2, 0xC6, 0xF3, 0x4A, 0x26, 0xC1, 0xB2, 0xEF, 0xFA,
    0x88, 0x6B, 0x42, 0x38, 0x61, 0x28, 0x5C, 0x97, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};


static const unsigned char dh_test_2048_g[] = {
    0x02
};

static const unsigned char dh_test_2048_pub_key[] = {
0x89, 0x25, 0x56, 0x5f, 0x4e, 0x17, 0x00, 0xa4, 0x32, 0x83, 0x71, 0x70, 0x87, 0xd7,
0x14, 0x1d, 0x6d, 0xde, 0x0d, 0x44, 0x33, 0x8d, 0x6d, 0xb4, 0xa9, 0x2c, 0xf8, 0x3c, 0x21,
0x41, 0xb4, 0x64, 0x70, 0x10, 0x85, 0x11, 0x28, 0x82, 0xd8, 0x9f, 0x4a, 0x51, 0xb8, 0x3e,
0x06, 0x60, 0xdd, 0x28, 0x3b, 0x24, 0xf2, 0xba, 0x69, 0xee, 0x52, 0x64, 0x31, 0x98, 0x31,
0x5a, 0x54, 0xdb, 0xd9, 0x44, 0x44, 0x91, 0x49, 0xfd, 0x6b, 0x69, 0x58, 0x06, 0x1c, 0x52,
0xa9, 0x4f, 0xca, 0x3f, 0xdb, 0xcf, 0x3a, 0xff, 0xda, 0xea, 0x85, 0xdf, 0x49, 0x64, 0x7b,
0xfe, 0xdb, 0x60, 0x60, 0xfd, 0x47, 0xb0, 0xef, 0xc3, 0x2d, 0x36, 0x70, 0x19, 0x35, 0xf9,
0xc7, 0x10, 0xf6, 0xe2, 0xbc, 0x20, 0xa3, 0x13, 0x8d, 0x61, 0xee, 0x56, 0x64, 0x29, 0xb4,
0xab, 0xca, 0x41, 0xc1, 0xd7, 0x76, 0x7e, 0xcd, 0x9d, 0x67, 0x39, 0xb4, 0x57, 0x0c, 0xb2,
0x42, 0x07, 0xe8, 0x8a, 0x21, 0x47, 0x3d, 0xa2, 0x3a, 0x97, 0xf1, 0xc9, 0x4e, 0x67, 0xaf,
0x7f, 0x74, 0x34, 0x60, 0xf4, 0xcf, 0xe4, 0x66, 0x1e, 0xb4, 0x95, 0xaf, 0x66, 0x97, 0x44,
0xdf, 0x70, 0xb5, 0x08, 0xc7, 0x4d, 0x66, 0x1f, 0x95, 0x6b, 0x7b, 0x93, 0xe2, 0x31, 0x9f,
0x69, 0xe9, 0x56, 0xaa, 0xac, 0xf1, 0x52, 0x25, 0xb7, 0x67, 0x94, 0xaf, 0x1c, 0x65, 0x8f,
0xca, 0x7a, 0xf6, 0x68, 0x60, 0xc9, 0x54, 0xd4, 0x9a, 0x51, 0x6e, 0x18, 0x64, 0xb9, 0x5d,
0xed, 0xe4, 0x23, 0x68, 0xf3, 0x01, 0x6b, 0xf5, 0xd4, 0xd1, 0x83, 0x81, 0x33, 0xe5, 0x55,
0x5a, 0x28, 0x60, 0xfb, 0xa1, 0x21, 0xf9, 0x2b, 0x60, 0xa5, 0x2c, 0x30, 0x07, 0x8c, 0x04,
0x5b, 0xdb, 0xca, 0x6e, 0x1f, 0x81, 0x6d, 0x33, 0x35, 0x04, 0x70, 0x9e, 0x7f, 0x3c, 0xba,
0x77, 0xc6
};

static const unsigned char dh_test_2048_priv_key[] = {
0x6d, 0x76, 0xeb, 0xc3, 0x39, 0xcd, 0xf7, 0x22, 0xb1, 0x63, 0xb5, 0x06, 0xb4, 0xa5, 0xdf,
0x9d, 0x1d, 0xcf, 0x22, 0x59, 0xe3, 0x38, 0x5b, 0xb5, 0x4f, 0xbb, 0x82, 0xf4, 0x4d, 0xd0,
0x9e, 0x2e, 0x91, 0x2c, 0x05, 0xfb, 0x5c, 0x4a, 0x9f, 0x81, 0x93, 0x4f, 0x93, 0x92, 0x0b,
0xaa, 0xcd, 0x47, 0x78, 0x16, 0xcb, 0xe2, 0x11, 0x92, 0x18, 0x6a, 0x6a, 0xc9, 0x59, 0x22,
0xb0, 0x2a, 0x61, 0x6b, 0xa7, 0xee, 0xcb, 0x00, 0x30, 0x43, 0xe9, 0x6e, 0xa0, 0x42, 0x3f,
0xf0, 0xda, 0xda, 0xd1, 0x77, 0x1b, 0x71, 0x81, 0x60, 0x30, 0x03, 0xcb, 0x6d, 0xd7, 0xdf,
0xc5, 0x79, 0x79, 0xad, 0x31, 0x33, 0x4a, 0xc7, 0xd3, 0xf4, 0x4a, 0x9e, 0xa8, 0xfd, 0x29,
0xb0, 0xb6, 0x63, 0x3e, 0x1f, 0x75, 0x3e, 0x8b, 0x83, 0xbf, 0xa0, 0xb2, 0x61, 0x37, 0x8e,
0xe5, 0x1a, 0xd6, 0xdc, 0xed, 0xf8, 0x71, 0xb5, 0x94, 0x08, 0x26, 0xc0, 0xa8, 0x50, 0xa4,
0x7c, 0x04, 0xdc, 0x72, 0x95, 0xbf, 0xf0, 0x68, 0x62, 0xeb, 0x8c, 0x0a, 0x14, 0xc8, 0xad,
0x81, 0x18, 0x52, 0x76, 0x94, 0xb2, 0xae, 0x51, 0xaa, 0xb1, 0x6c, 0xcd, 0xfa, 0x49, 0x2d,
0x2a, 0x0d, 0x64, 0x9f, 0x51, 0x28, 0xd4, 0x41, 0xf1, 0xd2, 0x1b, 0xd5, 0xda, 0x82, 0x21,
0x31, 0x94, 0xc4, 0x1e, 0xdc, 0x86, 0xf4, 0x47, 0xee, 0xab, 0x3e, 0x08, 0x8d, 0x51, 0xd9,
0xbe, 0xec, 0x1e, 0x23, 0x30, 0x9c, 0xe9, 0xc1, 0x46, 0x8a, 0x2b, 0xa3, 0x11, 0x18, 0x94,
0x2d, 0x6e, 0x92, 0xb6, 0x50, 0x9d, 0x8e, 0x8c, 0xcb, 0x78, 0x5a, 0x84, 0xca, 0xbf, 0x6d,
0x83, 0x71, 0xa0, 0xe0, 0x19, 0x5a, 0x58, 0x37, 0x4c, 0x0e, 0x29, 0x62, 0x66, 0xb8, 0x25,
0x30, 0x36, 0x6a, 0xe7, 0x06, 0x2d, 0xfd, 0xa3, 0x9b, 0xb8, 0xd7, 0x4b, 0xca, 0x82, 0xdb,
0xcb
};

int FIPS_selftest_dh()
{
    DH *dh = NULL;
    int ret = 0;
    void *pub_key_bin = NULL;
    int len;
    BIGNUM *p = NULL, *g = NULL, *priv_key = NULL, *tmp_pub_key = NULL;
    const BIGNUM *pub_key;

    fips_load_key_component(p, dh_test_2048);
    fips_load_key_component(g, dh_test_2048);
    /* note that the private key is much shorter than normally used
     * but still g ** priv_key > p
     */
    fips_load_key_component(priv_key, dh_test_2048);
    if ((tmp_pub_key = BN_new()) == NULL)
        goto err;

    dh = DH_new();

    if (dh == NULL)
        goto err;

    DH_set0_pqg(dh, p, NULL, g);
    DH_set0_key(dh, tmp_pub_key, priv_key);

    if (DH_generate_key(dh) <= 0)
        goto err;

    DH_get0_key(dh, &pub_key, NULL);

    if (pub_key == NULL)
        goto err;

    len = BN_num_bytes(pub_key);
    if ((pub_key_bin = OPENSSL_malloc(len)) == NULL)
        goto err;
    BN_bn2bin(pub_key, pub_key_bin);

    if (len != sizeof(dh_test_2048_pub_key) ||
        memcmp(pub_key_bin, dh_test_2048_pub_key, len) != 0)
        goto err;

    ret = 1;

 err:
    if (dh)
        DH_free(dh);
    else {
        BN_free(p);
        BN_free(g);
        BN_free(priv_key);
        BN_free(tmp_pub_key);
    }

    OPENSSL_free(pub_key_bin);
    return ret;
}
#endif
