import { ClusterProperties } from "dev/types";

export const ok: ClusterProperties = {
  "batch-limit": {
    advanced: false,
    default: "0",
    longdesc:
      'The "correct" value will depend on the speed and load of your network and cluster nodes.',
    name: "batch-limit",
    readable_name: "Batch Limit",
    shortdesc:
      "The number of jobs that the TE is allowed to execute in parallel",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "cluster-delay": {
    advanced: false,
    default: "60s",
    longdesc:
      'The "correct" value will depend on the speed and load of your network and cluster nodes.',
    name: "cluster-delay",
    readable_name: "Cluster Delay",
    shortdesc: "Round trip delay over the network (excluding action execution)",
    source: "pacemaker-schedulerd",
    type: "time",
  },
  "cluster-ipc-limit": {
    advanced: true,
    default: "500",
    longdesc:
      'Raise this if log has "Evicting client" messages for cluster daemon PIDs (a good value is the number of resources in the cluster multiplied by the number of nodes)',
    name: "cluster-ipc-limit",
    readable_name: "cluster-ipc-limit",
    shortdesc:
      "Maximum IPC message backlog before disconnecting a cluster daemon",
    source: "pacemaker-based",
    type: "integer",
  },
  "cluster-name": {
    advanced: true,
    default: "(null)",
    longdesc:
      "This optional value is mostly for users' convenience as desired in administration, but may also be used in Pacemaker configuration rules via the #cluster-name node attribute, and by higher-level tools and resource agents.",
    name: "cluster-name",
    readable_name: "cluster-name",
    shortdesc: "An arbitrary name for the cluster",
    source: "pacemaker-controld",
    type: "string",
  },
  "cluster-recheck-interval": {
    advanced: true,
    default: "15min",
    longdesc:
      "The Cluster is primarily event driven, however the configuration can have elements that change based on time.  To ensure these changes take effect, we can optionally poll the cluster's status for changes.  Allowed values: Zero disables polling.  Positive values are an interval in seconds (unless other SI units are specified. eg. 5min)",
    name: "cluster-recheck-interval",
    readable_name: "cluster-recheck-interval",
    shortdesc:
      "Polling interval for time based changes to options, resource parameters and constraints.",
    source: "pacemaker-controld",
    type: "time",
  },
  "concurrent-fencing": {
    advanced: true,
    default: "true",
    longdesc: "",
    name: "concurrent-fencing",
    readable_name: "concurrent-fencing",
    shortdesc: "Allow performing fencing operations in parallel",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "dc-deadtime": {
    advanced: true,
    default: "20s",
    longdesc:
      'The "correct" value will depend on the speed/load of your network and the type of switches used.',
    name: "dc-deadtime",
    readable_name: "dc-deadtime",
    shortdesc:
      "How long to wait for a response from other nodes during startup.",
    source: "pacemaker-controld",
    type: "time",
  },
  "election-timeout": {
    advanced: true,
    default: "2min",
    longdesc:
      "If need to adjust this value, it probably indicates the presence of a bug.",
    name: "election-timeout",
    readable_name: "election-timeout",
    shortdesc: "*** Advanced Use Only ***.",
    source: "pacemaker-controld",
    type: "time",
  },
  "enable-acl": {
    advanced: false,
    default: "false",
    longdesc: "",
    name: "enable-acl",
    readable_name: "Enable ACLs",
    shortdesc: "Enable CIB ACL",
    source: "pacemaker-based",
    type: "boolean",
  },
  "enable-startup-probes": {
    advanced: true,
    default: "true",
    longdesc: "",
    name: "enable-startup-probes",
    readable_name: "enable-startup-probes",
    shortdesc: "Should the cluster check for active resources during startup",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "fence-reaction": {
    advanced: true,
    default: "stop",
    longdesc:
      'A cluster node may receive notification of its own fencing if fencing is misconfigured, or if fabric fencing is in use that doesn\'t cut cluster communication. Allowed values are "stop" to attempt to immediately stop pacemaker and stay stopped, or "panic" to attempt to immediately reboot the local node, falling back to stop on failure.',
    name: "fence-reaction",
    readable_name: "fence-reaction",
    shortdesc: "How a cluster node should react if notified of its own fencing",
    source: "pacemaker-controld",
    type: "string",
  },
  "have-watchdog": {
    advanced: true,
    default: "false",
    longdesc:
      "Set automatically by the cluster if SBD is detected.  User configured values are ignored.",
    name: "have-watchdog",
    readable_name: "have-watchdog",
    shortdesc: "Enable watchdog integration",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "join-finalization-timeout": {
    advanced: true,
    default: "30min",
    longdesc:
      "If you need to adjust this value, it probably indicates the presence of a bug",
    name: "join-finalization-timeout",
    readable_name: "join-finalization-timeout",
    shortdesc: "*** Advanced Use Only ***",
    source: "pacemaker-controld",
    type: "time",
  },
  "join-integration-timeout": {
    advanced: true,
    default: "3min",
    longdesc:
      "If need to adjust this value, it probably indicates the presence of a bug",
    name: "join-integration-timeout",
    readable_name: "join-integration-timeout",
    shortdesc: "*** Advanced Use Only ***",
    source: "pacemaker-controld",
    type: "time",
  },
  "load-threshold": {
    advanced: true,
    default: "80%",
    longdesc:
      "The cluster will slow down its recovery process when the amount of system resources used (currently CPU) approaches this limit",
    name: "load-threshold",
    readable_name: "load-threshold",
    shortdesc:
      "The maximum amount of system resources that should be used by nodes in the cluster",
    source: "pacemaker-controld",
    type: "percentage",
  },
  "maintenance-mode": {
    advanced: true,
    default: "false",
    longdesc: "",
    name: "maintenance-mode",
    readable_name: "maintenance-mode",
    shortdesc:
      "Should the cluster monitor resources and start/stop them as required",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "migration-limit": {
    advanced: true,
    default: "-1",
    longdesc: "",
    name: "migration-limit",
    readable_name: "migration-limit",
    shortdesc:
      "The number of migration jobs that the TE is allowed to execute in parallel on a node",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "no-quorum-policy": {
    advanced: false,
    default: "stop",
    enum: ["stop", "freeze", "ignore", "suicide"],
    longdesc: "",
    name: "no-quorum-policy",
    readable_name: "No Quorum Policy",
    shortdesc: "What to do when the cluster does not have quorum",
    source: "pacemaker-schedulerd",
    type: "enum",
  },
  "node-action-limit": {
    advanced: true,
    default: "0",
    longdesc: "",
    name: "node-action-limit",
    readable_name: "node-action-limit",
    shortdesc:
      "The maximum number of jobs that can be scheduled per node. Defaults to 2x cores",
    source: "pacemaker-controld",
    type: "integer",
  },
  "node-health-base": {
    advanced: true,
    default: "0",
    longdesc: "Only used when node-health-strategy is set to progressive.",
    name: "node-health-base",
    readable_name: "node-health-base",
    shortdesc: "The base score assigned to a node",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "node-health-green": {
    advanced: true,
    default: "0",
    longdesc:
      "Only used when node-health-strategy is set to custom or progressive.",
    name: "node-health-green",
    readable_name: "node-health-green",
    shortdesc: "The score 'green' translates to in rsc_location constraints",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "node-health-red": {
    advanced: true,
    default: "-INFINITY",
    longdesc:
      "Only used when node-health-strategy is set to custom or progressive.",
    name: "node-health-red",
    readable_name: "node-health-red",
    shortdesc: "The score 'red' translates to in rsc_location constraints",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "node-health-strategy": {
    advanced: true,
    default: "none",
    enum: ["none", "migrate-on-red", "only-green", "progressive", "custom"],
    longdesc:
      "Requires external entities to create node attributes (named with the prefix '#health') with values: 'red', 'yellow' or 'green'.",
    name: "node-health-strategy",
    readable_name: "node-health-strategy",
    shortdesc:
      "The strategy combining node attributes to determine overall node health.",
    source: "pacemaker-schedulerd",
    type: "enum",
  },
  "node-health-yellow": {
    advanced: true,
    default: "0",
    longdesc:
      "Only used when node-health-strategy is set to custom or progressive.",
    name: "node-health-yellow",
    readable_name: "node-health-yellow",
    shortdesc: "The score 'yellow' translates to in rsc_location constraints",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "pe-error-series-max": {
    advanced: false,
    default: "-1",
    longdesc: "Zero to disable, -1 to store unlimited",
    name: "pe-error-series-max",
    readable_name: "PE Error Storage",
    shortdesc: "The number of scheduler inputs resulting in ERRORs to save",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "pe-input-series-max": {
    advanced: false,
    default: "4000",
    longdesc: "Zero to disable, -1 to store unlimited",
    name: "pe-input-series-max",
    readable_name: "PE Input Storage",
    shortdesc: "The number of other scheduler inputs to save",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "pe-warn-series-max": {
    advanced: false,
    default: "5000",
    longdesc: "Zero to disable, -1 to store unlimited",
    name: "pe-warn-series-max",
    readable_name: "PE Warning Storage",
    shortdesc: "The number of scheduler inputs resulting in WARNINGs to save",
    source: "pacemaker-schedulerd",
    type: "integer",
  },
  "placement-strategy": {
    advanced: true,
    default: "default",
    enum: ["default", "utilization", "minimal", "balanced"],
    longdesc: "",
    name: "placement-strategy",
    readable_name: "placement-strategy",
    shortdesc: "The strategy to determine resource placement",
    source: "pacemaker-schedulerd",
    type: "enum",
  },
  "remove-after-stop": {
    advanced: true,
    default: "false",
    longdesc:
      "Always set this to false.  Other values are, at best, poorly tested and potentially dangerous.",
    name: "remove-after-stop",
    readable_name: "remove-after-stop",
    shortdesc: "Remove resources from the executor after they are stopped",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "shutdown-escalation": {
    advanced: true,
    default: "20min",
    longdesc:
      "If need to adjust this value, it probably indicates the presence of a bug.",
    name: "shutdown-escalation",
    readable_name: "shutdown-escalation",
    shortdesc: "*** Advanced Use Only ***.",
    source: "pacemaker-controld",
    type: "time",
  },
  "shutdown-lock": {
    advanced: true,
    default: "false",
    longdesc:
      'When true, resources active on a node when it is cleanly shut down are kept "locked" to that node (not allowed to run elsewhere) until they start again on that node after it rejoins (or for at most shutdown-lock-limit, if set). Stonith resources and Pacemaker Remote connections are never locked. Clone and bundle instances and the master role of promotable clones are currently never locked, though support could be added in a future release.',
    name: "shutdown-lock",
    readable_name: "shutdown-lock",
    shortdesc: "Whether to lock resources to a cleanly shut down node",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "shutdown-lock-limit": {
    advanced: true,
    default: "0",
    longdesc:
      "If shutdown-lock is true and this is set to a nonzero time duration, shutdown locks will expire after this much time has passed since the shutdown was initiated, even if the node has not rejoined.",
    name: "shutdown-lock-limit",
    readable_name: "shutdown-lock-limit",
    shortdesc:
      "Do not lock resources to a cleanly shut down node longer than this",
    source: "pacemaker-schedulerd",
    type: "time",
  },
  "start-failure-is-fatal": {
    advanced: false,
    default: "true",
    longdesc:
      "When set to TRUE, the cluster will immediately ban a resource from a node if it fails to start there. When FALSE, the cluster will instead check the resource's fail count against its migration-threshold.",
    name: "start-failure-is-fatal",
    readable_name: "Start Failure is Fatal",
    shortdesc: "Always treat start failures as fatal",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "startup-fencing": {
    advanced: true,
    default: "true",
    longdesc: "Advanced Use Only!  Not using the default is very unsafe!",
    name: "startup-fencing",
    readable_name: "startup-fencing",
    shortdesc: "STONITH unseen nodes",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "stonith-action": {
    advanced: false,
    default: "reboot",
    enum: ["reboot", "off", "poweroff"],
    longdesc: "",
    name: "stonith-action",
    readable_name: "Stonith Action",
    shortdesc:
      "Action to send to STONITH device ('poweroff' is a deprecated alias for 'off')",
    source: "pacemaker-schedulerd",
    type: "enum",
  },
  "stonith-enabled": {
    advanced: false,
    default: "true",
    longdesc: "",
    name: "stonith-enabled",
    readable_name: "Stonith Enabled",
    shortdesc: "Failed nodes are STONITH'd",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "stonith-max-attempts": {
    advanced: true,
    default: "10",
    longdesc: "",
    name: "stonith-max-attempts",
    readable_name: "stonith-max-attempts",
    shortdesc:
      "How many times stonith can fail before it will no longer be attempted on a target",
    source: "pacemaker-controld",
    type: "integer",
  },
  "stonith-timeout": {
    advanced: true,
    default: "60s",
    longdesc: "",
    name: "stonith-timeout",
    readable_name: "stonith-timeout",
    shortdesc:
      "How long to wait for the STONITH action (reboot,on,off) to complete",
    source: "pacemaker-schedulerd",
    type: "time",
  },
  "stonith-watchdog-timeout": {
    advanced: true,
    default: "(null)",
    longdesc: "",
    name: "stonith-watchdog-timeout",
    readable_name: "stonith-watchdog-timeout",
    shortdesc: "How long to wait before we can assume nodes are safely down",
    source: "pacemaker-controld",
    type: "time",
  },
  "stop-all-resources": {
    advanced: true,
    default: "false",
    longdesc: "",
    name: "stop-all-resources",
    readable_name: "stop-all-resources",
    shortdesc: "Should the cluster stop all active resources",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "stop-orphan-actions": {
    advanced: false,
    default: "true",
    longdesc: "",
    name: "stop-orphan-actions",
    readable_name: "Stop Orphan Actions",
    shortdesc: "Should deleted actions be cancelled",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "stop-orphan-resources": {
    advanced: false,
    default: "true",
    longdesc: "",
    name: "stop-orphan-resources",
    readable_name: "Stop Orphan Resources",
    shortdesc: "Should deleted resources be stopped",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "symmetric-cluster": {
    advanced: false,
    default: "true",
    longdesc: "",
    name: "symmetric-cluster",
    readable_name: "Symmetric",
    shortdesc: "All resources can run anywhere by default",
    source: "pacemaker-schedulerd",
    type: "boolean",
  },
  "transition-delay": {
    advanced: true,
    default: "0s",
    longdesc:
      "Delay cluster recovery for the configured interval to allow for additional/related events to occur.\nUseful if your configuration is sensitive to the order in which ping updates arrive.",
    name: "transition-delay",
    readable_name: "transition-delay",
    shortdesc:
      "*** Advanced Use Only *** Enabling this option will slow down cluster recovery under all conditions",
    source: "pacemaker-controld",
    type: "time",
  },
};
