documentation_complete: true

metadata:
    version: V1R4
    SMEs:
        - esampson

reference: 

title: 'Public Cloud Hardening for SUSE Linux Enterprise 15'

description: |-
    This profile contains configuration checks to be used to harden
    SUSE Linux Enterprise 15 for use with public cloud providers.


selections:
    - var_account_disable_post_pw_expiration=35
    - var_accounts_fail_delay=4
    - var_accounts_tmout=15_min
    - inactivity_timeout_value=15_minutes
    - var_password_pam_dcredit=1
    - var_password_pam_lcredit=1
    - var_password_pam_minlen=15
    - var_password_pam_ocredit=1
    - var_password_pam_ucredit=1
    - sshd_idle_timeout_value=15_minutes
    - var_sudo_timestamp_timeout=always_prompt
    - var_password_pam_unix_remember=5
    - var_accounts_maximum_age_login_defs=60
    - var_password_pam_delay=4000000
    #- login_banner_text=dod_banners
    - login_banner_text=cis_banners
    #
    # Note: must configure "var_accounts_authorized_local_users_regex" when
    # "accounts_authorized_local_users" rule is enabled
    # - var_accounts_authorized_local_users_regex=<authorized local user accounts>
    #
    # NOTE: must configure "var_audispd_remote_server" when
    # "auditd_audispd_configure_remote_server" rule is enabled
    #
    # - var_audispd_remote_server=<remote audit server name/IP>
    - var_removable_partition=dev_cdrom
    - var_sssd_memcache_timeout=1_day
    - var_time_service_set_maxpoll=18_hours
    - var_accounts_minimum_age_login_defs=7
    - var_accounts_max_concurrent_login_sessions=10
    - var_auditd_disk_full_action=syslog
    - sshd_idle_timeout_value=10_minutes
    - var_sshd_set_keepalive=0
    - var_sshd_max_sessions=10
    - var_auditd_admin_space_left_action=halt
    - var_auditd_max_log_file_action=keep_logs
    ## Remediate at image build time
    - account_disable_post_pw_expiration
    - accounts_have_homedir_login_defs
    - accounts_maximum_age_login_defs
    - accounts_minimum_age_login_defs
    - accounts_password_pam_pwhistory_remember
    - accounts_password_set_max_life_existing
    - accounts_password_set_min_life_existing
    - accounts_passwords_pam_faildelay_delay
    - accounts_passwords_pam_tally2
    - var_password_pam_tally2=5
    - accounts_tmout
    - accounts_umask_etc_login_defs
    - accounts_umask_etc_profile
    - aide_check_audit_tools
    - aide_periodic_checking_systemd_timer
    - aide_verify_acls
    - aide_verify_ext_attributes
    - banner_etc_issue
    - banner_etc_motd
    - cracklib_accounts_password_pam_dcredit
    - cracklib_accounts_password_pam_difok
    - cracklib_accounts_password_pam_lcredit
    - cracklib_accounts_password_pam_minlen
    - cracklib_accounts_password_pam_ocredit
    - cracklib_accounts_password_pam_retry
    - cracklib_accounts_password_pam_ucredit
    - disable_ctrlaltdel_burstaction
    - disable_users_coredumps
    - display_login_attempts
    - ensure_gpgcheck_globally_activated
    #- ensure_logrotate_activated
    - file_etc_security_opasswd
    - file_groupowner_etc_issue
    - file_groupownership_system_commands_dirs
    - file_owner_etc_issue
    - file_permissions_backup_etc_shadow
    - file_permissions_cron_d
    - file_permissions_cron_daily
    - file_permissions_cron_hourly
    - file_permissions_cron_monthly
    - file_permissions_cron_weekly
    - file_permissions_etc_shadow
    - file_permissions_home_directories
    - file_permissions_sshd_config
    - journald_compress
    - journald_storage
    - kernel_module_dccp_disabled
    - kernel_module_sctp_disabled
    - kernel_module_squashfs_disabled
    - kernel_module_udf_disabled
    - kernel_module_usb-storage_disabled
    - no_direct_root_logins
    #- pam_disable_automatic_configuration
    - set_password_hashing_algorithm_commonauth
    - set_password_hashing_algorithm_systemauth
    - smartcard_configure_ca
    - smartcard_configure_cert_checking
    - sshd_disable_root_login
    - sshd_disable_tcp_forwarding
    - sshd_disable_user_known_hosts
    - sshd_disable_x11_forwarding
    - sshd_enable_warning_banner
    - sshd_set_idle_timeout
    - sshd_set_keepalive_0
    - sshd_set_login_grace_time
    - sshd_set_loglevel_verbose
    - sshd_set_max_auth_tries
    - sshd_set_max_sessions
    - sshd_set_maxstartups
    - sshd_use_approved_ciphers
    - sshd_use_approved_ciphers_ordered_stig
    - sshd_use_approved_macs
    - sshd_use_approved_macs_ordered_stig
    - sudo_add_use_pty
    - sudo_custom_logfile
    - audit_rules_dac_modification_chmod
    - audit_rules_dac_modification_chown
    - audit_rules_dac_modification_fchmod
    - audit_rules_dac_modification_fchmodat
    - audit_rules_dac_modification_fchown
    - audit_rules_dac_modification_fchownat
    - audit_rules_dac_modification_fremovexattr
    - audit_rules_dac_modification_fsetxattr
    - audit_rules_dac_modification_lchown
    - audit_rules_dac_modification_lremovexattr
    - audit_rules_dac_modification_lsetxattr
    - audit_rules_dac_modification_removexattr
    - audit_rules_dac_modification_setxattr
    - audit_rules_dac_modification_umount
    - audit_rules_dac_modification_umount2
    - audit_rules_enable_syscall_auditing
    - audit_rules_execution_chacl
    - audit_rules_execution_chcon
    - audit_rules_execution_chmod
    - audit_rules_execution_rm
    - audit_rules_execution_setfacl
    - audit_rules_file_deletion_events_rename
    - audit_rules_file_deletion_events_renameat
    - audit_rules_file_deletion_events_unlink
    - audit_rules_file_deletion_events_unlinkat
    - audit_rules_immutable
    - audit_rules_kernel_module_loading_delete
    - audit_rules_kernel_module_loading_finit
    - audit_rules_kernel_module_loading_init
    - audit_rules_login_events_faillock
    - audit_rules_login_events_lastlog
    - audit_rules_login_events_tallylog
    - audit_rules_mac_modification
    - audit_rules_media_export
    - audit_rules_networkconfig_modification
    - audit_rules_privileged_commands_chage
    - audit_rules_privileged_commands_chfn
    - audit_rules_privileged_commands_chsh
    - audit_rules_privileged_commands_crontab
    - audit_rules_privileged_commands_gpasswd
    - audit_rules_privileged_commands_insmod
    - audit_rules_privileged_commands_kmod
    - audit_rules_privileged_commands_modprobe
    - audit_rules_privileged_commands_newgrp
    - audit_rules_privileged_commands_pam_timestamp_check
    - audit_rules_privileged_commands_passmass
    - audit_rules_privileged_commands_passwd
    - audit_rules_privileged_commands_rmmod
    - audit_rules_privileged_commands_ssh_agent
    - audit_rules_privileged_commands_ssh_keysign
    - audit_rules_privileged_commands_su
    - audit_rules_privileged_commands_sudo
    - audit_rules_privileged_commands_sudoedit
    - audit_rules_privileged_commands_unix2_chkpwd
    - audit_rules_privileged_commands_unix_chkpwd
    - audit_rules_privileged_commands_usermod
    - audit_rules_session_events
    - audit_rules_session_events_btmp
    - audit_rules_session_events_utmp
    - audit_rules_session_events_wtmp
    - audit_rules_suid_privilege_function
    - audit_rules_sysadmin_actions
    - audit_rules_time_adjtimex
    - audit_rules_time_clock_settime
    - audit_rules_time_settimeofday
    - audit_rules_time_stime
    - audit_rules_time_watch_localtime
    - audit_rules_unsuccessful_file_modification_creat
    - audit_rules_unsuccessful_file_modification_ftruncate
    - audit_rules_unsuccessful_file_modification_open
    - audit_rules_unsuccessful_file_modification_open_by_handle_at
    - audit_rules_unsuccessful_file_modification_openat
    - audit_rules_unsuccessful_file_modification_rename
    - audit_rules_unsuccessful_file_modification_renameat
    - audit_rules_unsuccessful_file_modification_renameat2
    - audit_rules_unsuccessful_file_modification_truncate
    - audit_rules_unsuccessful_file_modification_unlink
    - audit_rules_unsuccessful_file_modification_unlinkat
    - audit_rules_usergroup_modification_group
    - audit_rules_usergroup_modification_gshadow
    - audit_rules_usergroup_modification_opasswd
    - audit_rules_usergroup_modification_passwd
    - audit_rules_usergroup_modification_shadow
    - auditd_audispd_encrypt_sent_records
    - auditd_data_disk_full_action
    - auditd_data_retention_admin_space_left_action
    - auditd_data_retention_max_log_file_action
    - auditd_data_retention_space_left
    - auditd_data_retention_space_left_action
    - chronyd_run_as_chrony_user
    ####### DON'T DO THESE ################
    ## Passes out of box so no need to remediate
    #- accounts_no_uid_except_zero
    #- accounts_user_dot_no_world_writable_programs
    #- accounts_user_interactive_home_directory_exists
    #- file_cron_deny_not_exist
    #- file_groupowner_backup_etc_group
    #- file_groupowner_backup_etc_passwd
    #- file_groupowner_cron_allow
    #- file_groupowner_cron_d
    #- file_groupowner_cron_daily
    #- file_groupowner_cron_hourly
    #- file_groupowner_cron_monthly
    #- file_groupowner_cron_weekly
    #- file_groupowner_etc_group
    #- file_groupowner_etc_motd
    #- file_groupowner_etc_passwd
    #- file_groupowner_grub2_cfg
    #- file_groupowner_sshd_config
    #- file_owner_backup_etc_group
    #- file_owner_backup_etc_passwd
    #- file_owner_backup_etc_shadow
    #- file_owner_cron_allow
    #- file_owner_cron_d
    #- file_owner_cron_daily
    #- file_owner_cron_hourly
    #- file_owner_cron_monthly
    #- file_owner_cron_weekly
    #- file_owner_etc_group
    #- file_owner_etc_motd
    #- file_owner_etc_passwd
    #- file_owner_etc_shadow
    #- file_owner_grub2_cfg
    #- file_owner_sshd_config
    #- file_ownership_binary_dirs
    #- file_ownership_library_dirs
    #- file_permissions_backup_etc_group
    #- file_permissions_backup_etc_passwd
    #- file_permissions_binary_dirs
    #- file_permissions_cron_allow
    #- file_permissions_crontab
    #- file_permissions_etc_group
    #- file_permissions_etc_issue
    #- file_permissions_etc_motd
    #- file_permissions_etc_passwd
    #- file_permissions_grub2_cfg
    #- file_permissions_library_dirs
    #- file_permissions_sshd_private_key
    #- file_permissions_sshd_pub_key
    #- file_permissions_system_commands_dirs
    #- file_permissions_unauthorized_world_writable
    #- file_permissions_ungroupowned
    #- group_unique_name
    #- install_PAE_kernel_on_x86-32
    #- installed_OS_is_vendor_supported
    #- network_sniffer_disabled
    #- no_host_based_files
    #- no_netrc_files
    #- no_shelllogin_for_systemaccounts
    #- no_user_host_based_files
    #- package_bind_removed
    #- package_dovecot_removed
    #- package_httpd_removed
    #- package_openldap-clients_removed
    #- package_openldap-servers_removed
    #- package_rsh_removed
    #- package_samba_removed
    #- package_squid_removed
    #- package_sudo_installed
    #- package_talk_removed
    #- package_vsftpd_removed
    #- package_xinetd_removed
    #- package_ypbind_removed
    #- package_ypserv_removed
    #- root_path_no_dot
    #- account_unique_id
    #- securetty_root_login_console_only
    #- service_autofs_disabled
    #- service_avahi-daemon_disabled
    #- service_kdump_disabled
    #- service_rpcbind_disabled
    #- service_rsyncd_disabled
    #- service_sshd_enabled
    #- set_password_hashing_algorithm_logindefs
    #- set_password_hashing_min_rounds_logindefs
    #- smartcard_pam_enabled
    #- sshd_disable_compression
    #- sshd_disable_empty_passwords
    #- sshd_disable_rhosts
    #- sshd_do_not_permit_user_env
    #- sshd_enable_pam
    #- sshd_enable_strictmodes
    #- sshd_print_last_log
    #- sudo_restrict_privilege_elevation_to_authorized
    #- sysctl_kernel_kptr_restrict
    #- sysctl_net_ipv4_conf_all_accept_redirects
    #- sysctl_net_ipv4_conf_all_accept_source_route
    #- sysctl_net_ipv4_conf_default_accept_redirects
    #- sysctl_net_ipv4_conf_default_accept_source_route
    #- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
    #- sysctl_net_ipv6_conf_all_accept_redirects
    #- sysctl_net_ipv6_conf_default_accept_redirects
    #- vlock_installed
    #- wireless_disable_interfaces
    #- xwindows_remove_packages
    #- ensure_rtc_utc_configuration
    #- file_groupowner_backup_etc_shadow
    #- file_groupowner_crontab
    #- file_groupowner_etc_shadow
    #- file_owner_crontab
    #- root_permissions_syslibrary_files
    #- service_rsyslog_enabled
    #- auditd_data_retention_action_mail_acct
    #- auditd_data_retention_max_log_file
    #- chronyd_specify_remote_server
    #- service_auditd_enabled
    ## Packages installed at cloud image creation
    #- package_aide_installed
    #- package_audit-audispd-plugins_installed
    #- package_pam_apparmor_installed
    #- package_audit_installed
    #- package_chrony_installed
    #- package_firewalld_installed
    #- package_iptables_installed
    #- package_rsyslog_installed
    #- install_smartcard_packages
    ## notchecked out of box (don't try to remediate)
    #- account_emergency_admin
    #- account_temp_expire_date
    #- accounts_user_home_paths_only
    #- encrypt_partitions
    #- file_permission_user_init_files
    #- permissions_local_audit_binaries
    #- permissions_local_var_log_audit
    #- security_patches_up_to_date
    #- set_ip6tables_default_rule
    #- set_iptables_default_rule
    #- set_iptables_default_rule_forward
    #### Graphics (not included in cloud images)
    #- banner_etc_gdm_banner
    #- gui_login_dod_acknowledgement
    #- dconf_db_up_to_date
    #- dconf_gnome_banner_enabled
    #- dconf_gnome_login_banner_text
    #- dconf_gnome_screensaver_idle_delay
    #- dconf_gnome_screensaver_lock_enabled
    #- dconf_gnome_screensaver_mode_blank
    #- enable_dconf_user_profile
    #- gnome_gdm_disable_unattended_automatic_login
    #### requires passwords to be set; can't do at image build time.
    #- no_empty_passwords
    #- accounts_password_all_shadowed_sha512
    #- sudo_require_reauthentication
    #- sudo_require_authentication
    #- sudo_remove_no_authenticate
    #- sudo_remove_nopasswd
    #- use_pam_wheel_for_su
    #- grub2_uefi_password
    #- grub2_password
    #- require_singleuser_auth
    #### Partitions (cloud images are single partition)
    #- partition_for_home
    #- partition_for_tmp
    #- partition_for_var
    #- partition_for_var_log
    #- partition_for_var_log_audit
    #- partition_for_var_tmp
    #- mount_option_home_nodev
    #- mount_option_home_nosuid
    #- mount_option_tmp_nodev
    #- mount_option_tmp_noexec
    #- mount_option_tmp_nosuid
    #- mount_option_var_tmp_nodev
    #- mount_option_var_tmp_noexec
    #- mount_option_var_tmp_nosuid
    #### no fstab at image build time
    #- mount_option_dev_shm_noexec
    #- mount_option_dev_shm_nodev
    #- mount_option_dev_shm_nosuid
    #- mount_option_nodev_removable_partitions
    #- mount_option_noexec_removable_partitions
    #- mount_option_nosuid_removable_partitions
    #- mount_option_noexec_remote_filesystems
    #- mount_option_nosuid_remote_filesystems
    #### SSSD (no SSSD for cloud imaages)
    #- sssd_memcache_timeout
    #- sssd_offline_cred_expiration
    ### Don't remove packages
    #- package_dhcp_removed
    #- package_nfs-utils_removed
    #- package_net-snmp_removed
    #- package_telnet_removed
    #- package_telnet-server_removed
    #### OTHER 
    #### can't do at image build time
    #- accounts_authorized_local_users
    #- accounts_max_concurrent_login_sessions
    #- accounts_password_pam_unix_remember
    #- accounts_umask_etc_bashrc
    #- accounts_user_interactive_home_directory_defined
    #- aide_build_database
    #- apparmor_configured
    #- auditd_audispd_configure_sufficiently_large_partition
    #- auditd_audispd_disk_full_action
    #- auditd_audispd_network_failure_action
    #- chronyd_or_ntpd_set_maxpoll
    #- clean_components_post_updating
    #- coredump_disable_backtraces
    #- coredump_disable_storage
    #- disable_ctrlaltdel_reboot
    #- file_groupownership_home_directories
    #- file_permissions_local_var_log_messages
    #- gid_passwd_group_same
    #- grub2_audit_argument
    #- grub2_audit_backlog_limit_argument
    #- grub2_ipv6_disable_argument
    #- is_fips_mode_enabled
    #- kernel_module_vfat_disabled
    #- no_files_unowned_by_user
    #- permissions_local_var_log
    #- postfix_client_configure_mail_alias
    #- postfix_network_listening_disabled
    #- require_emergency_target_auth
    #- rpm_verify_ownership
    #- rpm_verify_permissions
    #- rsyslog_remote_loghost
    #- service_crond_enabled
    #- service_ip6tables_enabled
    #- service_iptables_enabled
    #- service_timesyncd_enabled
    #- set_firewalld_default_zone
    #- sshd_set_loglevel_info (was replaced by  sshd_set_loglevel_verbose)
    #- sudoers_validate_passwd
    #- sysctl_fs_suid_dumpable
    #- sysctl_kernel_randomize_va_space
    #- sysctl_net_ipv4_conf_all_log_martians
    #- sysctl_net_ipv4_conf_all_rp_filter
    #- sysctl_net_ipv4_conf_all_secure_redirects
    #- sysctl_net_ipv4_conf_all_send_redirects
    #- sysctl_net_ipv4_conf_default_log_martians
    #- sysctl_net_ipv4_conf_default_rp_filter
    #- sysctl_net_ipv4_conf_default_secure_redirects
    #- sysctl_net_ipv4_conf_default_send_redirects
    #- sysctl_net_ipv4_icmp_ignore_bogus_error_responses
    #- sysctl_net_ipv4_ip_forward
    #- sysctl_net_ipv4_tcp_syncookies
    #- sysctl_net_ipv6_conf_all_accept_ra
    #- sysctl_net_ipv6_conf_all_accept_source_route
    #- sysctl_net_ipv6_conf_all_forwarding
    #- sysctl_net_ipv6_conf_default_accept_ra
    #- sysctl_net_ipv6_conf_default_accept_source_route
    #- sysctl_net_ipv6_conf_default_forwarding
