; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- | FileCheck %s -check-prefix=X87
; RUN: llc < %s -mtriple=i686-- -mattr=-x87 | FileCheck %s -check-prefixes=NOX87,NOSSE-NOX87
; RUN: llc < %s -mtriple=i686-- -mattr=-x87,-sse2 | FileCheck %s -check-prefixes=NOX87,NOSSE-NOX87
; RUN: llc < %s -mtriple=i686-- -mattr=-x87,+sse2 | FileCheck %s -check-prefixes=NOX87,SSE-NOX87

define float @f1(float %a, float %b) nounwind {
; X87-LABEL: f1:
; X87:       # %bb.0: # %entry
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOSSE-NOX87-LABEL: f1:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f1:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    movd %xmm0, %eax
; SSE-NOX87-NEXT:    retl
entry:
  ret float %b
}

define double @f2(double %a, double %b) nounwind {
; X87-LABEL: f2:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldl {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOX87-LABEL: f2:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %edx
; NOX87-NEXT:    retl
entry:
  ret double %b
}

define x86_fp80 @f3(x86_fp80 %a, x86_fp80 %b) nounwind {
; X87-LABEL: f3:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOX87-LABEL: f3:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %edx
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; NOX87-NEXT:    retl
entry:
  ret x86_fp80 %b
}

define float @f4(float %a, float %b) nounwind {
; X87-LABEL: f4:
; X87:       # %bb.0: # %entry
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    fadds {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOSSE-NOX87-LABEL: f4:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    calll __addsf3
; NOSSE-NOX87-NEXT:    addl $8, %esp
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f4:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    addss {{[0-9]+}}(%esp), %xmm0
; SSE-NOX87-NEXT:    movd %xmm0, %eax
; SSE-NOX87-NEXT:    retl
entry:
  %0 = fadd float %a, %b
  ret float %0
}

define double @f5(double %a, double %b) nounwind {
; X87-LABEL: f5:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldl {{[0-9]+}}(%esp)
; X87-NEXT:    faddl {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOSSE-NOX87-LABEL: f5:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    calll __adddf3
; NOSSE-NOX87-NEXT:    addl $16, %esp
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f5:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    pushl %ebp
; SSE-NOX87-NEXT:    movl %esp, %ebp
; SSE-NOX87-NEXT:    andl $-8, %esp
; SSE-NOX87-NEXT:    subl $8, %esp
; SSE-NOX87-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NOX87-NEXT:    addsd 16(%ebp), %xmm0
; SSE-NOX87-NEXT:    movsd %xmm0, (%esp)
; SSE-NOX87-NEXT:    movl (%esp), %eax
; SSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE-NOX87-NEXT:    movl %ebp, %esp
; SSE-NOX87-NEXT:    popl %ebp
; SSE-NOX87-NEXT:    retl
entry:
  %0 = fadd double %a, %b
  ret double %0
}

; FIXME: We should not generate x87 instructions when x87 is disabled.
define x86_fp80 @f6(x86_fp80 %a, x86_fp80 %b) nounwind {
; X87-LABEL: f6:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-NEXT:    faddp %st, %st(1)
; X87-NEXT:    retl
;
; NOX87-LABEL: f6:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    pushl %ebp
; NOX87-NEXT:    movl %esp, %ebp
; NOX87-NEXT:    andl $-8, %esp
; NOX87-NEXT:    subl $48, %esp
; NOX87-NEXT:    movl 20(%ebp), %eax
; NOX87-NEXT:    movl 24(%ebp), %ecx
; NOX87-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; NOX87-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; NOX87-NEXT:    movl 28(%ebp), %eax
; NOX87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; NOX87-NEXT:    movl 8(%ebp), %eax
; NOX87-NEXT:    movl 12(%ebp), %ecx
; NOX87-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; NOX87-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; NOX87-NEXT:    movl 16(%ebp), %eax
; NOX87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; NOX87-NEXT:    fldt {{[0-9]+}}(%esp)
; NOX87-NEXT:    fldt {{[0-9]+}}(%esp)
; NOX87-NEXT:    faddp %st, %st(1)
; NOX87-NEXT:    fstpt (%esp)
; NOX87-NEXT:    movl (%esp), %eax
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %edx
; NOX87-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; NOX87-NEXT:    movl %ebp, %esp
; NOX87-NEXT:    popl %ebp
; NOX87-NEXT:    retl
entry:
  %0 = fadd x86_fp80 %a, %b
  ret x86_fp80 %0
}

define {float, float, float} @f7(float %a, float %b) nounwind {
; X87-LABEL: f7:
; X87:       # %bb.0: # %entry
; X87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    fstps 8(%eax)
; X87-NEXT:    fsts 4(%eax)
; X87-NEXT:    fstps (%eax)
; X87-NEXT:    retl $4
;
; NOSSE-NOX87-LABEL: f7:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; NOSSE-NOX87-NEXT:    movl %eax, %edx
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f7:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    movd %xmm0, %eax
; SSE-NOX87-NEXT:    movd %xmm0, %edx
; SSE-NOX87-NEXT:    movd %xmm1, %ecx
; SSE-NOX87-NEXT:    retl
entry:
  %0 = insertvalue {float, float, float} undef, float %a, 0
  %1 = insertvalue {float, float, float} %0, float %a, 1
  %2 = insertvalue {float, float, float} %1, float %b, 2
  ret {float, float, float} %2
}
