; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt < %s -S -early-cse -earlycse-debug-hash | FileCheck %s --check-prefixes=CHECK,NO_ASSUME
; RUN: opt < %s -S -early-cse --enable-knowledge-retention | FileCheck %s --check-prefixes=CHECK,USE_ASSUME
; RUN: opt < %s -S -passes=early-cse | FileCheck %s --check-prefixes=CHECK,NO_ASSUME

declare ptr @llvm.invariant.start.p0(i64, ptr nocapture) nounwind readonly
declare void @llvm.invariant.end.p0(ptr, i64, ptr nocapture) nounwind

; Check that we do load-load forwarding over invariant.start, since it does not
; clobber memory
define i8 @test_bypass1(ptr%P) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_bypass1
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i8, ptr [[P]], align 1
; NO_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; NO_ASSUME-NEXT:    ret i8 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_bypass1
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i8, ptr [[P]], align 1
; USE_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 1), "nonnull"(ptr [[P]]) ]
; USE_ASSUME-NEXT:    ret i8 0
;

  %V1 = load i8, ptr %P
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %P)
  %V2 = load i8, ptr %P
  %Diff = sub i8 %V1, %V2
  ret i8 %Diff
}


; Trivial Store->load forwarding over invariant.start
define i8 @test_bypass2(ptr%P) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_bypass2
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1
; NO_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; NO_ASSUME-NEXT:    ret i8 42
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_bypass2
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1
; USE_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 1), "nonnull"(ptr [[P]]) ]
; USE_ASSUME-NEXT:    ret i8 42
;

  store i8 42, ptr %P
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %P)
  %V1 = load i8, ptr %P
  ret i8 %V1
}

define i8 @test_bypass_store_load(ptr%P, ptr%P2) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_bypass_store_load
; NO_ASSUME-SAME: (ptr [[P:%.*]], ptr [[P2:%.*]])
; NO_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1
; NO_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; NO_ASSUME-NEXT:    store i8 0, ptr [[P2]], align 1
; NO_ASSUME-NEXT:    ret i8 42
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_bypass_store_load
; USE_ASSUME-SAME: (ptr [[P:%.*]], ptr [[P2:%.*]])
; USE_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1
; USE_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; USE_ASSUME-NEXT:    store i8 0, ptr [[P2]], align 1
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 1), "nonnull"(ptr [[P]]) ]
; USE_ASSUME-NEXT:    ret i8 42
;

  store i8 42, ptr %P
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %P)
  store i8 0, ptr %P2
  %V1 = load i8, ptr %P
  ret i8 %V1
}

define i8 @test_bypass_store_load_aatags_1(ptr%P, ptr%P2) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_bypass_store_load_aatags_1
; NO_ASSUME-SAME: (ptr [[P:%.*]], ptr [[P2:%.*]])
; NO_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1, !tbaa !0
; NO_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; NO_ASSUME-NEXT:    store i8 0, ptr [[P2]], align 1
; NO_ASSUME-NEXT:    ret i8 42
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_bypass_store_load_aatags_1
; USE_ASSUME-SAME: (ptr [[P:%.*]], ptr [[P2:%.*]])
; USE_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1, !tbaa !0
; USE_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; USE_ASSUME-NEXT:    store i8 0, ptr [[P2]], align 1
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 1), "nonnull"(ptr [[P]]) ]
; USE_ASSUME-NEXT:    ret i8 42
;

  store i8 42, ptr %P, !tbaa !0
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %P)
  store i8 0, ptr %P2
  %V1 = load i8, ptr %P
  ret i8 %V1
}

; The test demonstrates a missed optimization opportunity in case when the load
; has AA tags that are different from the store tags.
define i8 @test_bypass_store_load_aatags_2(ptr%P, ptr%P2) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_bypass_store_load_aatags_2
; NO_ASSUME-SAME: (ptr [[P:%.*]], ptr [[P2:%.*]])
; NO_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1
; NO_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; NO_ASSUME-NEXT:    store i8 0, ptr [[P2]], align 1
; NO_ASSUME-NEXT:    %V1 = load i8, ptr %P, align 1, !tbaa !0
; NO_ASSUME-NEXT:    ret i8 %V1
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_bypass_store_load_aatags_2
; USE_ASSUME-SAME: (ptr [[P:%.*]], ptr [[P2:%.*]])
; USE_ASSUME-NEXT:    store i8 42, ptr [[P]], align 1
; USE_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; USE_ASSUME-NEXT:    store i8 0, ptr [[P2]], align 1
; USE_ASSUME-NEXT:    %V1 = load i8, ptr %P, align 1, !tbaa !0
; USE_ASSUME-NEXT:    ret i8 %V1
;

  store i8 42, ptr %P
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %P)
  store i8 0, ptr %P2
  %V1 = load i8, ptr %P, !tbaa !0
  ret i8 %V1
}

; We can DSE over invariant.start calls, since the first store to
; %P is valid, and the second store is actually unreachable based on semantics
; of invariant.start.
define void @test_bypass3(ptr %P) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_bypass3
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; NO_ASSUME-NEXT:    store i8 60, ptr [[P]], align 1
; NO_ASSUME-NEXT:    ret void
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_bypass3
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 1), "nonnull"(ptr [[P]]) ]
; USE_ASSUME-NEXT:    store i8 60, ptr [[P]], align 1
; USE_ASSUME-NEXT:    ret void
;

  store i8 50, ptr %P
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %P)
  store i8 60, ptr %P
  ret void
}


; FIXME: Now the first store can actually be eliminated, since there is no read within
; the invariant region, between start and end.
define void @test_bypass4(ptr %P) {
; CHECK-LABEL: define {{[^@]+}}@test_bypass4
; CHECK-SAME: (ptr [[P:%.*]])
; CHECK-NEXT:    store i8 50, ptr [[P]], align 1
; CHECK-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[P]])
; CHECK-NEXT:    call void @llvm.invariant.end.p0(ptr [[I]], i64 1, ptr [[P]])
; CHECK-NEXT:    store i8 60, ptr [[P]], align 1
; CHECK-NEXT:    ret void
;


  store i8 50, ptr %P
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %P)
  call void @llvm.invariant.end.p0(ptr %i, i64 1, ptr %P)
  store i8 60, ptr %P
  ret void
}


declare void @clobber()

define i32 @test_before_load(ptr %p) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_before_load
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    ret i32 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_before_load
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret i32 0
;
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  %v1 = load i32, ptr %p
  call void @clobber()
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_before_clobber(ptr %p) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_before_clobber
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    ret i32 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_before_clobber
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret i32 0
;
  %v1 = load i32, ptr %p
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  call void @clobber()
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_duplicate_scope(ptr %p) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_duplicate_scope
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    [[TMP2:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    ret i32 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_duplicate_scope
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    [[TMP2:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret i32 0
;
  %v1 = load i32, ptr %p
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  call void @clobber()
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_unanalzyable_load(ptr %p) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_unanalzyable_load
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    ret i32 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_unanalzyable_load
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret i32 0
;
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  call void @clobber()
  %v1 = load i32, ptr %p
  call void @clobber()
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_negative_after_clobber(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@test_negative_after_clobber
; CHECK-SAME: (ptr [[P:%.*]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %v1 = load i32, ptr %p
  call void @clobber()
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_merge(ptr %p, i1 %cnd) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_merge
; NO_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    br i1 [[CND]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; NO_ASSUME:       taken:
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    br label [[MERGE]]
; NO_ASSUME:       merge:
; NO_ASSUME-NEXT:    ret i32 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_merge
; USE_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    br i1 [[CND]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; USE_ASSUME:       taken:
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    br label [[MERGE]]
; USE_ASSUME:       merge:
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret i32 0
;
  %v1 = load i32, ptr %p
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  br i1 %cnd, label %merge, label %taken

taken:
  call void @clobber()
  br label %merge
merge:
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_negative_after_mergeclobber(ptr %p, i1 %cnd) {
; CHECK-LABEL: define {{[^@]+}}@test_negative_after_mergeclobber
; CHECK-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    br i1 [[CND]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; CHECK:       taken:
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %v1 = load i32, ptr %p
  br i1 %cnd, label %merge, label %taken

taken:
  call void @clobber()
  br label %merge
merge:
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

; In theory, this version could work, but earlycse is incapable of
; merging facts along distinct paths.
define i32 @test_false_negative_merge(ptr %p, i1 %cnd) {
; CHECK-LABEL: define {{[^@]+}}@test_false_negative_merge
; CHECK-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    br i1 [[CND]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; CHECK:       taken:
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    br label [[MERGE]]
; CHECK:       merge:
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %v1 = load i32, ptr %p
  br i1 %cnd, label %merge, label %taken

taken:
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  call void @clobber()
  br label %merge
merge:
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_merge_unanalyzable_load(ptr %p, i1 %cnd) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_merge_unanalyzable_load
; NO_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    br i1 [[CND]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; NO_ASSUME:       taken:
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    br label [[MERGE]]
; NO_ASSUME:       merge:
; NO_ASSUME-NEXT:    ret i32 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_merge_unanalyzable_load
; USE_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    br i1 [[CND]], label [[MERGE:%.*]], label [[TAKEN:%.*]]
; USE_ASSUME:       taken:
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    br label [[MERGE]]
; USE_ASSUME:       merge:
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret i32 0
;
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  call void @clobber()
  %v1 = load i32, ptr %p
  br i1 %cnd, label %merge, label %taken

taken:
  call void @clobber()
  br label %merge
merge:
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define void @test_dse_before_load(ptr %p, i1 %cnd) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_dse_before_load
; NO_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    ret void
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_dse_before_load
; USE_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret void
;
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  %v1 = load i32, ptr %p
  call void @clobber()
  store i32 %v1, ptr %p
  ret void
}

define void @test_dse_after_load(ptr %p, i1 %cnd) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_dse_after_load
; NO_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; NO_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    ret void
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_dse_after_load
; USE_ASSUME-SAME: (ptr [[P:%.*]], i1 [[CND:%.*]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; USE_ASSUME-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret void
;
  %v1 = load i32, ptr %p
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  call void @clobber()
  store i32 %v1, ptr %p
  ret void
}


; In this case, we have a false negative since MemoryLocation is implicitly
; typed due to the user of a Value to represent the address.  Note that other
; passes will canonicalize away the bitcasts in this example.
define i32 @test_false_negative_types(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@test_false_negative_types
; CHECK-SAME: (ptr [[P:%.*]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[V2F:%.*]] = load float, ptr [[P]], align 4
; CHECK-NEXT:    [[V2:%.*]] = bitcast float [[V2F]] to i32
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  %v1 = load i32, ptr %p
  call void @clobber()
  %v2f = load float, ptr %p
  %v2 = bitcast float %v2f to i32
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_negative_size1(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@test_negative_size1
; CHECK-SAME: (ptr [[P:%.*]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 3, ptr [[P]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  call ptr @llvm.invariant.start.p0(i64 3, ptr %p)
  %v1 = load i32, ptr %p
  call void @clobber()
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_negative_size2(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@test_negative_size2
; CHECK-SAME: (ptr [[P:%.*]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.invariant.start.p0(i64 0, ptr [[P]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  call ptr @llvm.invariant.start.p0(i64 0, ptr %p)
  %v1 = load i32, ptr %p
  call void @clobber()
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_negative_scope(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@test_negative_scope
; CHECK-SAME: (ptr [[P:%.*]])
; CHECK-NEXT:    [[SCOPE:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; CHECK-NEXT:    call void @llvm.invariant.end.p0(ptr [[SCOPE]], i64 4, ptr [[P]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %scope = call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  call void @llvm.invariant.end.p0(ptr %scope, i64 4, ptr %p)
  %v1 = load i32, ptr %p
  call void @clobber()
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

define i32 @test_false_negative_scope(ptr %p) {
; CHECK-LABEL: define {{[^@]+}}@test_false_negative_scope
; CHECK-SAME: (ptr [[P:%.*]])
; CHECK-NEXT:    [[SCOPE:%.*]] = call ptr @llvm.invariant.start.p0(i64 4, ptr [[P]])
; CHECK-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[V2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    call void @llvm.invariant.end.p0(ptr [[SCOPE]], i64 4, ptr [[P]])
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[V1]], [[V2]]
; CHECK-NEXT:    ret i32 [[SUB]]
;
  %scope = call ptr @llvm.invariant.start.p0(i64 4, ptr %p)
  %v1 = load i32, ptr %p
  call void @clobber()
  %v2 = load i32, ptr %p
  call void @llvm.invariant.end.p0(ptr %scope, i64 4, ptr %p)
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

; Invariant load defact starts an invariant.start scope of the appropriate size
define i32 @test_invariant_load_scope(ptr %p) {
; NO_ASSUME-LABEL: define {{[^@]+}}@test_invariant_load_scope
; NO_ASSUME-SAME: (ptr [[P:%.*]])
; NO_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4, !invariant.load !4
; NO_ASSUME-NEXT:    call void @clobber()
; NO_ASSUME-NEXT:    ret i32 0
;
; USE_ASSUME-LABEL: define {{[^@]+}}@test_invariant_load_scope
; USE_ASSUME-SAME: (ptr [[P:%.*]])
; USE_ASSUME-NEXT:    [[V1:%.*]] = load i32, ptr [[P]], align 4, !invariant.load !4
; USE_ASSUME-NEXT:    call void @clobber()
; USE_ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "dereferenceable"(ptr [[P]], i64 4), "nonnull"(ptr [[P]]), "align"(ptr [[P]], i64 4) ]
; USE_ASSUME-NEXT:    ret i32 0
;
  %v1 = load i32, ptr %p, !invariant.load !{}
  call void @clobber()
  %v2 = load i32, ptr %p
  %sub = sub i32 %v1, %v2
  ret i32 %sub
}

; USE_ASSUME: declare void @llvm.assume(i1 noundef)

!0 = !{!1, !1, i64 0}
!1 = !{!"float", !2, i64 0}
!2 = !{!"omnipotent char", !3, i64 0}
!3 = !{!"Simple C/C++ TBAA"}
