; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mcpu=core2 | FileCheck %s

declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) nounwind
declare void @llvm.memset.inline.p0.i64(ptr nocapture, i8, i64, i1) nounwind

define void @test1(ptr %a, i8 %value) nounwind {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $esi killed $esi def $rsi
; CHECK-NEXT:    movzbl %sil, %eax
; CHECK-NEXT:    movabsq $72340172838076673, %rcx # imm = 0x101010101010101
; CHECK-NEXT:    imulq %rax, %rcx
; CHECK-NEXT:    movq %rcx, (%rdi)
; CHECK-NEXT:    retq
  tail call void @llvm.memset.inline.p0.i64(ptr %a, i8 %value, i64 8, i1 0)
  ret void
}

define void @regular_memset_calls_external_function(ptr %a, i8 %value) nounwind {
; CHECK-LABEL: regular_memset_calls_external_function:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl $1024, %edx # imm = 0x400
; CHECK-NEXT:    jmp memset@PLT # TAILCALL
  tail call void @llvm.memset.p0.i64(ptr %a, i8 %value, i64 1024, i1 0)
  ret void
}

define void @inlined_set_doesnt_call_external_function(ptr %a, i8 %value) nounwind {
; CHECK-LABEL: inlined_set_doesnt_call_external_function:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $esi killed $esi def $rsi
; CHECK-NEXT:    movzbl %sil, %ecx
; CHECK-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; CHECK-NEXT:    imulq %rcx, %rax
; CHECK-NEXT:    movq %rax, 1016(%rdi)
; CHECK-NEXT:    movq %rax, 1008(%rdi)
  tail call void @llvm.memset.inline.p0.i64(ptr %a, i8 %value, i64 1024, i1 0)
  ret void
}
