// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -show-encoding %s | FileCheck --check-prefix=GFX11 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -show-encoding %s 2>&1 | FileCheck --check-prefixes=GFX11-ERR --implicit-check-not=error: %s

buffer_load_dword v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0xff,0x02,0x03]

buffer_load_dword v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dword v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dword v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dword v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_dword v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dword v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dword v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dword v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dword v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x82,0x03]

buffer_load_dword v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x50,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dword v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x50,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 lds
// GFX11-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: invalid operand for instruction

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x82,0x03]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x54,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:7], off, s[8:11], s3 offset:4095 dlc tfe
// GFX11: encoding: [0xff,0x2f,0x54,0xe0,0x00,0x05,0x22,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x54,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[253:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx3 v[5:7], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx3 v[5:7], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx3 v[5:7], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx3 v[5:7], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x82,0x03]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x58,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x58,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[252:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx4 v[5:8], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx4 v[5:8], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx4 v[5:8], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx4 v[5:8], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x5c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x5c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0xff,0x02,0x03]

buffer_load_short_d16 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x03,0x03]

buffer_load_short_d16 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x18,0x03]

buffer_load_short_d16 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x65]

buffer_load_short_d16 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_short_d16 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0x80]

buffer_load_short_d16 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_short_d16 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_short_d16 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_short_d16 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x82,0x03]

buffer_load_short_d16 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x80,0xe0,0x00,0x05,0x42,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x80,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_d16_x v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_x v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_x v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_d16_x v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_x v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_x v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_x v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_x v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_d16_x v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_x v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_xy v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_xy v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_d16_xy v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_xy v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_xy v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_xy v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_xy v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_d16_xy v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xy v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_xyz v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_d16_xyz v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyz v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_xyzw v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_d16_xyzw v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_xyzw v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_short_d16_hi v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_short_d16_hi v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_short_d16_hi v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_short_d16_hi v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_short_d16_hi v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_short_d16_hi v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_short_d16_hi v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_short_d16_hi v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x8c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_short_d16_hi v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x8c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_d16_hi_x v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_d16_hi_x v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_format_d16_hi_x v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_d16_hi_x v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_d16_hi_x v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_d16_hi_x v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_d16_hi_x v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x82,0x03]

buffer_load_format_d16_hi_x v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x98,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_d16_hi_x v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x98,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sbyte_d16_hi v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sbyte_d16_hi v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_sbyte_d16_hi v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sbyte_d16_hi v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sbyte_d16_hi v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sbyte_d16_hi v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sbyte_d16_hi v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x82,0x03]

buffer_load_sbyte_d16_hi v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x88,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16_hi v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x88,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ubyte_d16_hi v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ubyte_d16_hi v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_ubyte_d16_hi v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ubyte_d16_hi v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ubyte_d16_hi v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ubyte_d16_hi v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ubyte_d16_hi v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x82,0x03]

buffer_load_ubyte_d16_hi v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x84,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16_hi v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x84,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sbyte_d16 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sbyte_d16 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_sbyte_d16 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sbyte_d16 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sbyte_d16 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sbyte_d16 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sbyte_d16 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_sbyte_d16 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte_d16 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x7c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ubyte_d16 v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ubyte_d16 v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_ubyte_d16 v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ubyte_d16 v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ubyte_d16 v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ubyte_d16 v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ubyte_d16 v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x82,0x03]

buffer_load_ubyte_d16 v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte_d16 v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x78,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sbyte v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sbyte v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sbyte v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sbyte v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_sbyte v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sbyte v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sbyte v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sbyte v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sbyte v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x82,0x03]

buffer_load_sbyte v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x44,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sshort v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sshort v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sshort v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sshort v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_sshort v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sshort v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sshort v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sshort v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sshort v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x82,0x03]

buffer_load_sshort v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x4c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sshort v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x4c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ubyte v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ubyte v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ubyte v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ubyte v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_ubyte v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ubyte v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ubyte v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ubyte v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ubyte v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x82,0x03]

buffer_load_ubyte v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ubyte v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x40,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ushort v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ushort v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ushort v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ushort v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x7d]

buffer_load_ushort v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ushort v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ushort v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ushort v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ushort v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x82,0x03]

buffer_load_ushort v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ushort v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 dlc
// GFX11: encoding: [0xff,0x2f,0x48,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX11: encoding: [0xff,0x7f,0x48,0xe0,0x00,0x05,0x02,0x03]


buffer_store_byte v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0xff,0x03,0x04]

buffer_store_byte v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x04,0x04]

buffer_store_byte v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x18,0x04]

buffer_store_byte v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x65]

buffer_store_byte v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_byte v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x80]

buffer_store_byte v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_byte v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_byte v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_byte v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x83,0x04]

buffer_store_byte v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x43,0x04]

buffer_store_byte v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0xff,0x03,0x04]

buffer_store_short v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x04,0x04]

buffer_store_short v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x18,0x04]

buffer_store_short v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x65]

buffer_store_short v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_short v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0x80]

buffer_store_short v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_short v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_short v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_short v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x83,0x04]

buffer_store_short v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x64,0xe0,0x00,0x01,0x43,0x04]

buffer_store_short v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x64,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0xff,0x03,0x04]

buffer_store_dword v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dword v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dword v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dword v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_dword v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dword v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dword v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dword v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dword v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x83,0x04]

buffer_store_dword v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dword v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[254:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx2 v[1:2], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx2 v[1:2], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx2 v[1:2], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx2 v[1:2], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x83,0x04]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x6c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x6c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[253:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx3 v[1:3], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx3 v[1:3], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx3 v[1:3], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx3 v[1:3], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x83,0x04]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[252:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx4 v[1:4], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx4 v[1:4], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx4 v[1:4], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx4 v[1:4], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x83,0x04]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_d16_x v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_x v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_x v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_d16_x v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_x v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_x v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_x v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_x v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_d16_x v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_x v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x30,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_xy v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_xy v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_d16_xy v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_xy v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_xy v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_xy v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_xy v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_d16_xy v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xy v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x34,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[254:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_xyz v[1:2], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_d16_xyz v[1:2], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyz v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x38,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[254:255], off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_xyzw v[1:2], v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_d16_xyzw v[1:2], v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_xyzw v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x3c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0xff,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x04,0x04]

buffer_store_byte_d16_hi v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x18,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x65]

buffer_store_byte_d16_hi v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_byte_d16_hi v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0x80]

buffer_store_byte_d16_hi v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_byte_d16_hi v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_byte_d16_hi v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_byte_d16_hi v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x83,0x04]

buffer_store_byte_d16_hi v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x90,0xe0,0x00,0x01,0x43,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte_d16_hi v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x90,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0xff,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x04,0x04]

buffer_store_short_d16_hi v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x18,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x65]

buffer_store_short_d16_hi v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_short_d16_hi v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0x80]

buffer_store_short_d16_hi v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_short_d16_hi v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_short_d16_hi v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_short_d16_hi v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x83,0x04]

buffer_store_short_d16_hi v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x94,0xe0,0x00,0x01,0x43,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short_d16_hi v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x94,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v255, off, s[12:15], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[16:19], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_d16_hi_x v1, off, s[96:99], s4 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s101 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_d16_hi_x v1, off, s[12:15], m0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x7d]

buffer_store_format_d16_hi_x v1, off, s[12:15], 0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_d16_hi_x v1, off, s[12:15], -1 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_d16_hi_x v1, off, s[12:15], 0.5 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_d16_hi_x v1, off, s[12:15], -4.0 offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_d16_hi_x v1, v0, s[12:15], s4 idxen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x83,0x04]

buffer_store_format_d16_hi_x v1, v0, s[12:15], s4 offen offset:4095
//  GFX11: encoding: [0xff,0x0f,0x9c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4
//  GFX11: encoding: [0x00,0x00,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:0
//  GFX11: encoding: [0x00,0x00,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:7
//  GFX11: encoding: [0x07,0x00,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:4095 glc
//  GFX11: encoding: [0xff,0x4f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:4095 slc
//  GFX11: encoding: [0xff,0x1f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:4095 dlc
//  GFX11: encoding: [0xff,0x2f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_d16_hi_x v1, off, s[12:15], s4 offset:4095 glc slc dlc
//  GFX11: encoding: [0xff,0x7f,0x9c,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_add v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_add v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_add v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_add v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_add v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_add v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_add v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_add v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_add v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_add v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_add v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_add_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_add_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_add_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_add_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_add_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_add_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x0c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x0c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_and v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_and v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_and v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_and v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_and v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_and v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_and v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_and v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_and v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_and v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_and v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_and_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_and_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_and_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_and_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_and_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_and_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x24,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x24,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0xfe,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_cmpswap v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_cmpswap v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xd0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[252:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0xfc,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x08,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x08,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fcmpswap v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_fcmpswap v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_fcmpswap v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fcmpswap v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_csub v5, off, s[8:11], s3 offset:4095
// GFX11-ERR: :[[@LINE-1]]:{{[0-9]+}}: error: instruction must use glc

buffer_atomic_csub v255, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_csub v5, off, s[12:15], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_csub v5, off, s[96:99], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_csub v5, off, s[8:11], s101 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_csub v5, off, s[8:11], m0 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_csub v5, off, s[8:11], 0 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_csub v5, off, s[8:11], -1 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_csub v5, off, s[8:11], 0.5 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_csub v5, off, s[8:11], -4.0 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_csub v5, v0, s[8:11], s3 idxen offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_csub v5, v0, s[8:11], s3 offen offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_csub v5, off, s[8:11], s3 glc
// GFX11: encoding: [0x00,0x40,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub v5, off, s[8:11], s3 offset:0 glc
// GFX11: encoding: [0x00,0x40,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub v5, off, s[8:11], s3 offset:7 glc
// GFX11: encoding: [0x07,0x40,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_csub v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_dec v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_dec v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_dec v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_dec v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_dec v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x00,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_dec v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x00,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x34,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x34,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_inc v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_inc v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_inc v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_inc v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_inc v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_inc v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_inc v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_inc v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_inc v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_inc v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xfc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_inc v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xfc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x30,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x30,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmax v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_fmax v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_fmax v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_fmax v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_fmax v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_fmax v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_fmax v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_fmax v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_fmax v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_fmax v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_fmax v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_fmax v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmax v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_smax v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_smax v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_smax v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_smax v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_smax v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_smax v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_smax v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_smax v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_smax v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_smax v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_smax v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x1c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x1c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_umax v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_umax v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_umax v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_umax v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_umax v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_umax v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_umax v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_umax v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_umax v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_umax v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_umax v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x20,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x20,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmin v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0xff,0x02,0x03]

buffer_atomic_fmin v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_fmin v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_fmin v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_fmin v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_fmin v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_fmin v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_fmin v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_fmin v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_fmin v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_fmin v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_fmin v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_fmin v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_smin v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_smin v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_smin v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_smin v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_smin v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_smin v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_smin v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_smin v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_smin v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_smin v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_smin v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x14,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x14,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_umin v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_umin v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_umin v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_umin v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_umin v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_umin v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_umin v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_umin v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_umin v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_umin v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_umin v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x18,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x18,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_or v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_or v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_or v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_or v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_or v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_or v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_or v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_or v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_or v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_or v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_or v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_or_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_or_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_or_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_or_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_or_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_or_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x28,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x28,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_sub v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_sub v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_sub v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_sub v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_sub v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_sub v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_sub v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_sub v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_sub v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_sub v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_sub v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x10,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x10,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_swap v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_swap v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_swap v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_swap v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_swap v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_swap v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_swap v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_swap v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_swap v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_swap v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_swap v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x04,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x04,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v255, off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_xor v5, off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_xor v5, off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_xor v5, off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_xor v5, off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x7d]

buffer_atomic_xor v5, off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_xor v5, off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_xor v5, off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0xf0]

buffer_atomic_xor v5, off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x02,0xf7]

buffer_atomic_xor v5, v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x82,0x03]

buffer_atomic_xor v5, v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0xf8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_xor v5, off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0xf8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x7d]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xf0]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x02,0xf7]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x82,0x03]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX11: encoding: [0xff,0x0f,0x2c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3
// GFX11: encoding: [0x00,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:0
// GFX11: encoding: [0x00,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX11: encoding: [0x07,0x00,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX11: encoding: [0xff,0x4f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX11: encoding: [0xff,0x1f,0x2c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 glc slc
// GFX11: encoding: [0xff,0x5f,0x2c,0xe1,0x00,0x05,0x02,0x03]
