/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.util.Collection;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPFilter;
import netscape.ldap.client.JDAPFilterOpers;

public class JDAPFilterSubString
extends JDAPFilter {
    private String m_type = null;
    private Vector<String> m_initial = new Vector();
    private Vector<String> m_any = new Vector();
    private Vector<String> m_final = new Vector();

    public JDAPFilterSubString(String type) {
        this.m_type = type;
    }

    public String getType() {
        return this.m_type;
    }

    public String getInitialSubstring() {
        return this.m_initial.isEmpty() ? null : this.m_initial.get(0);
    }

    public void addInitial(String s) {
        this.m_initial.addElement(s);
    }

    public Collection<String> getAnySubstrings() {
        return this.m_any;
    }

    public void addAny(String s) {
        this.m_any.addElement(s);
    }

    public String getFinalSubstring() {
        return this.m_final.isEmpty() ? null : this.m_final.get(0);
    }

    public void addFinal(String s) {
        this.m_final.addElement(s);
    }

    @Override
    public BERElement getBERElement() {
        BERTag str;
        String val;
        int i;
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_type));
        BERSequence str_seq = new BERSequence();
        for (i = 0; i < this.m_initial.size(); ++i) {
            val = this.m_initial.elementAt(i);
            if (val == null) continue;
            str = new BERTag(128, JDAPFilterOpers.getOctetString(val), true);
            str_seq.addElement(str);
        }
        for (i = 0; i < this.m_any.size(); ++i) {
            val = this.m_any.elementAt(i);
            if (val == null) continue;
            str = new BERTag(129, JDAPFilterOpers.getOctetString(val), true);
            str_seq.addElement(str);
        }
        for (i = 0; i < this.m_final.size(); ++i) {
            val = this.m_final.elementAt(i);
            if (val == null) continue;
            str = new BERTag(130, JDAPFilterOpers.getOctetString(val), true);
            str_seq.addElement(str);
        }
        seq.addElement(str_seq);
        BERTag element = new BERTag(164, seq, true);
        return element;
    }

    @Override
    public String toString() {
        Object initial = "";
        for (int i = 0; i < this.m_initial.size(); ++i) {
            if (i != 0) {
                initial = (String)initial + ",";
            }
            initial = (String)initial + this.m_initial.elementAt(i);
        }
        Object any = "";
        for (int i = 0; i < this.m_any.size(); ++i) {
            if (i != 0) {
                any = (String)any + ",";
            }
            any = (String)any + this.m_any.elementAt(i);
        }
        Object s_final = "";
        for (int i = 0; i < this.m_final.size(); ++i) {
            if (i != 0) {
                s_final = (String)s_final + ",";
            }
            s_final = (String)s_final + this.m_final.elementAt(i);
        }
        return "JDAPFilterSubString {type=" + this.m_type + ", initial=" + (String)initial + ", any=" + (String)any + ", final=" + (String)s_final + "}";
    }
}

