/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAsynchronousConnection;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSSLSocketFactoryExt;
import netscape.ldap.LDAPSaslBind;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPTLSSocketFactory;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.LDAPUrl;
import netscape.ldap.LDAPv3;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.opers.JDAPAddRequest;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPCompareRequest;
import netscape.ldap.client.opers.JDAPDeleteRequest;
import netscape.ldap.client.opers.JDAPExtendedRequest;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNRequest;
import netscape.ldap.client.opers.JDAPModifyRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchRequest;
import netscape.ldap.client.opers.JDAPSearchResultReference;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class LDAPConnection
implements LDAPv3,
LDAPAsynchronousConnection,
Cloneable,
Serializable {
    static final long serialVersionUID = -8698420087475771145L;
    public static final int LDAP_VERSION = 2;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    public static final String TRACE_PROPERTY = "com.netscape.ldap.trace";
    public static final int NODELAY_SERIAL = -1;
    public static final int NODELAY_PARALLEL = 0;
    private static final String defaultFilter = "(objectClass=*)";
    private LDAPSearchConstraints m_defaultConstraints = new LDAPSearchConstraints();
    private LDAPConstraints m_rebindConstraints;
    private Vector<LDAPResponseListener> m_responseListeners;
    private Vector<LDAPSearchListener> m_searchListeners;
    private String m_boundDN;
    private String m_boundPasswd;
    private int m_protocolVersion = 2;
    private LDAPConnSetupMgr m_connMgr;
    private int m_connSetupDelay = -1;
    private int m_connectTimeout = 0;
    private LDAPSocketFactory m_factory = null;
    private boolean m_isTLSFactory;
    private transient LDAPConnThread m_thread = null;
    private Hashtable<Thread, ResponseControls> m_responseControlTable = new Hashtable();
    private LDAPCache m_cache = null;
    private boolean m_useTLS;
    static final String OID_startTLS = "1.3.6.1.4.1.1466.20037";
    private Object m_security = null;
    private LDAPSaslBind m_saslBinder = null;
    private Properties m_securityProperties;
    private Hashtable<String, Object> m_properties = new Hashtable();
    private LDAPConnection m_referralConnection;
    private static final Float SdkVersion = Float.valueOf(4.18f);
    private static final Float ProtocolVersion = Float.valueOf(3.0f);
    private static final String SecurityVersion = new String("none,simple,sasl");
    private static final Float MajorVersion = Float.valueOf(4.0f);
    private static final Float MinorVersion = Float.valueOf(0.18f);
    private static final String DELIM = "#";
    private static final String PersistSearchPackageName = "netscape.ldap.controls.LDAPPersistSearchControl";
    static final String EXTERNAL_MECHANISM = "external";
    private static final String EXTERNAL_MECHANISM_PACKAGE = "com.netscape.sasl";
    static final String DEFAULT_SASL_PACKAGE = "com.netscape.sasl";
    static final String SCHEMA_BUG_PROPERTY = "com.netscape.ldap.schema.quoting";
    static final String SASL_PACKAGE_PROPERTY = "com.netscape.ldap.saslpackage";
    public static final int MAXBACKLOG = 30;
    private static boolean isCommunicator = LDAPConnection.checkCommunicator();
    private static boolean debug = false;

    public LDAPConnection() {
        this.m_properties.put(LDAP_PROPERTY_SDK, SdkVersion);
        this.m_properties.put(LDAP_PROPERTY_PROTOCOL, ProtocolVersion);
        this.m_properties.put(LDAP_PROPERTY_SECURITY, SecurityVersion);
        this.m_properties.put("version.major", MajorVersion);
        this.m_properties.put("version.minor", MinorVersion);
    }

    public LDAPConnection(LDAPSocketFactory factory) {
        this();
        this.m_factory = factory;
    }

    public void finalize() throws LDAPException {
        if (this.isConnected()) {
            this.disconnect();
        }
    }

    public void setCache(LDAPCache cache) {
        if (this.m_cache != null) {
            this.m_cache.removeReference();
        }
        if (cache != null) {
            cache.addReference();
        }
        this.m_cache = cache;
        if (this.m_thread != null) {
            this.m_thread.setCache(cache);
        }
    }

    public LDAPCache getCache() {
        return this.m_cache;
    }

    public Object getProperty(String name) throws LDAPException {
        return this.m_properties.get(name);
    }

    public void setProperty(String name, Object val) throws LDAPException {
        if (name.equalsIgnoreCase(SCHEMA_BUG_PROPERTY)) {
            this.m_properties.put(SCHEMA_BUG_PROPERTY, val);
        } else if (name.equalsIgnoreCase(SASL_PACKAGE_PROPERTY)) {
            this.m_properties.put(SASL_PACKAGE_PROPERTY, val);
        } else if (name.equalsIgnoreCase("debug")) {
            debug = ((String)val).equalsIgnoreCase("true");
        } else if (name.equalsIgnoreCase(TRACE_PROPERTY)) {
            Object traceOutput = null;
            if (val == null) {
                this.m_properties.remove(TRACE_PROPERTY);
            } else {
                if (this.m_thread != null) {
                    traceOutput = this.createTraceOutput(val);
                }
                this.m_properties.put(TRACE_PROPERTY, val);
            }
            if (this.m_thread != null) {
                this.m_thread.setTraceOutput(traceOutput);
            }
        } else if (name.equalsIgnoreCase("breakConnection")) {
            this.m_connMgr.breakConnection();
        } else {
            throw new LDAPException("Unknown property: " + name);
        }
    }

    Object createTraceOutput(Object out) throws LDAPException {
        if (out instanceof String) {
            FilterOutputStream os = null;
            String file = (String)out;
            if (file.length() == 0) {
                os = System.err;
            } else {
                try {
                    boolean appendMode;
                    boolean bl = appendMode = file.charAt(0) == '+';
                    if (appendMode) {
                        file = file.substring(1);
                    }
                    FileOutputStream fos = new FileOutputStream(file, appendMode);
                    os = new BufferedOutputStream(fos);
                }
                catch (IOException e) {
                    throw new LDAPException("Can not open output trace file " + file + " " + e);
                }
            }
            return os;
        }
        if (out instanceof OutputStream) {
            return out;
        }
        if (out instanceof LDAPTraceWriter) {
            return out;
        }
        throw new LDAPException("com.netscape.ldap.trace must be an OutputStream, a file name or an instance of LDAPTraceWriter");
    }

    private void setProtocolVersion(int version) {
        this.m_protocolVersion = version;
    }

    public String getHost() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getHost();
        }
        return null;
    }

    public int getPort() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getPort();
        }
        return -1;
    }

    public String getAuthenticationDN() {
        return this.m_boundDN;
    }

    public String getAuthenticationPassword() {
        return this.m_boundPasswd;
    }

    public int getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout value can not be negative");
        }
        this.m_connectTimeout = timeout;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        }
    }

    public int getConnSetupDelay() {
        return this.m_connSetupDelay;
    }

    public void setConnSetupDelay(int delay) {
        this.m_connSetupDelay = delay;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnSetupDelay(delay);
        }
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.m_factory;
    }

    public void setSocketFactory(LDAPSocketFactory factory) {
        this.m_factory = factory;
        this.m_isTLSFactory = false;
    }

    public synchronized boolean isConnected() {
        return this.m_thread != null && this.m_thread.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        boolean bound = false;
        LDAPConnection lDAPConnection = this;
        synchronized (lDAPConnection) {
            bound = this.m_thread != null && this.m_thread.isBound();
        }
        return bound;
    }

    synchronized void setBound(boolean bound) {
        if (this.m_thread != null) {
            if (!bound) {
                this.m_thread.setBound(false);
            } else if (this.m_saslBinder != null) {
                this.m_thread.setBound(true);
            } else {
                this.m_thread.setBound(!this.isAnonymousUser());
            }
        }
    }

    boolean isAnonymousUser() {
        return this.m_boundDN == null || this.m_boundDN.equals("") || this.m_boundPasswd == null || this.m_boundPasswd.equals("");
    }

    @Override
    public void connect(String host, int port) throws LDAPException {
        this.connect(host, port, null, null, this.m_defaultConstraints, false);
    }

    @Override
    public void connect(String host, int port, String dn, String passwd) throws LDAPException {
        this.connect(host, port, dn, passwd, this.m_defaultConstraints, true);
    }

    public void connect(String host, int port, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.connect(host, port, dn, passwd, cons, true);
    }

    @Deprecated
    public void connect(String host, int port, String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.connect(host, port, dn, passwd, (LDAPConstraints)cons);
    }

    private void connect(String host, int port, String dn, String passwd, LDAPConstraints cons, boolean doAuthenticate) throws LDAPException {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (host == null || host.equals("")) {
            throw new LDAPException("no host for connection", 89);
        }
        int defaultPort = port;
        StringTokenizer st = new StringTokenizer(host);
        String[] hostList = new String[st.countTokens()];
        int[] portList = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("[")) {
                int end = s.indexOf(93);
                if (end == -1) {
                    throw new LDAPException("invalid URL for IPv6 address", 89);
                }
                String remainder = s.substring(end + 1);
                hostList[i] = s.substring(0, end + 1);
                colon = remainder.indexOf(58);
                portList[i] = colon >= 0 ? Integer.parseInt(remainder.substring(colon + 1)) : defaultPort;
            } else {
                colon = s.indexOf(58);
                if (colon > 0) {
                    hostList[i] = s.substring(0, colon);
                    portList[i] = Integer.parseInt(s.substring(colon + 1));
                } else {
                    hostList[i] = s;
                    portList[i] = defaultPort;
                }
            }
            ++i;
        }
        this.m_connMgr = new LDAPConnSetupMgr(hostList, portList, this.m_isTLSFactory ? null : this.m_factory);
        this.m_connMgr.setConnSetupDelay(this.m_connSetupDelay);
        this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        this.connect();
        if (doAuthenticate) {
            this.authenticate(dn, passwd, cons);
        }
    }

    void connect(LDAPUrl[] urls) throws LDAPException {
        this.m_connMgr = new LDAPConnSetupMgr(urls, this.m_factory);
        this.m_connMgr.setConnSetupDelay(this.m_connSetupDelay);
        this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        this.connect();
    }

    @Override
    public void connect(int version, String host, int port, String dn, String passwd) throws LDAPException {
        this.connect(version, host, port, dn, passwd, this.m_defaultConstraints);
    }

    public void connect(int version, String host, int port, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.setProtocolVersion(version);
        this.connect(host, port, dn, passwd, cons);
    }

    @Deprecated
    public void connect(int version, String host, int port, String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.connect(version, host, port, dn, passwd, (LDAPConstraints)cons);
    }

    private synchronized void connect() throws LDAPException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connMgr == null) {
            throw new LDAPException("no connection parameters", 89);
        }
        if (this.m_thread == null) {
            this.m_thread = new LDAPConnThread(this.m_connMgr, this.m_cache, this.getTraceOutput());
        }
        this.m_thread.connect(this);
        this.checkClientAuth();
    }

    Object getTraceOutput() throws LDAPException {
        Object traceOut = this.m_properties.get(TRACE_PROPERTY);
        if (traceOut != null) {
            return this.createTraceOutput(traceOut);
        }
        try {
            traceOut = System.getProperty(TRACE_PROPERTY);
            if (traceOut != null) {
                return this.createTraceOutput(traceOut);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void checkClientAuth() throws LDAPException {
        if (this.m_factory != null && this.m_factory instanceof LDAPSSLSocketFactoryExt && ((LDAPSSLSocketFactoryExt)this.m_factory).isClientAuth()) {
            this.authenticate(null, EXTERNAL_MECHANISM, "com.netscape.sasl", null, null);
        }
    }

    @Override
    public void abandon(LDAPSearchResults searchResults) throws LDAPException {
        if (!this.isConnected() || searchResults == null) {
            return;
        }
        int id = searchResults.getMessageID();
        if (id != -1) {
            this.abandon(id);
        }
    }

    @Override
    public void authenticate(String dn, String passwd) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, this.m_defaultConstraints);
    }

    public void authenticate(String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, cons);
    }

    @Deprecated
    public void authenticate(String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.authenticate(dn, passwd, (LDAPConstraints)cons);
    }

    @Override
    public void authenticate(int version, String dn, String passwd) throws LDAPException {
        this.authenticate(version, dn, passwd, this.m_defaultConstraints);
    }

    public void authenticate(int version, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.m_protocolVersion = version;
        this.m_boundDN = dn;
        this.m_boundPasswd = passwd;
        this.forceNonSharedConnection();
        this.simpleBind(cons);
    }

    @Deprecated
    public void authenticate(int version, String dn, String passwd, LDAPSearchConstraints cons) throws LDAPException {
        this.authenticate(version, dn, passwd, (LDAPConstraints)cons);
    }

    public void authenticate(String dn, Hashtable<Object, Object> props, Object cbh) throws LDAPException {
        String[] attrs = new String[]{"supportedSaslMechanisms"};
        LDAPEntry entry = this.read("", attrs);
        LDAPAttribute attr = entry.getAttribute(attrs[0]);
        if (attr == null) {
            throw new LDAPException("Not found in root DSE: " + attrs[0], 16);
        }
        this.authenticate(dn, attr.getStringValueArray(), props, cbh);
    }

    public void authenticate(String dn, String[] mechanisms, Hashtable<Object, Object> props, Object cbh) throws LDAPException {
        this.authenticate(dn, mechanisms, "com.netscape.sasl", props, cbh);
    }

    @Deprecated
    public void authenticate(String dn, String mechanism, String packageName, Hashtable<Object, Object> props, Object cbh) throws LDAPException {
        this.authenticate(dn, new String[]{mechanism}, packageName, props, cbh);
    }

    @Deprecated
    public void authenticate(String dn, String[] mechanisms, String packageName, Hashtable<Object, Object> props, Object cbh) throws LDAPException {
        this.forceNonSharedConnection();
        this.m_boundDN = null;
        this.m_protocolVersion = 3;
        if (props == null) {
            props = new Hashtable();
        }
        this.m_saslBinder = new LDAPSaslBind(dn, mechanisms, packageName, props, cbh);
        this.m_saslBinder.bind(this);
        this.m_boundDN = dn;
    }

    public LDAPResponseListener authenticate(int version, String dn, String passwd, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.m_boundDN = dn;
        this.m_boundPasswd = passwd;
        this.m_protocolVersion = version;
        this.forceNonSharedConnection();
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPBindRequest(version, this.m_boundDN, this.m_boundPasswd), listener, cons);
        return listener;
    }

    public LDAPResponseListener authenticate(int version, String dn, String passwd, LDAPResponseListener listener) throws LDAPException {
        return this.authenticate(version, dn, passwd, listener, this.m_defaultConstraints);
    }

    @Override
    public void bind(String dn, String passwd) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, this.m_defaultConstraints);
    }

    public void bind(String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.authenticate(this.m_protocolVersion, dn, passwd, cons);
    }

    @Override
    public void bind(int version, String dn, String passwd) throws LDAPException {
        this.authenticate(version, dn, passwd, this.m_defaultConstraints);
    }

    public void bind(int version, String dn, String passwd, LDAPConstraints cons) throws LDAPException {
        this.authenticate(version, dn, passwd, cons);
    }

    public void bind(String dn, Hashtable<Object, Object> props, Object cbh) throws LDAPException {
        this.authenticate(dn, props, cbh);
    }

    public void bind(String dn, String[] mechanisms, Hashtable<Object, Object> props, Object cbh) throws LDAPException {
        this.authenticate(dn, mechanisms, props, cbh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTLS() throws LDAPException {
        if (this.m_useTLS) {
            throw new LDAPException("Already using TLS", 80);
        }
        if (this.m_factory == null || !(this.m_factory instanceof LDAPTLSSocketFactory)) {
            throw new LDAPException("No socket factory for the startTLS operation", 80);
        }
        this.m_isTLSFactory = true;
        this.checkConnection(true);
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.isConnected() && this.m_thread.getRequestCount() != 0) {
                throw new LDAPException("Connection has outstanding LDAP operations", 80);
            }
        }
        try {
            serializable = this.extendedOperation(new LDAPExtendedOperation(OID_startTLS, null), this.m_defaultConstraints);
        }
        catch (LDAPException ex) {
            ex.setExtraMessage("Cannot start TLS");
            throw ex;
        }
        try {
            this.m_thread.layerSocket((LDAPTLSSocketFactory)this.m_factory);
            this.m_useTLS = true;
        }
        catch (LDAPException ex) {
            ex.setExtraMessage("Failed to start TLS");
            throw ex;
        }
        catch (Exception ex) {
            throw new LDAPException("Failed to start TLS", 80);
        }
    }

    public boolean isTLS() {
        return this.m_useTLS;
    }

    void forceNonSharedConnection() throws LDAPException {
        this.checkConnection(false);
        if (this.m_thread != null && this.m_thread.getClientCount() > 1) {
            this.reconnect(false);
        }
    }

    private void simpleBind(LDAPConstraints cons) throws LDAPException {
        this.m_saslBinder = null;
        LDAPResponseListener myListener = new LDAPResponseListener(false);
        try {
            if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
                this.m_referralConnection.disconnect();
            }
            this.m_referralConnection = null;
            this.setBound(false);
            this.sendRequest(new JDAPBindRequest(this.m_protocolVersion, this.m_boundDN, this.m_boundPasswd), myListener, cons);
            this.checkMsg(myListener.getResponse());
            this.setBound(true);
            this.m_rebindConstraints = (LDAPConstraints)cons.clone();
        }
        catch (LDAPReferralException e) {
            this.m_referralConnection = this.createReferralConnection(e, cons);
        }
    }

    synchronized void sendRequest(JDAPProtocolOp oper, LDAPMessageQueue myListener, LDAPConstraints cons) throws LDAPException {
        boolean requestSent = false;
        boolean restoreTried = false;
        while (!requestSent) {
            block8: {
                try {
                    this.m_thread.sendRequest(this, oper, myListener, cons);
                    if (!myListener.isAsynchOp()) {
                        myListener.waitFirstMessage();
                    }
                    requestSent = true;
                }
                catch (IllegalArgumentException e) {
                    throw new LDAPException(e.getMessage(), 89);
                }
                catch (NullPointerException e) {
                    if (this.isConnected() || restoreTried) {
                        break;
                    }
                }
                catch (LDAPException e) {
                    if (e.getLDAPResultCode() == 81 && !restoreTried) break block8;
                    throw e;
                }
            }
            if (requestSent || restoreTried) continue;
            restoreTried = true;
            myListener.reset();
            boolean rebind = !(oper instanceof JDAPBindRequest);
            this.restoreConnection(rebind);
        }
        if (!requestSent) {
            throw new LDAPException("Failed to send request", 80);
        }
    }

    private void checkConnection(boolean rebind) throws LDAPException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connMgr == null) {
            throw new LDAPException("not connected", 80);
        }
        this.restoreConnection(rebind);
    }

    private void restoreConnection(boolean rebind) throws LDAPException {
        this.connect();
        if (this.m_useTLS) {
            this.m_useTLS = false;
            this.startTLS();
        }
        if (!rebind) {
            return;
        }
        if (this.m_saslBinder != null) {
            this.m_saslBinder.bind(this, false);
        } else if (this.m_rebindConstraints != null) {
            this.simpleBind(this.m_rebindConstraints);
        }
    }

    public String getAuthenticationMethod() {
        if (!this.isAuthenticated()) {
            return "none";
        }
        return this.m_saslBinder == null ? "simple" : "sasl";
    }

    public void reconnect() throws LDAPException {
        this.reconnect(true);
    }

    void reconnect(boolean rebind) throws LDAPException {
        boolean useTLS = this.m_useTLS;
        LDAPConnSetupMgr connMgr = this.m_connMgr;
        LDAPConstraints rebindCons = this.m_rebindConstraints;
        this.disconnect();
        this.m_useTLS = useTLS;
        this.m_connMgr = connMgr;
        this.m_rebindConstraints = rebindCons;
        this.restoreConnection(rebind);
    }

    @Override
    public synchronized void disconnect() throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        this.m_thread.deregister(this);
        if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
            this.m_referralConnection.disconnect();
        }
        this.m_referralConnection = null;
        if (this.m_cache != null) {
            this.m_cache.removeReference();
            this.m_cache = null;
        }
        this.m_responseControlTable.clear();
        this.m_rebindConstraints = null;
        this.m_thread = null;
        this.m_connMgr = null;
        this.m_useTLS = false;
    }

    public void close() {
        this.m_thread.close();
    }

    @Override
    public LDAPEntry read(String DN2) throws LDAPException {
        return this.read(DN2, null, this.m_defaultConstraints);
    }

    public LDAPEntry read(String DN2, LDAPSearchConstraints cons) throws LDAPException {
        return this.read(DN2, null, cons);
    }

    @Override
    public LDAPEntry read(String DN2, String[] attrs) throws LDAPException {
        return this.read(DN2, attrs, this.m_defaultConstraints);
    }

    @Override
    public LDAPEntry read(String DN2, String[] attrs, LDAPSearchConstraints cons) throws LDAPException {
        LDAPSearchResults results = this.search(DN2, 0, "(|(objectclass=*)(objectclass=ldapsubentry))", attrs, false, cons);
        if (results == null) {
            return null;
        }
        LDAPEntry entry = results.next();
        while (results.hasMoreElements()) {
            results.nextElement();
        }
        return entry;
    }

    public static LDAPEntry read(LDAPUrl toGet) throws LDAPException {
        String host = toGet.getHost();
        int port = toGet.getPort();
        if (host == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] attributes = toGet.getAttributeArray();
        String DN2 = toGet.getDN();
        LDAPConnection connection = new LDAPConnection();
        if (toGet.isSecure()) {
            LDAPSocketFactory factory = LDAPUrl.getSocketFactory();
            if (factory == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            connection.setSocketFactory(factory);
        }
        connection.connect(host, port);
        LDAPEntry returnValue = connection.read(DN2, attributes);
        connection.disconnect();
        return returnValue;
    }

    public static LDAPSearchResults search(LDAPUrl toGet) throws LDAPException {
        return LDAPConnection.search(toGet, null);
    }

    public static LDAPSearchResults search(LDAPUrl toGet, LDAPSearchConstraints cons) throws LDAPException {
        String host = toGet.getHost();
        int port = toGet.getPort();
        if (host == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] attributes = toGet.getAttributeArray();
        String DN2 = toGet.getDN();
        String filter = toGet.getFilter();
        if (filter == null) {
            filter = defaultFilter;
        }
        int scope = toGet.getScope();
        LDAPConnection connection = new LDAPConnection();
        if (toGet.isSecure()) {
            LDAPSocketFactory factory = LDAPUrl.getSocketFactory();
            if (factory == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            connection.setSocketFactory(factory);
        }
        connection.connect(host, port);
        LDAPSearchResults results = cons != null ? connection.search(DN2, scope, filter, attributes, false, cons) : connection.search(DN2, scope, filter, attributes, false);
        results.closeOnCompletion(connection);
        return results;
    }

    @Override
    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean attrsOnly) throws LDAPException {
        return this.search(base, scope, filter, attrs, attrsOnly, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean attrsOnly, LDAPSearchConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        LDAPSearchResults returnValue = new LDAPSearchResults(this, cons, base, scope, filter, attrs, attrsOnly);
        Vector cacheValue = null;
        Long key = null;
        boolean isKeyValid = true;
        try {
            if (this.m_cache != null && (cacheValue = (Vector)this.m_cache.getEntry(key = this.m_cache.createKey(this.getHost(), this.getPort(), base, filter, scope, attrs, this.m_boundDN, cons))) != null) {
                return new LDAPSearchResults(cacheValue, this, cons, base, scope, filter, attrs, attrsOnly);
            }
        }
        catch (LDAPException e) {
            isKeyValid = false;
            LDAPConnection.printDebug("Exception: " + e);
        }
        this.checkConnection(true);
        boolean isPersistentSearch = false;
        LDAPControl[] controls = (LDAPControl[])LDAPConnection.getOption(12, cons);
        for (int i = 0; controls != null && i < controls.length; ++i) {
            if (!(controls[i] instanceof LDAPPersistSearchControl)) continue;
            isPersistentSearch = true;
            break;
        }
        LDAPSearchListener myListener = isPersistentSearch ? new LDAPSearchListener(true, cons) : this.getSearchListener(cons);
        int deref = cons.getDereference();
        JDAPSearchRequest request = null;
        try {
            request = new JDAPSearchRequest(base, scope, deref, cons.getMaxResults(), cons.getServerTimeLimit(), attrsOnly, filter, attrs);
        }
        catch (IllegalArgumentException e) {
            throw new LDAPException(e.getMessage(), 89);
        }
        if (this.m_cache != null && isKeyValid) {
            myListener.setKey(key);
        }
        try {
            this.sendRequest(request, myListener, cons);
        }
        catch (LDAPException e) {
            this.releaseSearchListener(myListener);
            throw e;
        }
        if (isPersistentSearch) {
            returnValue.associatePersistentSearch(myListener);
        } else {
            if (cons.getBatchSize() == 0) {
                try {
                    LDAPResponse response = myListener.completeSearchOperation();
                    Enumeration<LDAPMessage> results = myListener.getAllMessages().elements();
                    this.checkSearchMsg(returnValue, response, cons, base, scope, filter, attrs, attrsOnly);
                    while (results.hasMoreElements()) {
                        LDAPMessage msg = results.nextElement();
                        this.checkSearchMsg(returnValue, msg, cons, base, scope, filter, attrs, attrsOnly);
                    }
                }
                finally {
                    this.releaseSearchListener(myListener);
                }
            }
            LDAPMessage firstResult = myListener.nextMessage();
            if (firstResult instanceof LDAPResponse) {
                try {
                    this.checkSearchMsg(returnValue, firstResult, cons, base, scope, filter, attrs, attrsOnly);
                }
                finally {
                    this.releaseSearchListener(myListener);
                }
            }
            try {
                this.checkSearchMsg(returnValue, firstResult, cons, base, scope, filter, attrs, attrsOnly);
            }
            catch (LDAPException ex) {
                this.releaseSearchListener(myListener);
                throw ex;
            }
            returnValue.associate(myListener);
        }
        return returnValue;
    }

    void checkSearchMsg(LDAPSearchResults value, LDAPMessage msg, LDAPSearchConstraints cons, String dn, int scope, String filter, String[] attrs, boolean attrsOnly) throws LDAPException {
        value.setMsgID(msg.getMessageID());
        try {
            this.checkMsg(msg);
            if (msg.getProtocolOp().getType() != 5) {
                value.add(msg);
            }
        }
        catch (LDAPReferralException e) {
            Vector<Object> res = new Vector<Object>();
            try {
                this.performReferrals(e, cons, 3, dn, scope, filter, attrs, attrsOnly, null, null, null, res);
            }
            catch (LDAPException ex) {
                if (msg.getProtocolOp() instanceof JDAPSearchResultReference) {
                    if (cons.getReferralErrors() == 0) {
                        return;
                    }
                    throw ex;
                }
                throw ex;
            }
            for (int i = 0; i < res.size(); ++i) {
                value.addReferralEntries((LDAPSearchResults)res.elementAt(i));
            }
            res = null;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 11 || e.getLDAPResultCode() == 3 || e.getLDAPResultCode() == 4) {
                value.add(e);
            }
            throw e;
        }
    }

    @Override
    public boolean compare(String DN2, LDAPAttribute attr) throws LDAPException {
        return this.compare(DN2, attr, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compare(String DN2, LDAPAttribute attr, LDAPConstraints cons) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener myListener = this.getResponseListener();
        Enumeration<String> en = attr.getStringValues();
        String val = en.nextElement();
        JDAPAVA ass = new JDAPAVA(attr.getName(), val);
        try {
            this.sendRequest(new JDAPCompareRequest(DN2, ass), myListener, cons);
            LDAPResponse response = myListener.getResponse();
            int resultCode = ((JDAPResult)((Object)response.getProtocolOp())).getResultCode();
            if (resultCode == 5) {
                boolean bl = false;
                return bl;
            }
            if (resultCode == 6) {
                boolean bl = true;
                return bl;
            }
            this.checkMsg(response);
        }
        catch (LDAPReferralException e) {
            Vector<Object> res = new Vector<Object>();
            this.performReferrals(e, cons, 14, DN2, 0, null, null, false, null, null, attr, res);
            boolean bool = false;
            if (res.size() > 0) {
                bool = (Boolean)res.elementAt(0);
            }
            boolean bl = bool;
            return bl;
        }
        finally {
            this.releaseResponseListener(myListener);
        }
        return false;
    }

    @Deprecated
    public boolean compare(String DN2, LDAPAttribute attr, LDAPSearchConstraints cons) throws LDAPException {
        return this.compare(DN2, attr, (LDAPConstraints)cons);
    }

    @Override
    public void add(LDAPEntry entry) throws LDAPException {
        this.add(entry, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(LDAPEntry entry, LDAPConstraints cons) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener myListener = this.getResponseListener();
        LDAPAttributeSet attrs = entry.getAttributeSet();
        LDAPAttribute[] attrList = new LDAPAttribute[attrs.size()];
        for (int i = 0; i < attrs.size(); ++i) {
            attrList[i] = attrs.elementAt(i);
        }
        boolean attrPosition = false;
        try {
            this.sendRequest(new JDAPAddRequest(entry.getDN(), attrList), myListener, cons);
            LDAPResponse response = myListener.getResponse();
            this.checkMsg(response);
        }
        catch (LDAPReferralException e) {
            this.performReferrals(e, cons, 8, null, 0, null, null, false, null, entry, null, null);
        }
        finally {
            this.releaseResponseListener(myListener);
        }
    }

    @Deprecated
    public void add(LDAPEntry entry, LDAPSearchConstraints cons) throws LDAPException {
        this.add(entry, (LDAPConstraints)cons);
    }

    @Override
    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation op) throws LDAPException {
        return this.extendedOperation(op, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation op, LDAPConstraints cons) throws LDAPException {
        String resultID;
        this.checkConnection(true);
        LDAPResponseListener myListener = this.getResponseListener();
        LDAPResponse response = null;
        byte[] results = null;
        try {
            this.sendRequest(new JDAPExtendedRequest(op.getID(), op.getValue()), myListener, cons);
            response = myListener.getResponse();
            this.checkMsg(response);
            JDAPExtendedResponse res = (JDAPExtendedResponse)response.getProtocolOp();
            results = res.getValue();
            resultID = res.getID();
        }
        catch (LDAPReferralException e) {
            LDAPExtendedOperation lDAPExtendedOperation = this.performExtendedReferrals(e, cons, op);
            return lDAPExtendedOperation;
        }
        finally {
            this.releaseResponseListener(myListener);
        }
        return new LDAPExtendedOperation(resultID, results);
    }

    @Deprecated
    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation op, LDAPSearchConstraints cons) throws LDAPException {
        return this.extendedOperation(op, (LDAPConstraints)cons);
    }

    @Override
    public void modify(String DN2, LDAPModification mod) throws LDAPException {
        this.modify(DN2, mod, this.m_defaultConstraints);
    }

    @Override
    public void modify(String DN2, LDAPModification mod, LDAPConstraints cons) throws LDAPException {
        LDAPModification[] mods = new LDAPModification[]{mod};
        this.modify(DN2, mods, cons);
    }

    @Deprecated
    public void modify(String DN2, LDAPModification mod, LDAPSearchConstraints cons) throws LDAPException {
        this.modify(DN2, mod, (LDAPConstraints)cons);
    }

    @Override
    public void modify(String DN2, LDAPModificationSet mods) throws LDAPException {
        this.modify(DN2, mods, this.m_defaultConstraints);
    }

    @Override
    public void modify(String DN2, LDAPModificationSet mods, LDAPConstraints cons) throws LDAPException {
        LDAPModification[] modList = new LDAPModification[mods.size()];
        for (int i = 0; i < mods.size(); ++i) {
            modList[i] = mods.elementAt(i);
        }
        this.modify(DN2, modList, cons);
    }

    @Deprecated
    public void modify(String DN2, LDAPModificationSet mods, LDAPSearchConstraints cons) throws LDAPException {
        this.modify(DN2, mods, (LDAPConstraints)cons);
    }

    public void modify(String DN2, LDAPModification[] mods) throws LDAPException {
        this.modify(DN2, mods, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String DN2, LDAPModification[] mods, LDAPConstraints cons) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener myListener = this.getResponseListener();
        LDAPResponse response = null;
        try {
            this.sendRequest(new JDAPModifyRequest(DN2, mods), myListener, cons);
            response = myListener.getResponse();
            this.checkMsg(response);
        }
        catch (LDAPReferralException e) {
            this.performReferrals(e, cons, 6, DN2, 0, null, null, false, mods, null, null, null);
        }
        finally {
            this.releaseResponseListener(myListener);
        }
    }

    @Deprecated
    public void modify(String DN2, LDAPModification[] mods, LDAPSearchConstraints cons) throws LDAPException {
        this.modify(DN2, mods, (LDAPConstraints)cons);
    }

    @Override
    public void delete(String DN2) throws LDAPException {
        this.delete(DN2, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String DN2, LDAPConstraints cons) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            this.sendRequest(new JDAPDeleteRequest(DN2), myListener, cons);
            LDAPResponse response = myListener.getResponse();
            this.checkMsg(response);
        }
        catch (LDAPReferralException e) {
            this.performReferrals(e, cons, 10, DN2, 0, null, null, false, null, null, null, null);
        }
        finally {
            this.releaseResponseListener(myListener);
        }
    }

    @Deprecated
    public void delete(String DN2, LDAPSearchConstraints cons) throws LDAPException {
        this.delete(DN2, (LDAPConstraints)cons);
    }

    @Override
    public void rename(String DN2, String newRDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(DN2, newRDN, null, deleteOldRDN);
    }

    @Override
    public void rename(String DN2, String newRDN, boolean deleteOldRDN, LDAPConstraints cons) throws LDAPException {
        this.rename(DN2, newRDN, null, deleteOldRDN, cons);
    }

    @Deprecated
    public void rename(String DN2, String newRDN, boolean deleteOldRDN, LDAPSearchConstraints cons) throws LDAPException {
        this.rename(DN2, newRDN, deleteOldRDN, (LDAPConstraints)cons);
    }

    @Override
    public void rename(String dn, String newRDN, String newParentDN, boolean deleteOldRDN) throws LDAPException {
        this.rename(dn, newRDN, newParentDN, deleteOldRDN, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String DN2, String newRDN, String newParentDN, boolean deleteOldRDN, LDAPConstraints cons) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener myListener = this.getResponseListener();
        try {
            JDAPModifyRDNRequest request = null;
            request = newParentDN != null ? new JDAPModifyRDNRequest(DN2, newRDN, deleteOldRDN, newParentDN) : new JDAPModifyRDNRequest(DN2, newRDN, deleteOldRDN);
            this.sendRequest(request, myListener, cons);
            LDAPResponse response = myListener.getResponse();
            this.checkMsg(response);
        }
        catch (LDAPReferralException e) {
            this.performReferrals(e, cons, 12, DN2, 0, newRDN, null, deleteOldRDN, null, null, null, null);
        }
        finally {
            this.releaseResponseListener(myListener);
        }
    }

    @Deprecated
    public void rename(String DN2, String newRDN, String newParentDN, boolean deleteOldRDN, LDAPSearchConstraints cons) throws LDAPException {
        this.rename(DN2, newRDN, newParentDN, deleteOldRDN, (LDAPConstraints)cons);
    }

    @Override
    public LDAPResponseListener add(LDAPEntry entry, LDAPResponseListener listener) throws LDAPException {
        return this.add(entry, listener, this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener add(LDAPEntry entry, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        LDAPAttributeSet attrs = entry.getAttributeSet();
        LDAPAttribute[] attrList = new LDAPAttribute[attrs.size()];
        for (int i = 0; i < attrs.size(); ++i) {
            attrList[i] = attrs.elementAt(i);
        }
        boolean attrPosition = false;
        this.sendRequest(new JDAPAddRequest(entry.getDN(), attrList), listener, cons);
        return listener;
    }

    public LDAPResponseListener bind(int version, String dn, String passwd, LDAPResponseListener listener) throws LDAPException {
        return this.bind(version, dn, passwd, listener, this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener bind(String dn, String passwd, LDAPResponseListener listener) throws LDAPException {
        return this.bind(this.m_protocolVersion, dn, passwd, listener, this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener bind(String dn, String passwd, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        return this.bind(this.m_protocolVersion, dn, passwd, listener, cons);
    }

    public LDAPResponseListener bind(int version, String dn, String passwd, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        return this.authenticate(version, dn, passwd, listener, cons);
    }

    @Override
    public LDAPResponseListener delete(String dn, LDAPResponseListener listener) throws LDAPException {
        return this.delete(dn, listener, this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener delete(String dn, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPDeleteRequest(dn), listener, cons);
        return listener;
    }

    @Override
    public LDAPResponseListener modify(String dn, LDAPModification mod, LDAPResponseListener listener) throws LDAPException {
        return this.modify(dn, mod, listener, (LDAPConstraints)this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener modify(String dn, LDAPModification mod, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        LDAPModification[] modList = new LDAPModification[]{mod};
        this.sendRequest(new JDAPModifyRequest(dn, modList), listener, cons);
        return listener;
    }

    @Override
    public LDAPResponseListener modify(String dn, LDAPModificationSet mods, LDAPResponseListener listener) throws LDAPException {
        return this.modify(dn, mods, listener, (LDAPConstraints)this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener modify(String dn, LDAPModificationSet mods, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        LDAPModification[] modList = new LDAPModification[mods.size()];
        for (int i = 0; i < mods.size(); ++i) {
            modList[i] = mods.elementAt(i);
        }
        this.sendRequest(new JDAPModifyRequest(dn, modList), listener, cons);
        return listener;
    }

    @Override
    public LDAPResponseListener rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseListener listener) throws LDAPException {
        return this.rename(dn, newRdn, deleteOldRdn, listener, (LDAPConstraints)this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPModifyRDNRequest(dn, newRdn, deleteOldRdn), listener, cons);
        return listener;
    }

    @Override
    public LDAPSearchListener search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchListener listener) throws LDAPException {
        return this.search(base, scope, filter, attrs, typesOnly, listener, this.m_defaultConstraints);
    }

    @Override
    public LDAPSearchListener search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchListener listener, LDAPSearchConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (listener == null) {
            listener = new LDAPSearchListener(true, cons);
        }
        JDAPSearchRequest request = null;
        try {
            request = new JDAPSearchRequest(base, scope, cons.getDereference(), cons.getMaxResults(), cons.getServerTimeLimit(), typesOnly, filter, attrs);
        }
        catch (IllegalArgumentException e) {
            throw new LDAPException(e.getMessage(), 89);
        }
        this.sendRequest(request, listener, cons);
        return listener;
    }

    @Override
    public LDAPResponseListener compare(String dn, LDAPAttribute attr, LDAPResponseListener listener) throws LDAPException {
        return this.compare(dn, attr, listener, this.m_defaultConstraints);
    }

    @Override
    public LDAPResponseListener compare(String dn, LDAPAttribute attr, LDAPResponseListener listener, LDAPConstraints cons) throws LDAPException {
        if (cons == null) {
            cons = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (listener == null) {
            listener = new LDAPResponseListener(true);
        }
        Enumeration<String> en = attr.getStringValues();
        String val = en.nextElement();
        JDAPAVA ava = new JDAPAVA(attr.getName(), val);
        this.sendRequest(new JDAPCompareRequest(dn, ava), listener, cons);
        return listener;
    }

    @Override
    public void abandon(int id) throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        try {
            LDAPControl[] ctrls = this.m_defaultConstraints.getServerControls();
            this.m_thread.abandon(id, ctrls);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void abandon(LDAPSearchListener searchlistener) throws LDAPException {
        int[] ids = searchlistener.getMessageIDs();
        for (int i = 0; i < ids.length; ++i) {
            searchlistener.removeRequest(ids[i]);
            this.abandon(ids[i]);
        }
    }

    @Override
    public Object getOption(int option) throws LDAPException {
        if (option == 17) {
            return this.m_protocolVersion;
        }
        return LDAPConnection.getOption(option, this.m_defaultConstraints);
    }

    private static Object getOption(int option, LDAPSearchConstraints cons) throws LDAPException {
        switch (option) {
            case 2: {
                return cons.getDereference();
            }
            case 3: {
                return cons.getMaxResults();
            }
            case 4: {
                return cons.getServerTimeLimit();
            }
            case 8: {
                return cons.getReferrals();
            }
            case 9: {
                return cons.getRebindProc();
            }
            case 13: {
                return cons.getBindProc();
            }
            case 10: {
                return cons.getHopLimit();
            }
            case 20: {
                return cons.getBatchSize();
            }
            case 11: {
                return cons.getClientControls();
            }
            case 12: {
                return cons.getServerControls();
            }
            case 30: {
                return cons.getMaxBacklog();
            }
        }
        throw new LDAPException("invalid option", 89);
    }

    @Override
    public void setOption(int option, Object value) throws LDAPException {
        if (option == 17) {
            this.setProtocolVersion((Integer)value);
            return;
        }
        LDAPConnection.setOption(option, value, this.m_defaultConstraints);
    }

    private static void setOption(int option, Object value, LDAPSearchConstraints cons) throws LDAPException {
        try {
            switch (option) {
                case 2: {
                    cons.setDereference((Integer)value);
                    return;
                }
                case 3: {
                    cons.setMaxResults((Integer)value);
                    return;
                }
                case 4: {
                    cons.setTimeLimit((Integer)value);
                    return;
                }
                case 5: {
                    cons.setServerTimeLimit((Integer)value);
                    return;
                }
                case 8: {
                    cons.setReferrals((Boolean)value);
                    return;
                }
                case 13: {
                    cons.setBindProc((LDAPBind)value);
                    return;
                }
                case 9: {
                    cons.setRebindProc((LDAPRebind)value);
                    return;
                }
                case 10: {
                    cons.setHopLimit((Integer)value);
                    return;
                }
                case 20: {
                    cons.setBatchSize((Integer)value);
                    return;
                }
                case 11: {
                    if (value == null) {
                        cons.setClientControls((LDAPControl[])null);
                    } else if (value instanceof LDAPControl) {
                        cons.setClientControls((LDAPControl)value);
                    } else if (value instanceof LDAPControl[]) {
                        cons.setClientControls((LDAPControl[])value);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 12: {
                    if (value == null) {
                        cons.setServerControls((LDAPControl[])null);
                    } else if (value instanceof LDAPControl) {
                        cons.setServerControls((LDAPControl)value);
                    } else if (value instanceof LDAPControl[]) {
                        cons.setServerControls((LDAPControl[])value);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 30: {
                    cons.setMaxBacklog((Integer)value);
                    return;
                }
            }
            throw new LDAPException("invalid option", 89);
        }
        catch (ClassCastException cc) {
            throw new LDAPException("invalid option value", 89);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPControl[] getResponseControls() {
        LDAPControl[] controls = null;
        Thread caller = Thread.currentThread();
        Hashtable<Thread, ResponseControls> hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            ResponseControls rspCtrls = this.m_responseControlTable.get(caller);
            if (rspCtrls != null) {
                Vector<LDAPControl[]> v = rspCtrls.ctrls;
                controls = v.elementAt(0);
                v.removeElementAt(0);
                if (v.size() == 0) {
                    this.m_responseControlTable.remove(caller);
                }
            }
        }
        return controls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPControl[] getResponseControls(int msgID) {
        LDAPControl[] controls = null;
        Hashtable<Thread, ResponseControls> hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Enumeration<Thread> itr = this.m_responseControlTable.keys();
            while (itr.hasMoreElements()) {
                Thread client = itr.nextElement();
                ResponseControls rspCtrls = this.m_responseControlTable.get(client);
                if (msgID != rspCtrls.msgID) continue;
                Vector<LDAPControl[]> v = rspCtrls.ctrls;
                controls = v.elementAt(0);
                v.removeElementAt(0);
                if (v.size() != 0) break;
                this.m_responseControlTable.remove(client);
                break;
            }
        }
        return controls;
    }

    public LDAPConstraints getConstraints() {
        return this.getSearchConstraints();
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return (LDAPSearchConstraints)this.m_defaultConstraints.clone();
    }

    public void setConstraints(LDAPConstraints cons) {
        this.m_defaultConstraints.setHopLimit(cons.getHopLimit());
        this.m_defaultConstraints.setReferrals(cons.getReferrals());
        this.m_defaultConstraints.setTimeLimit(cons.getTimeLimit());
        this.m_defaultConstraints.setBindProc(cons.getBindProc());
        this.m_defaultConstraints.setRebindProc(cons.getRebindProc());
        LDAPControl[] tClientControls = cons.getClientControls();
        LDAPControl[] oClientControls = null;
        if (tClientControls != null && tClientControls.length > 0) {
            oClientControls = new LDAPControl[tClientControls.length];
            for (int i = 0; i < tClientControls.length; ++i) {
                oClientControls[i] = (LDAPControl)tClientControls[i].clone();
            }
        }
        this.m_defaultConstraints.setClientControls(oClientControls);
        LDAPControl[] tServerControls = cons.getServerControls();
        LDAPControl[] oServerControls = null;
        if (tServerControls != null && tServerControls.length > 0) {
            oServerControls = new LDAPControl[tServerControls.length];
            for (int i = 0; i < tServerControls.length; ++i) {
                oServerControls[i] = (LDAPControl)tServerControls[i].clone();
            }
        }
        this.m_defaultConstraints.setServerControls(oServerControls);
    }

    public void setSearchConstraints(LDAPSearchConstraints cons) {
        this.m_defaultConstraints = (LDAPSearchConstraints)cons.clone();
    }

    public InputStream getInputStream() {
        return this.m_thread != null ? this.m_thread.getInputStream() : null;
    }

    public void setInputStream(InputStream is) {
        if (this.m_thread != null) {
            this.m_thread.setInputStream(is);
        }
    }

    public OutputStream getOutputStream() {
        return this.m_thread != null ? this.m_thread.getOutputStream() : null;
    }

    public void setOutputStream(OutputStream os) {
        if (this.m_thread != null) {
            this.m_thread.setOutputStream(os);
        }
    }

    synchronized LDAPResponseListener getResponseListener() {
        LDAPResponseListener l;
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        if (this.m_responseListeners.size() < 1) {
            l = new LDAPResponseListener(false);
        } else {
            l = this.m_responseListeners.elementAt(0);
            this.m_responseListeners.removeElementAt(0);
        }
        return l;
    }

    private synchronized LDAPSearchListener getSearchListener(LDAPSearchConstraints cons) {
        LDAPSearchListener l;
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        if (this.m_searchListeners.size() < 1) {
            l = new LDAPSearchListener(false, cons);
        } else {
            l = this.m_searchListeners.elementAt(0);
            this.m_searchListeners.removeElementAt(0);
            l.setSearchConstraints(cons);
        }
        return l;
    }

    synchronized void releaseResponseListener(LDAPResponseListener l) {
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        l.reset();
        this.m_responseListeners.addElement(l);
    }

    synchronized void releaseSearchListener(LDAPSearchListener l) {
        if (l.isAsynchOp()) {
            return;
        }
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        l.reset();
        this.m_searchListeners.addElement(l);
    }

    void checkMsg(LDAPMessage m) throws LDAPException {
        LDAPControl[] ctrls = m.getControls();
        if (ctrls != null) {
            int msgID = m.getMessageID();
            this.setResponseControls(Thread.currentThread(), msgID, ctrls);
        }
        if (m.getProtocolOp() instanceof JDAPResult) {
            JDAPResult response = (JDAPResult)((Object)m.getProtocolOp());
            int resultCode = response.getResultCode();
            if (resultCode == 0) {
                return;
            }
            if (resultCode == 10) {
                throw new LDAPReferralException("referral", resultCode, response.getReferrals());
            }
            if (resultCode == 9) {
                throw new LDAPReferralException("referral", resultCode, response.getErrorMessage());
            }
            throw new LDAPException(LDAPException.errorCodeToString(resultCode), resultCode, response.getErrorMessage(), response.getMatchedDN());
        }
        if (m.getProtocolOp() instanceof JDAPSearchResultReference) {
            String[] referrals = ((JDAPSearchResultReference)m.getProtocolOp()).getUrls();
            throw new LDAPReferralException("referral", 0, referrals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResponseControls(Thread client, int msgID, LDAPControl[] ctrls) {
        Hashtable<Thread, ResponseControls> hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            ResponseControls rspCtrls = this.m_responseControlTable.get(client);
            if (rspCtrls == null || rspCtrls.msgID != msgID) {
                rspCtrls = new ResponseControls(msgID, ctrls);
                this.m_responseControlTable.put(client, rspCtrls);
            } else {
                rspCtrls.addControls(ctrls);
            }
        }
    }

    private LDAPConnection referralConnect(LDAPUrl[] refList, LDAPConstraints cons) throws LDAPException {
        LDAPConnection connection = new LDAPConnection(this.getSocketFactory());
        connection.setConnSetupDelay(this.getConnSetupDelay());
        connection.setOption(8, true);
        connection.setOption(9, cons.getRebindProc());
        connection.setOption(13, cons.getBindProc());
        Object traceOut = this.getProperty(TRACE_PROPERTY);
        if (traceOut != null) {
            connection.setProperty(TRACE_PROPERTY, traceOut);
        }
        connection.setOption(17, this.m_protocolVersion);
        connection.setOption(10, cons.getHopLimit() - 1);
        try {
            connection.connect(refList);
        }
        catch (LDAPException e) {
            throw new LDAPException("Referral connect failed: " + e.getMessage(), e.getLDAPResultCode());
        }
        return connection;
    }

    private void referralRebind(LDAPConnection ldc, LDAPConstraints cons) throws LDAPException {
        try {
            if (cons.getRebindProc() == null && cons.getBindProc() == null) {
                ldc.authenticate(this.m_protocolVersion, null, null);
            } else if (cons.getBindProc() == null) {
                LDAPRebindAuth auth = cons.getRebindProc().getRebindAuthentication(ldc.getHost(), ldc.getPort());
                ldc.authenticate(this.m_protocolVersion, auth.getDN(), auth.getPassword());
            } else {
                cons.getBindProc().bind(ldc);
            }
        }
        catch (LDAPException e) {
            throw new LDAPException("Referral bind failed: " + e.getMessage(), e.getLDAPResultCode());
        }
    }

    private void adjustReferrals(LDAPUrl[] urls) {
        String host = null;
        int port = 0;
        for (int i = 0; urls != null && i < urls.length; ++i) {
            host = urls[i].getHost();
            port = urls[i].getPort();
            if (host != null && host.length() >= 1) continue;
            host = this.getHost();
            port = this.getPort();
            urls[i] = new LDAPUrl(host, port, urls[i].getDN(), urls[i].getAttributeArray(), urls[i].getScope(), urls[i].getFilter(), urls[i].isSecure());
        }
    }

    LDAPConnection createReferralConnection(LDAPReferralException e, LDAPConstraints cons) throws LDAPException {
        if (cons.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
        }
        if (!cons.getReferrals()) {
            throw e;
        }
        LDAPUrl[] refList = e.getURLs();
        if (refList == null) {
            throw new LDAPException("No target URL in referral", 94);
        }
        this.adjustReferrals(refList);
        LDAPConnection connection = this.referralConnect(refList, cons);
        LDAPUrl refURL = connection.m_connMgr.getLDAPUrl();
        String refDN = refURL.getDN();
        if (refDN == null || refDN.equals("")) {
            refDN = this.m_boundDN;
        }
        try {
            connection.authenticate(this.m_protocolVersion, refDN, this.m_boundPasswd);
        }
        catch (LDAPException authEx) {
            try {
                connection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            throw authEx;
        }
        return connection;
    }

    void performReferrals(LDAPReferralException e, LDAPConstraints cons, int ops, String dn, int scope, String filter, String[] types, boolean attrsOnly, LDAPModification[] mods, LDAPEntry entry, LDAPAttribute attr, Vector<Object> results) throws LDAPException {
        LDAPUrl refURL = null;
        LDAPConnection connection = null;
        try {
            if (cons.getHopLimit() <= 0) {
                throw new LDAPException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
            }
            if (!cons.getReferrals()) {
                if (ops == 3) {
                    LDAPSearchResults res = new LDAPSearchResults();
                    res.add(e);
                    results.addElement(res);
                    return;
                }
                throw e;
            }
            LDAPUrl[] urls = e.getURLs();
            if (urls == null || urls.length == 0) {
                return;
            }
            this.adjustReferrals(urls);
            if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
                String refHost = this.m_referralConnection.getHost();
                int refPort = this.m_referralConnection.getPort();
                try {
                    String refAddr = InetAddress.getByName(refHost).getHostAddress();
                    for (int i = 0; i < urls.length; ++i) {
                        String urlHost = urls[i].getHost();
                        int urlPort = urls[i].getPort();
                        String urlAddr = InetAddress.getByName(urlHost).getHostAddress();
                        if (refAddr != urlAddr || refPort != urlPort) continue;
                        refURL = urls[i];
                        break;
                    }
                }
                catch (UnknownHostException ex) {
                    for (int i = 0; i < urls.length; ++i) {
                        if (refHost != urls[i].getHost() || refPort != urls[i].getPort()) continue;
                        refURL = urls[i];
                        break;
                    }
                }
            }
            if (refURL != null) {
                connection = this.m_referralConnection;
            } else {
                connection = this.referralConnect(urls, cons);
                refURL = connection.m_connMgr.getLDAPUrl();
                this.referralRebind(connection, cons);
            }
            String newDN = refURL.getDN();
            String DN2 = null;
            DN2 = newDN == null || newDN.equals("") ? dn : newDN;
            if (refURL.getUrl().indexOf("?base") > -1) {
                scope = 0;
            }
            LDAPSearchConstraints newcons = (LDAPSearchConstraints)cons.clone();
            newcons.setHopLimit(cons.getHopLimit() - 1);
            this.referralOperation(connection, newcons, ops, DN2, scope, filter, types, attrsOnly, mods, entry, attr, results);
        }
        catch (LDAPException ex) {
            if (refURL != null) {
                ex.setExtraMessage("Failed to follow referral to " + refURL);
            } else {
                ex.setExtraMessage("Failed to follow referral");
            }
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void referralOperation(LDAPConnection connection, LDAPConstraints cons, int ops, String dn, int scope, String filter, String[] types, boolean attrsOnly, LDAPModification[] mods, LDAPEntry entry, LDAPAttribute attr, Vector<Object> results) throws LDAPException {
        LDAPSearchResults res = null;
        try {
            switch (ops) {
                case 3: {
                    res = connection.search(dn, scope, filter, types, attrsOnly, (LDAPSearchConstraints)cons);
                    if (res != null) {
                        res.closeOnCompletion(connection);
                        results.addElement(res);
                        return;
                    }
                    if (this.m_referralConnection != null) {
                        if (connection.equals(this.m_referralConnection)) return;
                    }
                    connection.disconnect();
                    return;
                }
                case 6: {
                    connection.modify(dn, mods, cons);
                    return;
                }
                case 8: {
                    if (dn != null && !dn.equals("")) {
                        entry.setDN(dn);
                    }
                    connection.add(entry, cons);
                    return;
                }
                case 10: {
                    connection.delete(dn, cons);
                    return;
                }
                case 12: {
                    connection.rename(dn, filter, attrsOnly, cons);
                    return;
                }
                case 14: {
                    boolean bool = connection.compare(dn, attr, cons);
                    results.addElement(bool);
                    return;
                }
            }
            return;
        }
        catch (LDAPException ee) {
            throw ee;
        }
        finally {
            if (!(connection == null || ops == 3 && res != null || this.m_referralConnection != null && connection.equals(this.m_referralConnection))) {
                connection.disconnect();
            }
        }
    }

    private LDAPExtendedOperation performExtendedReferrals(LDAPReferralException e, LDAPConstraints cons, LDAPExtendedOperation op) throws LDAPException {
        if (cons.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", e.getLDAPResultCode(), e.getLDAPErrorMessage());
        }
        if (!cons.getReferrals()) {
            throw e;
        }
        LDAPUrl[] u = e.getURLs();
        if (u == null || u.length == 0) {
            return null;
        }
        this.adjustReferrals(u);
        LDAPConnection connection = this.referralConnect(u, cons);
        this.referralRebind(connection, cons);
        LDAPExtendedOperation results = connection.extendedOperation(op);
        connection.disconnect();
        return results;
    }

    public synchronized Object clone() {
        LDAPConnection c = null;
        try {
            if (this.m_thread != null) {
                this.checkConnection(true);
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        try {
            c = (LDAPConnection)super.clone();
            c.m_defaultConstraints = (LDAPSearchConstraints)this.m_defaultConstraints.clone();
            c.m_responseListeners = null;
            c.m_searchListeners = null;
            c.m_properties = (Hashtable)this.m_properties.clone();
            c.m_responseControlTable = new Hashtable();
            if (c.m_cache != null) {
                c.m_cache.addReference();
            }
            if (this.isConnected()) {
                c.m_thread.register(c);
            } else {
                c.m_thread = null;
                c.m_connMgr = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    private static boolean checkCommunicator() {
        try {
            Method m = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
            if (m == null) {
                LDAPConnection.printDebug("Method is null");
                return false;
            }
            Object[] args = new Object[]{new String("UniversalConnect")};
            m.invoke(null, args);
            LDAPConnection.printDebug("UniversalConnect enabled");
            args[0] = new String("UniversalPropertyRead");
            m.invoke(null, args);
            LDAPConnection.printDebug("UniversalPropertyRead enabled");
            return true;
        }
        catch (LDAPException e) {
            LDAPConnection.printDebug("Exception: " + e.toString());
        }
        catch (Exception ie) {
            LDAPConnection.printDebug("Exception on invoking enablePrivilege: " + ie.toString());
        }
        return false;
    }

    public static boolean isNetscape() {
        return isCommunicator;
    }

    static void printDebug(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public String toString() {
        int cloneCnt = this.m_thread == null ? 0 : this.m_thread.getClientCount();
        StringBuffer sb = new StringBuffer("LDAPConnection {");
        if (this.m_connMgr != null) {
            sb.append(this.m_connMgr.getLDAPUrl().getServerUrl());
        }
        if (cloneCnt > 1) {
            sb.append(" (");
            sb.append(cloneCnt);
            sb.append(")");
        }
        sb.append(" ldapVersion:");
        sb.append(this.m_protocolVersion);
        sb.append(" bindDN:\"");
        if (this.getAuthenticationDN() != null) {
            sb.append(this.getAuthenticationDN());
        }
        sb.append("\"}");
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("LDAP SDK Version is " + SdkVersion);
        System.out.println("LDAP Protocol Version is " + ProtocolVersion);
    }

    class ResponseControls {
        int msgID;
        Vector<LDAPControl[]> ctrls;

        public ResponseControls(int msgID, LDAPControl[] ctrls) {
            this.msgID = msgID;
            this.ctrls = new Vector();
            this.ctrls.addElement(ctrls);
        }

        void addControls(LDAPControl[] ctrls) {
            this.ctrls.addElement(ctrls);
        }
    }
}

