/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.core.ProvisioningEventBus;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractPublisherApplication
implements IApplication {
    protected static final String[][] INPLACE_MAPPING_RULES = new String[][]{{"(& (classifier=osgi.bundle) (format=packed)", "${repoUrl}/features/${id}_${version}.jar.pack.gz"}, {"(& (classifier=osgi.bundle))", "${repoUrl}/plugins/${id}_${version}.jar"}, {"(& (classifier=binary))", "${repoUrl}/binary/${id}_${version}"}, {"(& (classifier=org.eclipse.update.feature))", "${repoUrl}/features/${id}_${version}.jar"}};
    public static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private ArtifactRepositoryManager defaultArtifactManager;
    private ServiceRegistration registrationDefaultArtifactManager;
    private MetadataRepositoryManager defaultMetadataManager;
    private ServiceRegistration registrationDefaultMetadataManager;
    private IProvisioningEventBus bus;
    private ServiceRegistration registrationBus;
    protected PublisherInfo info;
    protected String source;
    protected URI metadataLocation;
    protected String metadataRepoName;
    protected URI artifactLocation;
    protected String artifactRepoName;
    protected URI[] contextMetadataRepositories;
    protected URI[] contextArtifactRepositories;
    protected boolean compress = false;
    protected boolean inplace = false;
    protected boolean append = false;
    protected boolean reusePackedFiles = false;
    protected String[] configurations;
    private IStatus status;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IStatus getStatus() {
        return this.status;
    }

    protected void initialize(PublisherInfo info) throws ProvisionException {
        if (this.inplace) {
            File location = new File(this.source);
            if (this.metadataLocation == null) {
                this.metadataLocation = location.toURI();
            }
            if (this.artifactLocation == null) {
                this.artifactLocation = location.toURI();
            }
            info.setArtifactOptions(info.getArtifactOptions() | 1 | 2);
        }
        this.initializeRepositories(info);
    }

    protected IStatus createConfigurationEror(String message) {
        return new Status(4, "org.eclipse.equinox.p2.publisher", message);
    }

    protected void initializeRepositories(PublisherInfo info) throws ProvisionException {
        CompositeArtifactRepository contextArtifact;
        int i;
        CompositeMetadataRepository contextMetadata;
        if (this.artifactLocation != null) {
            info.setArtifactRepository(Publisher.createArtifactRepository(this.artifactLocation, this.artifactRepoName, this.append, this.compress, this.reusePackedFiles));
        } else if ((info.getArtifactOptions() & 2) > 0) {
            throw new ProvisionException(this.createConfigurationEror(Messages.exception_noArtifactRepo));
        }
        if (this.metadataLocation == null) {
            throw new ProvisionException(this.createConfigurationEror(Messages.exception_noMetadataRepo));
        }
        info.setMetadataRepository(Publisher.createMetadataRepository(this.metadataLocation, this.metadataRepoName, this.append, this.compress));
        if (this.contextMetadataRepositories != null && this.contextMetadataRepositories.length > 0 && (contextMetadata = CompositeMetadataRepository.createMemoryComposite()) != null) {
            i = 0;
            while (i < this.contextMetadataRepositories.length) {
                contextMetadata.addChild(this.contextMetadataRepositories[i]);
                ++i;
            }
            if (contextMetadata.getChildren().size() > 0) {
                info.setContextMetadataRepository((IMetadataRepository)contextMetadata);
            }
        }
        if (this.contextArtifactRepositories != null && this.contextArtifactRepositories.length > 0 && (contextArtifact = CompositeArtifactRepository.createMemoryComposite()) != null) {
            i = 0;
            while (i < this.contextArtifactRepositories.length) {
                contextArtifact.addChild(this.contextArtifactRepositories[i]);
                ++i;
            }
            if (contextArtifact.getChildren().size() > 0) {
                info.setContextArtifactRepository((IArtifactRepository)contextArtifact);
            }
        }
    }

    protected void processCommandLineArguments(String[] args, PublisherInfo info) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            this.processFlag(args[i], info);
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                this.processParameter(args[i], args[++i], info);
            }
            ++i;
        }
    }

    protected void processParameter(String arg, String parameter, PublisherInfo info) throws URISyntaxException {
        try {
            if (arg.equalsIgnoreCase("-metadataRepository") || arg.equalsIgnoreCase("-mr")) {
                this.metadataLocation = URIUtil.fromString((String)parameter);
            }
            if (arg.equalsIgnoreCase("-artifactRepository") | arg.equalsIgnoreCase("-ar")) {
                this.artifactLocation = URIUtil.fromString((String)parameter);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Repository location (" + parameter + ") must be a URL.");
        }
        if (arg.equalsIgnoreCase("-metadataRepositoryName")) {
            this.metadataRepoName = parameter;
        }
        if (arg.equalsIgnoreCase("-source")) {
            if (!new File(parameter).exists()) {
                throw new IllegalArgumentException("Source location (" + parameter + ") must be a valid file-system path.");
            }
            this.source = parameter;
        }
        if (arg.equalsIgnoreCase("-artifactRepositoryName")) {
            this.artifactRepoName = parameter;
        }
        if (arg.equalsIgnoreCase("-configs")) {
            info.setConfigurations(AbstractPublisherAction.getArrayFromString(parameter, ","));
        }
        if (arg.equalsIgnoreCase("-contextMetadata")) {
            info.setContextMetadataRepository(this.processMetadataRepositoryList(parameter));
        }
        if (arg.equalsIgnoreCase("-contextArtifacts")) {
            info.setContextArtifactRepository(this.processArtifactRepositoryList(parameter));
        }
    }

    private IArtifactRepository processArtifactRepositoryList(String parameter) {
        String[] list = AbstractPublisherAction.getArrayFromString(parameter, ",");
        if (list == null || list.length == 0) {
            return null;
        }
        CompositeArtifactRepository result = CompositeArtifactRepository.createMemoryComposite();
        if (result != null) {
            int i = 0;
            while (i < list.length) {
                try {
                    result.addChild(URIUtil.fromString((String)list[i]));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return result;
    }

    private IMetadataRepository processMetadataRepositoryList(String parameter) {
        String[] list = AbstractPublisherAction.getArrayFromString(parameter, ",");
        if (list == null || list.length == 0) {
            return null;
        }
        CompositeMetadataRepository result = CompositeMetadataRepository.createMemoryComposite();
        if (result != null) {
            int i = 0;
            while (i < list.length) {
                try {
                    result.addChild(URIUtil.fromString((String)list[i]));
                }
                catch (URISyntaxException uRISyntaxException) {}
                ++i;
            }
        }
        return result;
    }

    protected void processFlag(String arg, PublisherInfo info) {
        if (arg.equalsIgnoreCase("-publishArtifacts") || arg.equalsIgnoreCase("-pa")) {
            info.setArtifactOptions(info.getArtifactOptions() | 2);
        }
        if (arg.equalsIgnoreCase("-publishArtifactRepository") || arg.equalsIgnoreCase("-par")) {
            info.setArtifactOptions(info.getArtifactOptions() | 1);
        }
        if (arg.equalsIgnoreCase("-overwriteArtifacts")) {
            info.setArtifactOptions(info.getArtifactOptions() | 4);
        }
        if (arg.equalsIgnoreCase("-append")) {
            this.append = true;
        }
        if (arg.equalsIgnoreCase("-compress")) {
            this.compress = true;
        }
        if (arg.equalsIgnoreCase("-reusePack200Files")) {
            this.reusePackedFiles = true;
        }
        if (arg.equalsIgnoreCase("-inplace")) {
            this.inplace = true;
        }
    }

    private void registerDefaultArtifactRepoManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName()) == null) {
            this.defaultArtifactManager = new ArtifactRepositoryManager();
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.registrationDefaultArtifactManager = bundleContext2.registerService(clazz2.getName(), (Object)this.defaultArtifactManager, null);
        }
    }

    private void registerDefaultMetadataRepoManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName()) == null) {
            this.defaultMetadataManager = new MetadataRepositoryManager();
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.registrationDefaultMetadataManager = bundleContext2.registerService(clazz2.getName(), (Object)this.defaultMetadataManager, null);
        }
    }

    private void registerEventBus() {
        if (ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME) == null) {
            this.bus = new ProvisioningEventBus();
            this.registrationBus = Activator.getContext().registerService(IProvisioningEventBus.SERVICE_NAME, (Object)this.bus, null);
        }
    }

    public Object run(String[] args) throws Exception {
        try {
            this.info = this.createPublisherInfo();
            this.processCommandLineArguments(args, this.info);
            Object result = this.run(this.info);
            if (result != IApplication.EXIT_OK) {
                int i = 0;
                while (i < args.length) {
                    System.out.println(args[i]);
                    ++i;
                }
            }
            return result;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            } else {
                e.printStackTrace(System.err);
            }
            throw e;
        }
    }

    protected PublisherInfo createPublisherInfo() {
        return new PublisherInfo();
    }

    public Object run(PublisherInfo info) throws Exception {
        block3: {
            try {
                this.registerEventBus();
                this.registerDefaultMetadataRepoManager();
                this.registerDefaultArtifactRepoManager();
                this.initialize(info);
                this.validateInfo(info);
                System.out.println(NLS.bind((String)Messages.message_generatingMetadata, (Object)info.getSummary()));
                long before = System.currentTimeMillis();
                IPublisherAction[] actions = this.createActions();
                Publisher publisher = this.createPublisher(info);
                IStatus result = publisher.publish(actions, (IProgressMonitor)new NullProgressMonitor());
                long after = System.currentTimeMillis();
                if (result.isOK()) {
                    System.out.println(NLS.bind((String)Messages.message_generationCompleted, (Object)String.valueOf((after - before) / 1000L)));
                    return IApplication.EXIT_OK;
                }
                System.out.println(result);
            }
            catch (ProvisionException e) {
                this.status = e.getStatus();
                if (this.status.getSeverity() != 4 || this.status.getMessage() == null) break block3;
                System.out.println(this.status.getMessage());
            }
        }
        return new Integer(1);
    }

    protected abstract IPublisherAction[] createActions();

    protected Publisher createPublisher(PublisherInfo info) {
        return new Publisher(info);
    }

    protected void validateInfo(PublisherInfo info) {
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run((String[])context.getArguments().get("application.args"));
    }

    public void stop() {
        if (this.registrationDefaultMetadataManager != null) {
            this.registrationDefaultMetadataManager.unregister();
            this.registrationDefaultMetadataManager = null;
        }
        if (this.registrationDefaultArtifactManager != null) {
            this.registrationDefaultArtifactManager.unregister();
            this.registrationDefaultArtifactManager = null;
        }
        if (this.registrationBus != null) {
            this.registrationBus.unregister();
            this.registrationBus = null;
        }
    }

    public void setArtifactLocation(URI location) {
        this.artifactLocation = location;
    }

    public void setMetadataLocation(URI location) {
        this.metadataLocation = location;
    }

    public boolean reuseExistingPack200Files() {
        return this.reusePackedFiles;
    }

    public void setReuseExistingPackedFiles(boolean value) {
        this.reusePackedFiles = value;
    }

    public void setContextRepositories(URI[] metadata, URI[] artifacts) {
        this.contextMetadataRepositories = metadata;
        this.contextArtifactRepositories = artifacts;
    }
}

