/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopClock {
    private static final Logger logger = LoggerFactory.getLogger(StopClock.class);
    private Unit units;
    private long startTime;
    private long stopTime;

    public StopClock() {
        this(Unit.ms);
    }

    public StopClock(Unit unit) {
        this.units = unit;
    }

    public void startClock() {
        this.startTime = this.units == Unit.ms ? System.currentTimeMillis() : System.nanoTime();
        this.stopTime = this.startTime;
    }

    public void stopClock() {
        this.stopTime = this.units == Unit.ms ? System.currentTimeMillis() : System.nanoTime();
    }

    public long getElapsedTime() {
        return this.stopTime - this.startTime;
    }

    public Unit getUnit() {
        return this.units;
    }

    public void reset() {
        this.startTime = 0L;
        this.stopTime = 0L;
    }

    public String toString() {
        return "Time taken: " + this.getElapsedTime() + (Object)((Object)this.units);
    }

    public void log() {
        System.out.println(this.toString());
    }

    public static enum Unit {
        ms,
        ns;

    }
}

