package aQute.rest.urlclient;

import java.io.*;
import java.lang.reflect.*;
import java.net.*;
import java.security.*;
import java.security.spec.*;
import java.text.*;
import java.util.*;
import java.util.Map.Entry;
import java.util.zip.*;

import aQute.lib.base64.*;
import aQute.lib.converter.*;
import aQute.lib.io.*;
import aQute.lib.json.*;
import aQute.service.reporter.*;

@SuppressWarnings("unchecked")
public class URLClient {
	private static final String	X_A_QUTE_AUTHORIZATION	= "X-aQute-Authorization";

	static SimpleDateFormat		httpFormat				= new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);

	static JSONCodec			codec					= new JSONCodec();
	static {
		// Hmm, some idiot (that was me) though it a good idea
		// to allow hex/base64 and made it optional. :-( This
		// bad idea was justly removed but now sometimes
		// we link to an old bndlib ... so we ensure it is
		// hex. If this fails, then we have a modern bndlib
		// and that always uses hex.
		try {
			Method m = JSONCodec.class.getMethod("setHex", boolean.class);
			m.invoke(codec, true);
		}
		catch (Exception e) {
			// Ignored
		}
	}

	final String				url;
	List<String>				cookies					= new ArrayList<String>();
	private Reporter			reporter;
	private String				email;
	private String				machine;
	private PrivateKey			privateKey;
	private PublicKey			publicKey;

	public URLClient(String baseurl) {
		if (baseurl.endsWith("/"))
			this.url = baseurl;
		else
			this.url = baseurl + "/";
	}

	<X> X send(String verb, String path, Object to, TypeReference<X> ref, Map<String,List<String>> arguments)
			throws Exception {
		return (X) send(verb, path, to, ref.getType(), arguments);
	}

	<X> X send(String verb, String path, Object to, Class<X> ref, Map<String,List<String>> arguments) throws Exception {
		return (X) send(verb, path, to, (Type) ref, arguments);
	}

	Object send(String verb, String path, Object to, Type ref, Map<String,List<String>> arguments) throws Exception {
		StringBuilder sb = new StringBuilder(url);
		if (path != null)
			sb.append(path);
		if (arguments != null) {
			String del = "?";
			for (Entry<String,List<String>> e : arguments.entrySet()) {
				for (Object o : e.getValue()) {
					sb.append(del);
					del = "&";
					sb.append(e.getKey());
					sb.append('=');
					sb.append(URLEncoder.encode(o.toString(), "UTF-8"));
				}
			}
		}
		URL url = new URL(sb.toString());
		try {
			HttpURLConnection con = (HttpURLConnection) url.openConnection();
			con.setRequestMethod(verb);

			if (to != null)
				con.setDoOutput(true);

			con.setRequestProperty("Accept-Encoding", "deflate, gzip");

			// if (cookies != null) {
			// for (String cookie : cookies) {
			// // TODO do we need to filter here?
			// // TODO expire?
			// con.addRequestProperty("Cookie", cookie);
			// }
			// }

			sign(con);

			if (to != null) {
				OutputStream out = con.getOutputStream();
				if (to instanceof InputStream)
					IO.copy((InputStream) to, out);
				else if (to instanceof byte[])
					IO.copy((byte[]) to, out);
				else if (to instanceof File)
					IO.copy((File) to, out);
				else {
					trace("-> " + to);
					codec.enc().to(out).put(to).flush();
				}
				out.close();
				trace("Sentx ");
			}

			int result = con.getResponseCode();
			if (result / 100 != 2) {
				trace("Error ");
				String s = "";
				InputStream in = con.getErrorStream();
				if (in != null)
					s = IO.collect(in);
				if (result == 404) {
					trace("not found ");
					return null;
				}

				throw new Exception("Failed request " + result + ":" + con.getResponseMessage() + " " + s);
			}

			InputStream in = con.getInputStream();
			try {
				trace("receiving ");
				String encoding = con.getHeaderField("Content-Encoding");
				if (encoding != null) {
					if (encoding.equalsIgnoreCase("deflate")) {
						in = new InflaterInputStream(in);
						trace("inflate");
					} else if (encoding.equalsIgnoreCase("gzip")) {
						in = new GZIPInputStream(in);
						trace("gzip");
					}
				}
				Map<String,List<String>> headerFields = con.getHeaderFields();
				List<String> l = headerFields.get("Set-Cookie");
				if (l != null)
					for (String c : l) {
						cookies.add(c);
					}

				String s = IO.collect(in);
				trace("got " + s);
				return codec.dec().from(s).get(ref);
			}
			finally {
				in.close();
			}
		}
		catch (Exception e) {
			throw new Exception(url.toExternalForm(), e);
		}
		finally {
			trace("<- " + url);
		}
	}

	private void trace(String string) {
		if (getReporter() != null)
			getReporter().trace(string);
	}

	public void put(String path, Object to) throws Exception {
		send("PUT", path, to, (Type) null, null);
	}

	public <T> T put(String path, Object to, Type type, Map<String,List<String>> args) throws Exception {
		return (T) send("PUT", path, to, type, args);
	}

	public <T> T get(String path, Type type, Map<String,List<String>> args) throws Exception {
		return (T) send("GET", path, null, type, args);
	}

	public Reporter getReporter() {
		return reporter;
	}

	public void setReporter(Reporter reporter) {
		this.reporter = reporter;
	}

	public void credentials(String email, String machine, byte[] publicKey, byte[] privateKey) throws Exception {
		this.email = email;
		this.machine = machine;

		if (publicKey != null && privateKey != null) {
			PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKey);
			X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKey);
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			this.privateKey = keyFactory.generatePrivate(privateKeySpec);
			this.publicKey = keyFactory.generatePublic(publicKeySpec);
		}
	}

	public void sign(URLConnection connection) throws Exception {		
		if (publicKey == null || email == null)
			return;

		// Build up Authorization header
		StringBuilder sb = new StringBuilder();
		sb.append(email).append("!");

		if (machine != null)
			sb.append(machine);

		sb.append("!").append(Base64.encodeBase64(publicKey.getEncoded())).append(":");

		// Get the date header, set it if not set

		String dateHeader = connection.getRequestProperty("Date");
		
		synchronized (httpFormat) {
			dateHeader = httpFormat.format(new Date());
		}
		connection.setRequestProperty("Date", dateHeader);

		// Ok, caculate the signature

		Signature hmac = Signature.getInstance("SHA1withRSA");
		hmac.initSign(privateKey);
		hmac.update(dateHeader.getBytes()); // never UTF-8

		// Finish the header
		sb.append(Base64.encodeBase64(hmac.sign()));

		connection.setRequestProperty(X_A_QUTE_AUTHORIZATION, sb.toString());
	}

	public String getUrl() {
		return url;
	}

	public String getEmail() {
		return email;
	}

	public URI getUri(String path) throws URISyntaxException {
		return new URI(url + path);
	}

	// private static TrustManager[] trustAllCerts;
	// private static HostnameVerifier trustAnyHost;
	// private static SSLContext sslContext;
	// private static SSLSocketFactory sslSocketFactory;

}
