package aQute.lib.bundle.support;

import java.io.*;

import org.osgi.framework.*;
import org.osgi.service.log.*;
import org.osgi.util.tracker.*;

public class LogStream extends OutputStream {
	StringBuffer	sb	= null;
	int				level;
	BundleContext	context;
	ServiceTracker	tracker;

	LogStream(BundleContext context, int level) {
		this.context = context;
		this.level = level;
		tracker = new ServiceTracker(context, LogService.class.getName(), null);
		tracker.open();
	}

	public void write(int c) {
		switch (c) {
			case '\n' :
			case '\r' :
				if (sb == null)
					return;
				else {
					log(sb.toString());
					sb = null;
				}
				break;

			case '\t' :
				c = ' ';

			default :
				if (sb == null)
					sb = new StringBuffer();
				sb.append((char) c);
				break;
		}
	}

	void log(String s) {
		LogService log = (LogService) tracker.getService();
		if (log != null)
			log.log(level, s);
		else
			System.out.println("LOG: " + s);
	}
}

