/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.alibaba.wisp.engine.WispTask;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.SharedSecrets;
import sun.misc.WispEngineAccess;

class WispSocketLockSupport {
    private static WispEngineAccess WEA = SharedSecrets.getWispEngineAccess();
    private final ReentrantLock readLock = WEA.enableSocketLock() ? new ReentrantLock() : null;
    private final ReentrantLock writeLock = WEA.enableSocketLock() ? new ReentrantLock() : null;
    private final ReentrantLock stateLock = WEA.enableSocketLock() ? new ReentrantLock() : null;
    WispTask blockedReadWispTask = null;
    WispTask blockedWriteWispTask = null;

    WispSocketLockSupport() {
    }

    private void lockRead() {
        this.readLock.lock();
    }

    private void lockWrite() {
        this.writeLock.lock();
    }

    private void unLockRead() {
        this.readLock.unlock();
    }

    private void unLockWrite() {
        this.writeLock.unlock();
    }

    void beginRead() {
        if (!WEA.enableSocketLock()) {
            return;
        }
        this.lockRead();
        this.stateLock.lock();
        try {
            this.blockedReadWispTask = WEA.getCurrentTask();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    void endRead() {
        if (!WEA.enableSocketLock()) {
            return;
        }
        this.stateLock.lock();
        try {
            this.blockedReadWispTask = null;
        }
        finally {
            this.stateLock.unlock();
        }
        this.unLockRead();
    }

    void beginWrite() {
        if (!WEA.enableSocketLock()) {
            return;
        }
        this.lockWrite();
        this.stateLock.lock();
        try {
            this.blockedWriteWispTask = WEA.getCurrentTask();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    void endWrite() {
        if (!WEA.enableSocketLock()) {
            return;
        }
        this.stateLock.lock();
        try {
            this.blockedWriteWispTask = null;
        }
        finally {
            this.stateLock.unlock();
        }
        this.unLockWrite();
    }

    void unparkBlockedWispTask() {
        this.stateLock.lock();
        try {
            if (this.blockedReadWispTask != null) {
                WEA.unpark(this.blockedReadWispTask);
                this.blockedReadWispTask = null;
            }
            if (this.blockedWriteWispTask != null) {
                WEA.unpark(this.blockedWriteWispTask);
                this.blockedWriteWispTask = null;
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }
}

