/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.filter.ClasspathScanningSupport;
import org.junit.vintage.engine.discovery.ClassSelectorResolver;
import org.junit.vintage.engine.discovery.ClasspathRootSelectorResolver;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.IsPotentialJUnit4TestClass;
import org.junit.vintage.engine.discovery.MethodSelectorResolver;
import org.junit.vintage.engine.discovery.ModuleNameSelectorResolver;
import org.junit.vintage.engine.discovery.PackageNameSelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;
import org.junit.vintage.engine.discovery.TestClassRequest;
import org.junit.vintage.engine.discovery.TestClassRequestResolver;
import org.junit.vintage.engine.discovery.UniqueIdSelectorResolver;

@API(status=API.Status.INTERNAL, since="4.12")
public class VintageDiscoverer {
    private static final IsPotentialJUnit4TestClass isPotentialJUnit4TestClass = new IsPotentialJUnit4TestClass();
    private final TestClassRequestResolver resolver = new TestClassRequestResolver();
    private final List<DiscoverySelectorResolver> selectorResolvers = Arrays.asList(new ClasspathRootSelectorResolver(), new ModuleNameSelectorResolver(), new PackageNameSelectorResolver(), new ClassSelectorResolver(), new MethodSelectorResolver(), new UniqueIdSelectorResolver());

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, "JUnit Vintage");
        this.collectTestClasses(discoveryRequest).toRequests().map(request -> this.resolver.createRunnerTestDescriptor((TestClassRequest)request, uniqueId)).filter(Objects::nonNull).forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).addChild(arg_0));
        return engineDescriptor;
    }

    private TestClassCollector collectTestClasses(EngineDiscoveryRequest discoveryRequest) {
        ClassFilter classFilter = ClassFilter.of((Predicate)ClasspathScanningSupport.buildClassNamePredicate((EngineDiscoveryRequest)discoveryRequest), (Predicate)isPotentialJUnit4TestClass);
        TestClassCollector collector = new TestClassCollector();
        for (DiscoverySelectorResolver selectorResolver : this.selectorResolvers) {
            selectorResolver.resolve(discoveryRequest, classFilter, collector);
        }
        return collector;
    }
}

