/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.io.LineReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Actions {
    static final String HEADER = "-- Merging decision tree log ---\n";
    private final Map<XmlNode.NodeKey, DecisionTreeRecord> mRecords;

    public Actions(Map<XmlNode.NodeKey, DecisionTreeRecord> records) {
        this.mRecords = records;
    }

    public Set<XmlNode.NodeKey> getNodeKeys() {
        return this.mRecords.keySet();
    }

    public ImmutableList<NodeRecord> getNodeRecords(XmlNode.NodeKey key) {
        return this.mRecords.containsKey(key) ? this.mRecords.get(key).getNodeRecords() : ImmutableList.of();
    }

    public ImmutableList<XmlNode.NodeName> getRecordedAttributeNames(XmlNode.NodeKey nodeKey) {
        DecisionTreeRecord decisionTreeRecord = this.mRecords.get(nodeKey);
        if (decisionTreeRecord == null) {
            return ImmutableList.of();
        }
        return decisionTreeRecord.getAttributesRecords().keySet().asList();
    }

    public ImmutableList<AttributeRecord> getAttributeRecords(XmlNode.NodeKey elementKey, XmlNode.NodeName attributeName) {
        DecisionTreeRecord decisionTreeRecord = this.mRecords.get(elementKey);
        if (decisionTreeRecord == null) {
            return ImmutableList.of();
        }
        return decisionTreeRecord.getAttributeRecords(attributeName);
    }

    void log(ILogger logger) {
        logger.verbose(this.getLogs(), new Object[0]);
    }

    void log(FileWriter fileWriter) throws IOException {
        fileWriter.append(this.getLogs());
    }

    private String getLogs() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HEADER);
        for (Map.Entry<XmlNode.NodeKey, DecisionTreeRecord> record : this.mRecords.entrySet()) {
            stringBuilder.append(record.getKey()).append("\n");
            for (NodeRecord nodeRecord : record.getValue().getNodeRecords()) {
                nodeRecord.print(stringBuilder);
                stringBuilder.append('\n');
            }
            for (Map.Entry<XmlNode.NodeName, List<AttributeRecord>> attributeRecords : record.getValue().mAttributeRecords.entrySet()) {
                stringBuilder.append('\t').append(attributeRecords.getKey()).append('\n');
                for (AttributeRecord attributeRecord : attributeRecords.getValue()) {
                    stringBuilder.append("\t\t");
                    attributeRecord.print(stringBuilder);
                    stringBuilder.append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    public String persist() throws IOException {
        GsonBuilder gson = new GsonBuilder().setPrettyPrinting();
        gson.enableComplexMapKeySerialization();
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gson);
        return gson.create().toJson((Object)this);
    }

    public static Actions load(InputStream inputStream) throws IOException {
        return (Actions)Actions.getGsonParser().fromJson((Reader)new InputStreamReader(inputStream), Actions.class);
    }

    public static Actions load(String xml) {
        return (Actions)Actions.getGsonParser().fromJson(xml, Actions.class);
    }

    private static Gson getGsonParser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.enableComplexMapKeySerialization();
        gsonBuilder.registerTypeAdapter(XmlNode.NodeName.class, (Object)new NodeNameDeserializer());
        MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
        return gsonBuilder.create();
    }

    public ImmutableMultimap<Integer, Record> getResultingSourceMapping(XmlDocument xmlDocument) throws ParserConfigurationException, SAXException, IOException {
        SourceFile inMemory = SourceFile.UNKNOWN;
        XmlDocument loadedWithLineNumbers = XmlLoader.load(xmlDocument.getSelectors(), xmlDocument.getSystemPropertyResolver(), inMemory, xmlDocument.prettyPrint(), XmlDocument.Type.MAIN, (Optional<String>)Optional.absent());
        ImmutableMultimap.Builder mappingBuilder = ImmutableMultimap.builder();
        for (XmlElement xmlElement : loadedWithLineNumbers.getRootNode().getMergeableElements()) {
            this.parse(xmlElement, (ImmutableMultimap.Builder<Integer, Record>)mappingBuilder);
        }
        return mappingBuilder.build();
    }

    private void parse(XmlElement element, ImmutableMultimap.Builder<Integer, Record> mappings) {
        DecisionTreeRecord decisionTreeRecord = this.mRecords.get(element.getId());
        if (decisionTreeRecord != null) {
            NodeRecord nodeRecord = Actions.findNodeRecord(decisionTreeRecord);
            if (nodeRecord != null) {
                mappings.put((Object)element.getPosition().getStartLine(), (Object)nodeRecord);
            }
            for (XmlAttribute xmlAttribute : element.getAttributes()) {
                AttributeRecord attributeRecord = Actions.findAttributeRecord(decisionTreeRecord, xmlAttribute);
                if (attributeRecord == null) continue;
                mappings.put((Object)xmlAttribute.getPosition().getStartLine(), (Object)attributeRecord);
            }
        }
        for (XmlElement xmlElement : element.getMergeableElements()) {
            this.parse(xmlElement, mappings);
        }
    }

    public String blame(XmlDocument xmlDocument) throws IOException, SAXException, ParserConfigurationException {
        String line;
        ImmutableMultimap<Integer, Record> resultingSourceMapping = this.getResultingSourceMapping(xmlDocument);
        LineReader lineReader = new LineReader((Readable)new StringReader(xmlDocument.prettyPrint()));
        StringBuilder actualMappings = new StringBuilder();
        int count = 0;
        while ((line = lineReader.readLine()) != null) {
            actualMappings.append(count + 1).append(line).append("\n");
            if (resultingSourceMapping.containsKey((Object)count)) {
                for (Record record : resultingSourceMapping.get((Object)count)) {
                    actualMappings.append(count + 1).append("-->").append(record.getActionLocation().toString()).append("\n");
                }
            }
            ++count;
        }
        return actualMappings.toString();
    }

    private static NodeRecord findNodeRecord(DecisionTreeRecord decisionTreeRecord) {
        for (NodeRecord nodeRecord : decisionTreeRecord.getNodeRecords()) {
            if (nodeRecord.getActionType() != ActionType.ADDED) continue;
            return nodeRecord;
        }
        return null;
    }

    private static AttributeRecord findAttributeRecord(DecisionTreeRecord decisionTreeRecord, XmlAttribute xmlAttribute) {
        for (AttributeRecord attributeRecord : decisionTreeRecord.getAttributeRecords(xmlAttribute.getName())) {
            if (attributeRecord.getActionType() != ActionType.ADDED) continue;
            return attributeRecord;
        }
        return null;
    }

    static class DecisionTreeRecord {
        private final List<NodeRecord> mNodeRecords = new ArrayList<NodeRecord>();
        final Map<XmlNode.NodeName, List<AttributeRecord>> mAttributeRecords = new HashMap<XmlNode.NodeName, List<AttributeRecord>>();

        ImmutableList<NodeRecord> getNodeRecords() {
            return ImmutableList.copyOf(this.mNodeRecords);
        }

        ImmutableMap<XmlNode.NodeName, List<AttributeRecord>> getAttributesRecords() {
            return ImmutableMap.copyOf(this.mAttributeRecords);
        }

        DecisionTreeRecord() {
        }

        void addNodeRecord(NodeRecord nodeRecord) {
            this.mNodeRecords.add((NodeRecord)Preconditions.checkNotNull((Object)nodeRecord));
        }

        ImmutableList<AttributeRecord> getAttributeRecords(XmlNode.NodeName attributeName) {
            List<AttributeRecord> attributeRecords = this.mAttributeRecords.get(attributeName);
            return attributeRecords == null ? ImmutableList.of() : ImmutableList.copyOf(attributeRecords);
        }
    }

    private static class NodeNameDeserializer
    implements JsonDeserializer<XmlNode.NodeName> {
        private NodeNameDeserializer() {
        }

        public XmlNode.NodeName deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.getAsJsonObject().get("mNamespaceURI") != null) {
                return (XmlNode.NodeName)context.deserialize(json, XmlNode.NamespaceAwareName.class);
            }
            return (XmlNode.NodeName)context.deserialize(json, XmlNode.Name.class);
        }
    }

    public static class AttributeRecord
    extends Record {
        private final AttributeOperationType mOperationType;

        AttributeRecord(ActionType actionType, SourceFilePosition actionLocation, XmlNode.NodeKey targetId, String reason, AttributeOperationType operationType) {
            super(actionType, actionLocation, targetId, reason);
            this.mOperationType = operationType;
        }

        public AttributeOperationType getOperationType() {
            return this.mOperationType;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("Id", (Object)this.mTargetId).add("actionType=", (Object)this.getActionType()).add("location", (Object)this.getActionLocation()).add("opType", (Object)this.getOperationType()).toString();
        }
    }

    public static class NodeRecord
    extends Record {
        private final NodeOperationType mNodeOperationType;

        NodeRecord(ActionType actionType, SourceFilePosition actionLocation, XmlNode.NodeKey targetId, String reason, NodeOperationType nodeOperationType) {
            super(actionType, actionLocation, targetId, reason);
            this.mNodeOperationType = (NodeOperationType)Preconditions.checkNotNull((Object)nodeOperationType);
        }

        public String toString() {
            return "Id=" + this.mTargetId.toString() + " actionType=" + (Object)((Object)this.getActionType()) + " location=" + this.getActionLocation() + " opType=" + this.mNodeOperationType;
        }
    }

    public static abstract class Record {
        protected final ActionType mActionType;
        protected final SourceFilePosition mActionLocation;
        protected final XmlNode.NodeKey mTargetId;
        protected final String mReason;

        private Record(ActionType actionType, SourceFilePosition actionLocation, XmlNode.NodeKey targetId, String reason) {
            this.mActionType = (ActionType)((Object)Preconditions.checkNotNull((Object)((Object)actionType)));
            this.mActionLocation = (SourceFilePosition)Preconditions.checkNotNull((Object)actionLocation);
            this.mTargetId = (XmlNode.NodeKey)Preconditions.checkNotNull((Object)targetId);
            this.mReason = reason;
        }

        public ActionType getActionType() {
            return this.mActionType;
        }

        public SourceFilePosition getActionLocation() {
            return this.mActionLocation;
        }

        public XmlNode.NodeKey getTargetId() {
            return this.mTargetId;
        }

        public void print(StringBuilder stringBuilder) {
            stringBuilder.append((Object)this.mActionType).append(" from ").append(this.mActionLocation);
            if (this.mReason != null) {
                stringBuilder.append(" reason: ").append(this.mReason);
            }
        }
    }

    static enum ActionType {
        ADDED,
        INJECTED,
        MERGED,
        REJECTED,
        IMPLIED;

    }
}

