/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessFixes;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="EqualsMissingNullable", summary="Method overrides Object.equals but does not have @Nullable on its parameter", severity=BugPattern.SeverityLevel.SUGGESTION)
public class EqualsMissingNullable
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!Matchers.equalsMethodDeclaration().matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        VariableTree parameterTree = (VariableTree)Iterables.getOnlyElement(methodTree.getParameters());
        Symbol.VarSymbol parameter = ASTHelpers.getSymbol((VariableTree)parameterTree);
        if (NullnessAnnotations.fromAnnotationsOn((Symbol)parameter).orElse(null) == Nullness.NULLABLE) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(parameterTree, (Fix)NullnessFixes.makeFix(state, parameterTree));
    }
}

