"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarkdownAction = void 0;
const BaseAction_1 = require("./BaseAction");
const MarkdownDocumenter_1 = require("../documenters/MarkdownDocumenter");
const HugoMarkdownDocumenter_1 = require("../documenters/grafana/HugoMarkdownDocumenter");
class MarkdownAction extends BaseAction_1.BaseAction {
    constructor(parser) {
        super({
            actionName: 'markdown',
            summary: 'Generate documentation as Markdown files (*.md)',
            documentation: 'Generates API documentation as a collection of files in' +
                ' Markdown format, suitable for example for publishing on a GitHub site.'
        });
    }
    onDefineParameters() {
        super.onDefineParameters();
        this._hugoParameter = this.defineFlagParameter({
            parameterLongName: '--hugo',
            description: `Enables some additional features specific to Grafana.com documentation.`
        });
        this._hugoDraftParameter = this.defineFlagParameter({
            parameterLongName: '--draft',
            description: `The documentation generated will be marked as draft.`
        });
    }
    onExecute() {
        // override
        const { apiModel, outputFolder } = this.buildApiModel();
        if (this._hugoParameter.value) {
            const markdownDocumenter = new HugoMarkdownDocumenter_1.HugoMarkdownDocumenter({
                model: apiModel,
                draft: this._hugoDraftParameter.value || false,
                output: outputFolder
            });
            markdownDocumenter.generateFiles();
            return Promise.resolve();
        }
        const markdownDocumenter = new MarkdownDocumenter_1.MarkdownDocumenter({
            apiModel,
            documenterConfig: undefined,
            outputFolder
        });
        markdownDocumenter.generateFiles();
        return Promise.resolve();
    }
}
exports.MarkdownAction = MarkdownAction;
//# sourceMappingURL=MarkdownAction.js.map