import { ByRoleMatcher, ByRoleOptions, Matcher, MatcherOptions, SelectorMatcherOptions, waitForOptions } from '@testing-library/dom';
declare type BoundAttribute = 'LabelText' | 'AltText' | 'DisplayValue' | 'TestId' | 'PlaceholderText' | 'Title';
declare type RTLSelector<ElType extends HTMLElement = HTMLElement> = {
    readonly get: (container?: HTMLElement) => ElType;
    readonly getAll: (container?: HTMLElement) => readonly ElType[];
    readonly find: (container?: HTMLElement, waitForOptions?: waitForOptions) => Promise<ElType>;
    readonly findAll: (container?: HTMLElement, waitForOptions?: waitForOptions) => Promise<readonly ElType[]>;
    readonly query: (container?: HTMLElement) => ElType | null;
    readonly queryAll: (container?: HTMLElement) => readonly ElType[];
};
export declare function byRole<ElType extends HTMLElement = HTMLElement>(role: ByRoleMatcher, options?: ByRoleOptions): RTLSelector<ElType>;
export declare function byText<ElType extends HTMLElement = HTMLElement>(id: Matcher, options?: SelectorMatcherOptions): RTLSelector<ElType>;
export declare function byBoundAttribute<ElType extends HTMLElement = HTMLElement>(attribute: BoundAttribute, id: Matcher, options?: MatcherOptions): RTLSelector<ElType>;
export declare function byLabelText<ElType extends HTMLElement = HTMLElement>(id: Matcher, options?: SelectorMatcherOptions): RTLSelector<ElType>;
export declare function byAltText<ElType extends HTMLElement = HTMLElement>(id: Matcher, options?: MatcherOptions): RTLSelector<ElType>;
export declare function byDisplayValue<ElType extends HTMLElement = HTMLElement>(id: Matcher, options?: MatcherOptions): RTLSelector<ElType>;
export declare function byTestId<ElType extends HTMLElement = HTMLElement>(id: Matcher, options?: MatcherOptions): RTLSelector<ElType>;
export declare function byPlaceholderText<ElType extends HTMLElement = HTMLElement>(id: Matcher, options?: MatcherOptions): RTLSelector<ElType>;
export declare function byTitle<ElType extends HTMLElement = HTMLElement>(id: Matcher, options?: MatcherOptions): RTLSelector<ElType>;
export {};
