import { BettererError } from '@betterer/errors';
import { BettererFilePaths } from '../fs';
import { BettererResult } from '../results';
import { BettererDiff } from '../test';
import { BettererDelta, BettererRun, BettererRunSummary } from './types';
export declare enum BettererRunStatus {
    better = 0,
    failed = 1,
    new = 2,
    same = 3,
    skipped = 4,
    update = 5,
    worse = 6
}
export declare class BettererRunSummaryΩ implements BettererRunSummary {
    readonly result: BettererResult | null;
    readonly baseline: BettererResult | null;
    readonly expected: BettererResult | null;
    readonly isComplete: boolean;
    readonly isExpired: boolean;
    readonly delta: BettererDelta | null;
    readonly diff: BettererDiff | null;
    readonly error: BettererError | null;
    readonly printed: string | null;
    readonly timestamp: number;
    readonly filePaths: BettererFilePaths | null;
    readonly name: string;
    readonly isBetter: boolean;
    readonly isFailed: boolean;
    readonly isNew: boolean;
    readonly isSame: boolean;
    readonly isSkipped: boolean;
    readonly isUpdated: boolean;
    readonly isWorse: boolean;
    constructor(run: BettererRun, result: BettererResult | null, baseline: BettererResult | null, expected: BettererResult | null, status: BettererRunStatus, isComplete: boolean, isExpired: boolean, delta: BettererDelta | null, diff: BettererDiff | null, error: BettererError | null, printed: string | null, timestamp: number);
}
//# sourceMappingURL=run-summary.d.ts.map