"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWatcher = exports.WATCHER_EVENTS = void 0;
const tslib_1 = require("tslib");
const chokidar_1 = require("chokidar");
const minimatch_1 = (0, tslib_1.__importDefault)(require("minimatch"));
const path = (0, tslib_1.__importStar)(require("path"));
const utils_1 = require("../utils");
exports.WATCHER_EVENTS = ['add', 'change'];
async function createWatcher(globals) {
    const { config } = globals;
    if (!config.watch) {
        return null;
    }
    const { cachePath, cwd, resultsPath } = config;
    const watcher = (0, chokidar_1.watch)(cwd, {
        ignoreInitial: true,
        ignored: (itemPath) => {
            itemPath = (0, utils_1.normalisedPath)(itemPath);
            const isCwd = itemPath === (0, utils_1.normalisedPath)(cwd);
            if (isCwd) {
                return false;
            }
            const isResultsPath = itemPath === (0, utils_1.normalisedPath)(resultsPath);
            const isCachePath = itemPath === (0, utils_1.normalisedPath)(cachePath);
            if (isResultsPath || isCachePath) {
                return true;
            }
            // read `ignores` here so that it can be updated by watch mode:
            const { ignores } = config;
            const watchIgnores = ignores.map((ignore) => path.join(cwd, ignore));
            const isIgnored = watchIgnores.some((ignore) => (0, minimatch_1.default)(itemPath, ignore, { matchBase: true }));
            return isIgnored;
        }
    });
    await new Promise((resolve, reject) => {
        watcher.on('ready', resolve);
        watcher.on('error', reject);
    });
    return watcher;
}
exports.createWatcher = createWatcher;
//# sourceMappingURL=watcher.js.map