"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cli__ = void 0;
const commander_1 = require("commander");
const ci_1 = require("./ci");
const init_1 = require("./init");
const merge_1 = require("./merge");
const precommit_1 = require("./precommit");
const start_1 = require("./start");
const results_1 = require("./results");
const types_1 = require("./types");
const watch_1 = require("./watch");
const upgrade_1 = require("./upgrade");
// HACK:
// It's easier to use require than to try to get `await import`
// to work right for the package.json...
/* eslint-disable @typescript-eslint/no-var-requires */
const { version } = require('../package.json');
/**
 * @internal This could change at any point! Please don't use!
 *
 * Run the **Betterer** command-line interface.
 */
async function cli__(cwd, argv, isCI = process.env.CI === 'true') {
    const program = new commander_1.Command('Betterer');
    program.version(version);
    // Init:
    program.addCommand((0, init_1.init)(cwd));
    // Run:
    program.addCommand((0, start_1.start)(cwd, isCI));
    program.addCommand((0, watch_1.watch)(cwd));
    // Precommit:
    // Throw if test run is worse, `git add` if better
    program.addCommand((0, precommit_1.precommit)(cwd));
    // CI:
    // Throw if test run creates a diff
    program.addCommand((0, ci_1.ci)(cwd));
    // Merge:
    program.addCommand((0, merge_1.merge)(cwd));
    // Results:
    program.addCommand((0, results_1.results)(cwd));
    // Upgrade:
    program.addCommand((0, upgrade_1.upgrade)(cwd));
    const args = argv.slice(0);
    const [, , command] = args;
    if (!types_1.BettererCommand[command]) {
        args.splice(2, 0, types_1.BettererCommand.start);
    }
    await program.parseAsync(args);
}
exports.cli__ = cli__;
//# sourceMappingURL=cli.js.map