// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2022 Alibaba Cloud. or its affiliates. All Rights Reserved.
 */

#include <linux/arm-smccc.h>
#include <linux/kvm_host.h>

#include <asm/kvm_mmu.h>
#include <asm/pvlock-abi.h>

#include <kvm/arm_hypercalls.h>

void kvm_pv_preempted_init(struct kvm_vcpu *vcpu)
{
	vcpu->arch.pv_preempted.guest_addr = 0;
}

void kvm_pv_preempted_update(struct kvm_vcpu *vcpu, bool preempted)
{
	gpa_t gpa = vcpu->arch.pv_preempted.guest_addr;

	if (gpa) {
		struct pv_vcpu_preempted value = {
			.preempted = cpu_to_le64(preempted),
		};
		kvm_write_guest_lock(vcpu->kvm, gpa, &value, sizeof(value));
	}
}

bool kvm_pv_preempted_enable(struct kvm_vcpu *vcpu)
{
	gpa_t gpa = smccc_get_arg1(vcpu);

	if (!gpa)
		return false;

	vcpu->arch.pv_preempted.guest_addr = gpa;
	kvm_pv_preempted_update(vcpu, vcpu->preempted);
	return true;
}
