// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2022 Alibaba Cloud. or its affiliates. All Rights Reserved.
 */

#include <linux/arm-smccc.h>
#include <linux/kvm_host.h>

#include <kvm/arm_hypercalls.h>
#include <kvm/arm_vgic.h>

bool kvm_pv_qspinlock_kick_cpu(struct kvm_vcpu *vcpu)
{
	int target_cpuid = smccc_get_arg1(vcpu);

	/* kick target cpu by IPI (SGI:0), which will mark vcpu runnable */
	kvm_vgic_inject_irq(vcpu->kvm, target_cpuid, 0, true, NULL);

	return true;
}
